/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.wires;

import com.ait.lienzo.client.core.shape.wires.PickerPart;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresShapeHighlight;
import com.ait.lienzo.client.core.shape.wires.handlers.impl.WiresShapeHighlightImpl;
import org.kie.workbench.common.stunner.client.lienzo.shape.animation.ShapeViewDecoratorAnimation;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.LienzoShapeView;
import org.kie.workbench.common.stunner.core.client.animation.Animation;
import org.kie.workbench.common.stunner.core.client.animation.AnimationHandle;
import org.uberfire.mvp.Command;

public class StunnerWiresShapeHighlight
implements WiresShapeHighlight<PickerPart.ShapePart> {
    private static final String HIGHLIGHT_COLOR = "#0000FF";
    private static final String ERROR_COLOR = "#FF0000";
    private static final double HIGHLIGHT_STROKE_PCT = 10.0;
    private static final double HIGHLIGHT_ALPHA = 1.0;
    private final WiresShapeHighlightImpl delegate;
    private AnimationHandle restoreAnimationHandle;
    private Animation restoreAnimation;

    public StunnerWiresShapeHighlight(WiresManager wiresManager) {
        this(new WiresShapeHighlightImpl(wiresManager.getDockingAcceptor().getHotspotSize()));
    }

    StunnerWiresShapeHighlight(WiresShapeHighlightImpl delegate) {
        this.delegate = delegate;
    }

    public void highlight(WiresShape shape, PickerPart.ShapePart part) {
        this.highlight(shape, part, HIGHLIGHT_COLOR);
    }

    public void error(WiresShape shape, PickerPart.ShapePart shapePart) {
        this.highlight(shape, shapePart, ERROR_COLOR);
    }

    public void restore() {
        this.restoreAnimation(() -> {});
        this.delegate.restore();
    }

    Animation getRestoreAnimation() {
        return this.restoreAnimation;
    }

    private void highlight(WiresShape shape, PickerPart.ShapePart part, String color) {
        switch (part) {
            case BODY: {
                this.highlightBody(shape, color);
                break;
            }
            default: {
                this.highlightBorder(shape);
            }
        }
    }

    private void highlightBody(WiresShape shape, String color) {
        if (shape instanceof LienzoShapeView) {
            this.highlightBody((LienzoShapeView)shape, color);
        } else {
            this.delegate.highlight(shape, PickerPart.ShapePart.BODY);
        }
    }

    void highlightBody(LienzoShapeView view, String color) {
        this.checkPreviousAnimation(view, () -> this.runAnimation(view, color));
    }

    private void checkPreviousAnimation(LienzoShapeView<?> view, Command runnable) {
        if (!(null == this.restoreAnimation || null != this.restoreAnimationHandle && this.restoreAnimationHandle.isRunning())) {
            if (view != this.restoreAnimation.getSource()) {
                this.restoreAnimation(() -> ((Command)runnable).execute());
            }
        } else if (null == this.restoreAnimation) {
            runnable.execute();
        }
    }

    private void runAnimation(LienzoShapeView view, String color) {
        String strokeColor = view.getStrokeColor();
        double strokeWidth = view.getStrokeWidth();
        double strokeAlpha = view.getStrokeAlpha();
        this.restoreAnimation = ShapeViewDecoratorAnimation.newStrokeDecoratorAnimation(() -> view, strokeColor, strokeWidth, strokeAlpha);
        ShapeViewDecoratorAnimation highlightAnimation = ShapeViewDecoratorAnimation.newStrokeDecoratorAnimation(() -> view, color, StunnerWiresShapeHighlight.calculateStrokeWidth(strokeWidth), 1.0);
        highlightAnimation.run();
    }

    static double calculateStrokeWidth(double value) {
        return value + value / 100.0 * 10.0;
    }

    private void highlightBorder(WiresShape shape) {
        this.delegate.highlight(shape, PickerPart.ShapePart.BORDER);
    }

    private void restoreAnimation(final Command onComplete) {
        if (null != this.restoreAnimation && null == this.restoreAnimationHandle) {
            this.restoreAnimation.setCallback(new Animation.AnimationCallback(){

                public void onStart() {
                }

                public void onFrame() {
                }

                public void onComplete() {
                    StunnerWiresShapeHighlight.this.restoreAnimation = null;
                    StunnerWiresShapeHighlight.this.restoreAnimationHandle = null;
                    onComplete.execute();
                }
            });
            this.restoreAnimationHandle = this.restoreAnimation.run();
        }
    }
}

