/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.wires;

import com.ait.lienzo.client.core.shape.wires.PickerPart;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresShapeHighlight;
import java.util.Objects;
import org.kie.workbench.common.stunner.client.lienzo.wires.StunnerWiresShapeHighlight;
import org.kie.workbench.common.stunner.core.client.shape.HasShapeState;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;

public class StunnerWiresShapeStateHighlight
implements WiresShapeHighlight<PickerPart.ShapePart> {
    private final StunnerWiresShapeHighlight delegate;
    private HasShapeState current;
    private PickerPart.ShapePart currentPartState;

    public StunnerWiresShapeStateHighlight(WiresManager wiresManager) {
        this(new StunnerWiresShapeHighlight(wiresManager));
    }

    StunnerWiresShapeStateHighlight(StunnerWiresShapeHighlight delegate) {
        this.delegate = delegate;
    }

    public void highlight(WiresShape shape, PickerPart.ShapePart part) {
        this.highlight(shape, part, ShapeState.HIGHLIGHT);
    }

    public void error(WiresShape shape, PickerPart.ShapePart shapePart) {
        this.highlight(shape, shapePart, ShapeState.INVALID);
    }

    public void restore() {
        if (null != this.current && (Objects.isNull(this.currentPartState) || Objects.equals(PickerPart.ShapePart.BODY, this.currentPartState))) {
            this.current.applyState(ShapeState.NONE);
            this.setCurrent(null);
        } else {
            this.delegate.restore();
        }
        this.currentPartState = null;
    }

    private void highlight(WiresShape shape, PickerPart.ShapePart part, ShapeState state) {
        this.currentPartState = part;
        switch (part) {
            case BODY: {
                this.highlightBody(shape, state);
                break;
            }
            default: {
                this.highlightBorder(shape);
            }
        }
    }

    private void highlightBody(WiresShape shape, ShapeState state) {
        this.restore();
        if (shape instanceof HasShapeState) {
            this.setCurrent((HasShapeState)shape);
            this.current.applyState(state);
        } else {
            this.delegate.highlight(shape, PickerPart.ShapePart.BODY);
        }
    }

    private void highlightBorder(WiresShape shape) {
        this.delegate.highlight(shape, PickerPart.ShapePart.BORDER);
    }

    void setCurrent(HasShapeState current) {
        this.current = current;
    }
}

