/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext;

import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.IControlHandleList;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShapeControlHandleList;
import com.ait.lienzo.client.core.shape.wires.event.AbstractWiresDragEvent;
import com.ait.lienzo.client.core.shape.wires.event.AbstractWiresResizeEvent;
import com.ait.lienzo.client.core.shape.wires.layout.AbstractContainerLayout;
import com.ait.lienzo.client.core.shape.wires.layout.label.LabelContainerLayout;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.LinearGradient;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.Map;
import java.util.Optional;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresShapeView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext.WiresTextDecorator;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoShapeUtils;
import org.kie.workbench.common.stunner.client.lienzo.util.ShapeControlPointsHelper;
import org.kie.workbench.common.stunner.core.client.shape.TextWrapperStrategy;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragContext;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public class WiresShapeViewExt<T extends WiresShapeViewExt>
extends WiresShapeView<T>
implements HasTitle<T>,
HasControlPoints<T>,
HasEventHandlers<T, Shape<?>>,
HasFillGradient<T> {
    private ViewEventHandlerManager eventHandlerManager;
    private WiresTextDecorator textViewDecorator;
    private HasFillGradient.Type fillGradientType;
    private String fillGradientStartColor;
    private String fillGradientEndColor;
    private Optional<LabelContainerLayout> labelContainerLayout = Optional.empty();

    public WiresShapeViewExt(ViewEventType[] supportedEventTypes, MultiPath path) {
        this(path, (LayoutContainer)new WiresLayoutContainer());
        this.setEventHandlerManager(new ViewEventHandlerManager((Node<?>)this.getGroup(), (Shape<?>)path, supportedEventTypes));
    }

    protected WiresShapeViewExt(MultiPath path, LayoutContainer layoutContainer) {
        super(path, layoutContainer);
        this.setListening(true);
    }

    protected void setEventHandlerManager(ViewEventHandlerManager eventHandlerManager) {
        this.eventHandlerManager = eventHandlerManager;
        this.setTextViewDecorator(new WiresTextDecorator(() -> eventHandlerManager, this));
    }

    protected ViewEventHandlerManager getEventHandlerManager() {
        return this.eventHandlerManager;
    }

    void setTextViewDecorator(WiresTextDecorator textViewDecorator) {
        this.textViewDecorator = textViewDecorator;
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public Shape<?> getAttachableShape() {
        return this.getShape();
    }

    public T setTitle(String title) {
        this.textViewDecorator.setTitle(title);
        this.addTextAsChild();
        return this.cast();
    }

    public T setMargins(Map<Enum, Double> margins) {
        this.textViewDecorator.setMargins((Map)margins);
        return this.cast();
    }

    public T setTitlePosition(HasTitle.VerticalAlignment verticalAlignment, HasTitle.HorizontalAlignment horizontalAlignment, HasTitle.ReferencePosition referencePosition, HasTitle.Orientation orientation) {
        this.textViewDecorator.setTitlePosition(verticalAlignment, horizontalAlignment, referencePosition, orientation);
        return this.cast();
    }

    public T setTextSizeConstraints(HasTitle.Size sizeConstraints) {
        this.textViewDecorator.setTextSizeConstraints(sizeConstraints);
        return this.cast();
    }

    public T setTitleXOffsetPosition(Double xOffset) {
        this.textViewDecorator.setTitleXOffsetPosition(xOffset);
        return this.cast();
    }

    public T setTitleYOffsetPosition(Double yOffset) {
        this.textViewDecorator.setTitleYOffsetPosition(yOffset);
        return this.cast();
    }

    public T setTitleRotation(double degrees) {
        this.textViewDecorator.setTitleRotation(degrees);
        return this.cast();
    }

    public T setTitleStrokeColor(String color) {
        this.textViewDecorator.setTitleStrokeColor(color);
        return this.cast();
    }

    public T setTitleFontFamily(String fontFamily) {
        this.textViewDecorator.setTitleFontFamily(fontFamily);
        return this.cast();
    }

    public T setTitleFontSize(double fontSize) {
        this.textViewDecorator.setTitleFontSize(fontSize);
        return this.cast();
    }

    public T setTitleFontColor(String fillColor) {
        this.textViewDecorator.setTitleFontColor(fillColor);
        return this.cast();
    }

    public T setTitleAlpha(double alpha) {
        this.textViewDecorator.setTitleAlpha(alpha);
        return this.cast();
    }

    public T setTitleStrokeWidth(double strokeWidth) {
        this.textViewDecorator.setTitleStrokeWidth(strokeWidth);
        return this.cast();
    }

    public T setTitleStrokeAlpha(double strokeAlpha) {
        this.textViewDecorator.setTitleStrokeAlpha(strokeAlpha);
        return this.cast();
    }

    public T setTextWrapper(TextWrapperStrategy wrapperStrategy) {
        this.textViewDecorator.setTextWrapper(wrapperStrategy);
        this.labelContainerLayout.ifPresent(AbstractContainerLayout::execute);
        return this.cast();
    }

    public T moveTitleToTop() {
        this.textViewDecorator.moveTitleToTop();
        return this.cast();
    }

    public T setFillGradient(HasFillGradient.Type type, String startColor, String endColor) {
        this.fillGradientType = type;
        this.fillGradientStartColor = startColor;
        this.fillGradientEndColor = endColor;
        if (null != this.getShape()) {
            BoundingBox bb = this.getShape().getBoundingBox();
            double width = bb.getWidth();
            double height = bb.getHeight();
            this.updateFillGradient(width, height);
        }
        return this.cast();
    }

    public void refresh() {
        this.getTextViewDecorator().update();
        super.refresh();
    }

    public T updateFillGradient(double width, double height) {
        if (this.fillGradientType != null && this.fillGradientStartColor != null && this.fillGradientEndColor != null) {
            LinearGradient gradient = LienzoShapeUtils.getLinearGradient(this.fillGradientStartColor, this.fillGradientEndColor, width, height);
            this.getShape().setFillGradient(gradient);
        }
        return this.cast();
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        IControlHandleList ctrls = this.loadControls(this.translate(type));
        if (null != ctrls && HasControlPoints.ControlPointType.RESIZE.equals((Object)type)) {
            ShapeControlPointsHelper.showOnlyLowerRightCP(ctrls);
        } else if (null != ctrls) {
            ctrls.show();
        }
        return this.cast();
    }

    public T updateControlPoints(HasControlPoints.ControlPointType type) {
        if (this.areControlsVisible()) {
            this.showControlPoints(type);
        }
        return this.cast();
    }

    public T hideControlPoints() {
        WiresShapeControlHandleList ctrls = this.getControls();
        if (null != ctrls) {
            ctrls.hide();
        }
        return this.cast();
    }

    public boolean areControlsVisible() {
        return null != this.getControls() && this.getControls().isVisible();
    }

    @Override
    public void destroy() {
        super.destroy();
        if (null != this.textViewDecorator) {
            this.textViewDecorator.destroy();
        }
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
        this.fillGradientEndColor = null;
        this.fillGradientStartColor = null;
        this.fillGradientType = null;
    }

    public T addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        if (this.supports(type)) {
            boolean delegate = true;
            if (ViewEventType.DRAG.equals((Object)type)) {
                HandlerRegistration[] registrations = this.registerDragHandler((ViewHandler<DragEvent>)((DragHandler)eventHandler));
                if (null != registrations) {
                    this.eventHandlerManager.addHandlersRegistration(type, registrations);
                }
                delegate = false;
            } else if (ViewEventType.RESIZE.equals((Object)type)) {
                HandlerRegistration[] registrations = this.registerResizeHandler((ViewHandler<ResizeEvent>)((ResizeHandler)eventHandler));
                if (null != registrations) {
                    this.eventHandlerManager.addHandlersRegistration(type, registrations);
                }
                delegate = false;
            }
            if (ViewEventType.TEXT_ENTER.equals((Object)type)) {
                delegate = false;
                this.textViewDecorator.setTextEnterHandler(eventHandler);
            }
            if (ViewEventType.TEXT_EXIT.equals((Object)type)) {
                this.textViewDecorator.setTextExitHandler(eventHandler);
                delegate = false;
            }
            if (ViewEventType.TEXT_CLICK.equals((Object)type)) {
                this.textViewDecorator.setTextClickHandler(eventHandler);
                delegate = false;
            }
            if (ViewEventType.TEXT_DBL_CLICK.equals((Object)type)) {
                this.textViewDecorator.setTextDblClickHandler(eventHandler);
            }
            if (delegate) {
                this.eventHandlerManager.addHandler(type, eventHandler);
            }
        }
        return this.cast();
    }

    public T removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return this.cast();
    }

    public T enableHandlers() {
        this.eventHandlerManager.enable();
        return this.cast();
    }

    public T disableHandlers() {
        this.eventHandlerManager.disable();
        return this.cast();
    }

    protected WiresTextDecorator getTextViewDecorator() {
        return this.textViewDecorator;
    }

    protected void rebuildTextBoundaries(double width, double height) {
        this.textViewDecorator.setTextBoundaries(width, height);
    }

    public void setTextBoundaries(double width, double height) {
        this.rebuildTextBoundaries(width, height);
    }

    private void addTextAsChild() {
        this.labelContainerLayout = Optional.of(this.addLabel(this.textViewDecorator.getView(), this.textViewDecorator.getLabelLayout()));
        this.textViewDecorator.getView().setListening(true);
    }

    public Optional<LabelContainerLayout> getLabelContainerLayout() {
        return this.labelContainerLayout;
    }

    private IControlHandle.ControlHandleType translate(HasControlPoints.ControlPointType type) {
        if (type.equals((Object)HasControlPoints.ControlPointType.RESIZE)) {
            return IControlHandle.ControlHandleStandardType.RESIZE;
        }
        return IControlHandle.ControlHandleStandardType.MAGNET;
    }

    private HandlerRegistration[] registerDragHandler(ViewHandler<DragEvent> eventHandler) {
        if (!this.getAttachableShape().isDraggable()) {
            DragHandler dragHandler = (DragHandler)eventHandler;
            this.setDragEnabled(true);
            HandlerRegistration dragStartReg = this.addWiresDragStartHandler(wiresDragStartEvent -> {
                DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragStartEvent);
                dragHandler.start(e);
            });
            HandlerRegistration dragMoveReg = this.addWiresDragMoveHandler(wiresDragMoveEvent -> {
                DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragMoveEvent);
                dragHandler.handle((ViewEvent)e);
            });
            HandlerRegistration dragEndReg = this.addWiresDragEndHandler(wiresDragEndEvent -> {
                DragEvent e = this.buildDragEvent((AbstractWiresDragEvent)wiresDragEndEvent);
                dragHandler.end(e);
            });
            return new HandlerRegistration[]{dragStartReg, dragMoveReg, dragEndReg};
        }
        return null;
    }

    private HandlerRegistration[] registerResizeHandler(ViewHandler<ResizeEvent> eventHandler) {
        ResizeHandler resizeHandler = (ResizeHandler)eventHandler;
        this.setResizable(true);
        HandlerRegistration r0 = this.addWiresResizeStartHandler(wiresResizeStartEvent -> {
            ResizeEvent event = this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeStartEvent);
            resizeHandler.start(event);
        });
        HandlerRegistration r1 = this.addWiresResizeStepHandler(wiresResizeStepEvent -> {
            ResizeEvent event = this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeStepEvent);
            resizeHandler.handle((ViewEvent)event);
            this.rebuildTextBoundaries(event.getWidth(), event.getHeight());
        });
        HandlerRegistration r2 = this.addWiresResizeEndHandler(wiresResizeEndEvent -> {
            ResizeEvent event = this.buildResizeEvent((AbstractWiresResizeEvent)wiresResizeEndEvent);
            resizeHandler.end(event);
        });
        return new HandlerRegistration[]{r0, r1, r2};
    }

    protected DragEvent buildDragEvent(AbstractWiresDragEvent sourceDragEvent) {
        double x = sourceDragEvent.getX();
        double y = sourceDragEvent.getY();
        double cx = sourceDragEvent.getNodeDragEvent().getX();
        double cy = sourceDragEvent.getNodeDragEvent().getY();
        int dx = sourceDragEvent.getNodeDragEvent().getDragContext().getDx();
        int dy = sourceDragEvent.getNodeDragEvent().getDragContext().getDy();
        DragContext dragContext = new DragContext(dx, dy, () -> sourceDragEvent.getNodeDragEvent().getDragContext().reset());
        return new DragEvent(x, y, cx, cy, dragContext);
    }

    protected ResizeEvent buildResizeEvent(AbstractWiresResizeEvent sourceResizeEvent) {
        double x = sourceResizeEvent.getX();
        double y = sourceResizeEvent.getY();
        double cx = sourceResizeEvent.getNodeDragEvent().getX();
        double cy = sourceResizeEvent.getNodeDragEvent().getY();
        double w = sourceResizeEvent.getWidth();
        double h = sourceResizeEvent.getHeight();
        return new ResizeEvent(x, y, cx, cy, w, h);
    }

    protected T cast() {
        return (T)this;
    }
}

