/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.widget.panel.LienzoPanel;
import com.ait.lienzo.client.widget.panel.impl.LienzoPanelImpl;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderer;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderers;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.ShapeGlyphDragHandler;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.uberfire.mvp.Command;

@Dependent
public class ShapeGlyphDragHandlerImpl
implements ShapeGlyphDragHandler<AbstractCanvas> {
    private final LienzoGlyphRenderer<Glyph> glyphLienzoGlyphRenderer;
    private final List<HandlerRegistration> handlerRegistrations;
    private final Supplier<AbsolutePanel> rootPanelSupplier;
    private final Function<ShapeGlyphDragHandler.Item, LienzoPanel> lienzoPanelBuilder;
    private final BiConsumer<Command, Integer> timer;
    private LienzoPanel dragProxyPanel;

    @Inject
    public ShapeGlyphDragHandlerImpl(LienzoGlyphRenderers glyphLienzoGlyphRenderer) {
        this(glyphLienzoGlyphRenderer, new ArrayList<HandlerRegistration>(), RootPanel::get, item -> new LienzoPanelImpl(item.getWidth() * 2, item.getHeight() * 2), (task, millis) -> new Timer((Command)task){
            final /* synthetic */ Command val$task;
            {
                this.val$task = command;
            }

            public void run() {
                this.val$task.execute();
            }
        }.schedule(millis.intValue()));
    }

    ShapeGlyphDragHandlerImpl(LienzoGlyphRenderer<Glyph> glyphLienzoGlyphRenderer, List<HandlerRegistration> handlerRegistrations, Supplier<AbsolutePanel> rootPanelSupplier, Function<ShapeGlyphDragHandler.Item, LienzoPanel> lienzoPanelBuilder, BiConsumer<Command, Integer> timer) {
        this.glyphLienzoGlyphRenderer = glyphLienzoGlyphRenderer;
        this.handlerRegistrations = handlerRegistrations;
        this.rootPanelSupplier = rootPanelSupplier;
        this.lienzoPanelBuilder = lienzoPanelBuilder;
        this.timer = timer;
    }

    public DragProxy<AbstractCanvas, ShapeGlyphDragHandler.Item, DragProxyCallback> proxyFor(AbstractCanvas context) {
        return this;
    }

    public DragProxy<AbstractCanvas, ShapeGlyphDragHandler.Item, DragProxyCallback> show(ShapeGlyphDragHandler.Item item, int x, int y, DragProxyCallback dragProxyCallback) {
        Layer dragProxyLayer = new Layer();
        this.dragProxyPanel = this.lienzoPanelBuilder.apply(item);
        this.dragProxyPanel.add(dragProxyLayer);
        this.attachHandlers(dragProxyCallback);
        dragProxyLayer.add((IPrimitive)((Group)((Group)this.glyphLienzoGlyphRenderer.render(item.getShape(), item.getWidth(), item.getHeight())).setX(0.0)).setY(0.0));
        this.moveProxyTo(x, y);
        this.rootPanelSupplier.get().add((Widget)this.dragProxyPanel);
        return this;
    }

    public void clear() {
        this.clearState(() -> this.dragProxyPanel.clear());
    }

    public void destroy() {
        this.clearState(() -> this.dragProxyPanel.destroy());
    }

    private void moveProxyTo(double x, double y) {
        Style style = this.dragProxyPanel.getElement().getStyle();
        style.setCursor(Style.Cursor.AUTO);
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(x, Style.Unit.PX);
        style.setTop(y, Style.Unit.PX);
        style.setZIndex(Integer.MAX_VALUE);
    }

    private void attachHandlers(DragProxyCallback callback) {
        AbsolutePanel root = this.rootPanelSupplier.get();
        this.register(root.addDomHandler((EventHandler)((MouseMoveHandler)event -> this.onMouseMove(event, callback)), MouseMoveEvent.getType()));
        this.timer.accept(() -> this.register(root.addDomHandler((EventHandler)((MouseUpHandler)event -> this.onMouseUp(event, callback)), MouseUpEvent.getType())), 200);
        this.register(root.addDomHandler((EventHandler)((KeyDownHandler)this::onKeyDown), KeyDownEvent.getType()));
    }

    void onMouseMove(MouseMoveEvent event, DragProxyCallback callback) {
        Style proxyPanelStyle = this.dragProxyPanel.getElement().getStyle();
        proxyPanelStyle.setLeft((double)event.getX(), Style.Unit.PX);
        proxyPanelStyle.setTop((double)event.getY(), Style.Unit.PX);
        callback.onMove(event.getClientX(), event.getClientY());
    }

    void onMouseUp(MouseUpEvent event, DragProxyCallback callback) {
        this.clearHandlers();
        this.rootPanelSupplier.get().remove((Widget)this.dragProxyPanel);
        callback.onComplete(event.getClientX(), event.getClientY());
    }

    void onKeyDown(KeyDownEvent event) {
        this.clear();
    }

    private void register(HandlerRegistration registration) {
        this.handlerRegistrations.add(registration);
    }

    private void clearHandlers() {
        this.handlerRegistrations.stream().forEach(com.google.web.bindery.event.shared.HandlerRegistration::removeHandler);
        this.handlerRegistrations.clear();
    }

    private void clearState(Command proxyDestroyCommand) {
        this.clearHandlers();
        if (Objects.nonNull(this.dragProxyPanel)) {
            this.rootPanelSupplier.get().remove((Widget)this.dragProxyPanel);
            proxyDestroyCommand.execute();
            this.dragProxyPanel = null;
        }
    }
}

