/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.mediators;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.widget.panel.LienzoBoundsPanel;
import com.ait.lienzo.client.widget.panel.scrollbars.ScrollablePanel;
import com.ait.lienzo.client.widget.panel.util.PanelTransformUtils;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvasView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoPanel;
import org.kie.workbench.common.stunner.client.lienzo.components.mediators.ZoomLevelSelector;
import org.kie.workbench.common.stunner.core.client.components.views.FloatingView;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;

@Dependent
public class ZoomLevelSelectorPresenter {
    private static final double LEVEL_STEP = 0.1;
    static final String LEVEL_25 = "25%";
    static final String LEVEL_50 = "50%";
    static final String LEVEL_75 = "75%";
    static final String LEVEL_100 = "100%";
    static final String LEVEL_150 = "150%";
    static final String LEVEL_200 = "200%";
    private final ClientTranslationService translationService;
    private final FloatingView<IsWidget> floatingView;
    private final ZoomLevelSelector selector;
    private Supplier<LienzoCanvas> canvas;
    private double minScale;
    private double maxScale;
    private double zoomFactor;
    private HandlerRegistration panelResizeHandlerRegistration;
    private HandlerRegistration transformChangedHandler;
    private HandlerRegistration selectorOverHandler;
    private Timer hideTimer;

    @Inject
    public ZoomLevelSelectorPresenter(ClientTranslationService translationService, FloatingView<IsWidget> floatingView, ZoomLevelSelector selector) {
        this.translationService = translationService;
        this.floatingView = floatingView;
        this.selector = selector;
        this.minScale = 0.0;
        this.maxScale = Double.MAX_VALUE;
        this.zoomFactor = 0.1;
    }

    @PostConstruct
    public void construct() {
        this.floatingView.clearTimeOut().setOffsetX(0.0).setOffsetY(0.0).hide();
        this.hideTimer = new Timer(){

            public void run() {
                ZoomLevelSelectorPresenter.this.hide();
            }
        };
    }

    public ZoomLevelSelectorPresenter init(Supplier<LienzoCanvas> canvas) {
        this.canvas = canvas;
        Layer layer = this.getLayer();
        LienzoPanel panel = this.getPanel();
        this.selector.setText(ZoomLevelSelectorPresenter.parseLevel(1.0)).dropUp().onReset(this::reset).onIncreaseLevel(this::increaseLevel).onDecreaseLevel(this::decreaseLevel).add(LEVEL_25, () -> this.setLevel(0.25)).add(LEVEL_50, () -> this.setLevel(0.5)).add(LEVEL_75, () -> this.setLevel(0.75)).add(LEVEL_100, () -> this.setLevel(1.0)).add(LEVEL_150, () -> this.setLevel(1.5)).add(LEVEL_200, () -> this.setLevel(2.0)).add(this.translationService.getNotNullValue("org.kie.workbench.common.stunner.core.fit"), () -> this.setLevel(PanelTransformUtils.computeZoomLevelFitToWidth((LienzoBoundsPanel)panel.getView())));
        this.floatingView.add((Object)this.selector);
        if (panel.getView() instanceof ScrollablePanel) {
            ScrollablePanel scrollablePanel = (ScrollablePanel)panel.getView();
            this.panelResizeHandlerRegistration = scrollablePanel.addLienzoPanelResizeEventHandler(event -> this.onPanelResize(event.getWidth(), event.getHeight()));
        }
        this.reposition();
        this.transformChangedHandler = layer.getViewport().addViewportTransformChangedHandler(event -> this.onViewportTransformChanged());
        this.selectorOverHandler = this.selector.asWidget().addDomHandler((EventHandler)((MouseOverHandler)mouseOverEvent -> this.cancelHide()), MouseOverEvent.getType());
        return this;
    }

    public ZoomLevelSelectorPresenter setMinScale(double minScale) {
        this.minScale = minScale;
        return this;
    }

    public ZoomLevelSelectorPresenter setMaxScale(double maxScale) {
        this.maxScale = maxScale;
        return this;
    }

    public ZoomLevelSelectorPresenter setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
        return this;
    }

    public ZoomLevelSelectorPresenter at(double x, double y) {
        this.floatingView.setX(x).setY(y);
        return this;
    }

    public ZoomLevelSelectorPresenter show() {
        this.cancelHide();
        this.floatingView.show();
        return this;
    }

    public ZoomLevelSelectorPresenter hide() {
        this.floatingView.hide();
        return this;
    }

    void cancelHide() {
        this.hideTimer.cancel();
    }

    void scheduleHide() {
        this.cancelHide();
        this.hideTimer.schedule(250);
    }

    @PreDestroy
    public void destroy() {
        this.cancelHide();
        if (null != this.panelResizeHandlerRegistration) {
            this.panelResizeHandlerRegistration.removeHandler();
            this.panelResizeHandlerRegistration = null;
        }
        if (null != this.transformChangedHandler) {
            this.transformChangedHandler.removeHandler();
            this.transformChangedHandler = null;
        }
        if (null != this.selectorOverHandler) {
            this.selectorOverHandler.removeHandler();
            this.selectorOverHandler = null;
        }
        this.floatingView.destroy();
        this.canvas = null;
        this.hideTimer = null;
    }

    private void onViewportTransformChanged() {
        double level = PanelTransformUtils.computeLevel((Viewport)this.getLayer().getViewport());
        this.updateSelectorLevel(level);
    }

    private void reposition() {
        LienzoPanel panel = this.getPanel();
        this.onPanelResize(panel.getView().getWidthPx(), panel.getView().getHeightPx());
    }

    private ZoomLevelSelectorPresenter onPanelResize(double width, double height) {
        LienzoPanel panel = this.getPanel();
        int absoluteLeft = panel.getView().getAbsoluteLeft();
        int absoluteTop = panel.getView().getAbsoluteTop();
        double x = (double)absoluteLeft + width - 174.0;
        double y = (double)absoluteTop + height - 50.0;
        return this.at(x, y);
    }

    private double increaseLevel() {
        return this.setLevel(this.getLevel() + this.zoomFactor);
    }

    private double decreaseLevel() {
        return this.setLevel(this.getLevel() - this.zoomFactor);
    }

    private double getLevel() {
        return PanelTransformUtils.computeLevel((Viewport)this.getLayer().getViewport());
    }

    private void reset() {
        PanelTransformUtils.reset((Viewport)this.getLayer().getViewport());
        this.getLayer().batch();
    }

    private double setLevel(double level) {
        if (level < this.minScale) {
            return this._setLevel(this.minScale);
        }
        if (level > this.maxScale) {
            return this._setLevel(this.maxScale);
        }
        return this._setLevel(level);
    }

    private double _setLevel(double level) {
        PanelTransformUtils.setScaleLevel((Viewport)this.getLayer().getViewport(), (double)level);
        this.getLayer().batch();
        this.updateSelectorLevel(level);
        return level;
    }

    private void updateSelectorLevel(double level) {
        this.selector.setText(ZoomLevelSelectorPresenter.parseLevel(level));
    }

    private Layer getLayer() {
        return ((LienzoLayer)((LienzoCanvasView)this.canvas.get().getView()).getLayer()).getLienzoLayer();
    }

    private LienzoPanel getPanel() {
        return (LienzoPanel)this.canvas.get().getView().getPanel();
    }

    private static String parseLevel(double level) {
        return Double.valueOf(level * 100.0).intValue() + "%";
    }
}

