/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires;

import com.ait.lienzo.client.core.Attribute;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayoutContainer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.tooling.nativetools.client.collection.NFastArrayList;
import java.util.function.Predicate;

public class WiresScalableContainer
extends WiresLayoutContainer {
    private final NFastArrayList<IPrimitive<?>> scalableChildren = new NFastArrayList();
    private Group transformableContainer;
    private Point2D scaleRatio;
    private boolean scaleRequired;

    public WiresScalableContainer() {
        this(null);
    }

    WiresScalableContainer(Group transformableContainer) {
        this.transformableContainer = transformableContainer;
    }

    public WiresScalableContainer setScaleRatio(Point2D scaleRatio) {
        this.scaleRatio = scaleRatio;
        return this;
    }

    private boolean isScalable(IPrimitive<?> child) {
        return this.hasWidthHeight().test(child);
    }

    private void scaleChildTo(IPrimitive<?> child, double x, double y, double width, double height) {
        if (this.hasWidthHeight().test(child)) {
            if (width > 0.0) {
                child.getAttributes().setWidth(width);
            }
            if (height > 0.0) {
                child.getAttributes().setHeight(height);
            }
        }
        child.getAttributes().setX(x);
        child.getAttributes().setY(y);
    }

    public WiresScalableContainer addScalable(IPrimitive<?> child) {
        if (this.isScalable(child)) {
            this.scalableChildren.add(child);
            this.add(child);
        } else {
            if (null == this.transformableContainer) {
                this.transformableContainer = new Group();
                this.addChild((IPrimitive)this.transformableContainer);
            }
            this.transformableContainer.add(child);
            this.scaleRatio = null;
        }
        this.scaleRequired = true;
        return this;
    }

    public WiresLayoutContainer setSize(double width, double height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            this.scaleRatio = null;
            this.scaleRequired = true;
        }
        super.setSize(width, height);
        return this;
    }

    public LayoutContainer execute() {
        this.scaleTo(this.getOffset().getX(), this.getOffset().getY(), this.getWidth(), this.getHeight());
        return super.execute();
    }

    public void scaleTo(double x, double y, double width, double height) {
        if (this.scaleRequired) {
            if (null != this.transformableContainer) {
                ((Group)this.transformableContainer.setX(x)).setY(y);
                if (null == this.scaleRatio) {
                    BoundingBox bb = this.transformableContainer.getBoundingBox();
                    double sx = width / bb.getWidth();
                    double sy = height / bb.getHeight();
                    this.scaleRatio = new Point2D(sx, sy);
                    this.transformableContainer.setScale(this.scaleRatio);
                }
            }
            for (int i = 0; i < this.scalableChildren.size(); ++i) {
                IPrimitive child = (IPrimitive)this.scalableChildren.get(i);
                this.scaleChildTo(child, x, y, width, height);
            }
            this.scaleRequired = false;
        }
    }

    private double getWidth(IPrimitive<?> prim) {
        return prim.getAttributes().getDouble(Attribute.WIDTH.getProperty());
    }

    private double getHeight(IPrimitive<?> prim) {
        return prim.getAttributes().getDouble(Attribute.HEIGHT.getProperty());
    }

    private Predicate<IPrimitive> hasWidthHeight() {
        return primitive -> this.getWidth((IPrimitive<?>)primitive) > 0.0 && this.getHeight((IPrimitive<?>)primitive) > 0.0;
    }
}

