/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.types.BoundingBox;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderer;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoUtils;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeGlyph;

@ApplicationScoped
public class LienzoShapeGlyphRenderer
implements LienzoGlyphRenderer<ShapeGlyph> {
    private final FactoryManager factoryManager;
    private final Function<ShapeView<?>, BoundingBox> boundingBoxProvider;
    private final Function<ShapeView<?>, Group> groupProvider;

    protected LienzoShapeGlyphRenderer() {
        this(null);
    }

    @Inject
    public LienzoShapeGlyphRenderer(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
        this.boundingBoxProvider = LienzoShapeGlyphRenderer::getBoundingBox;
        this.groupProvider = LienzoShapeGlyphRenderer::getGroup;
    }

    LienzoShapeGlyphRenderer(FactoryManager factoryManager, Function<ShapeView<?>, BoundingBox> boundingBoxProvider, Function<ShapeView<?>, Group> groupProvider) {
        this.factoryManager = factoryManager;
        this.boundingBoxProvider = boundingBoxProvider;
        this.groupProvider = groupProvider;
    }

    public Class<ShapeGlyph> getGlyphType() {
        return ShapeGlyph.class;
    }

    public Group render(ShapeGlyph glyph, double width, double height) {
        String definitionId = glyph.getDefinitionId();
        Supplier factorySupplier = glyph.getFactorySupplier();
        Shape shape = ((ShapeFactory)factorySupplier.get()).newShape(this.factoryManager.newDefinition(definitionId));
        ShapeView view = shape.getShapeView();
        BoundingBox bb = this.boundingBoxProvider.apply(view);
        Group group = this.groupProvider.apply(view);
        if (null == group) {
            throw new RuntimeException("Shape view [" + view.toString() + "] not supported for this shape glyph builder [" + this.getClass().getName());
        }
        if (view instanceof HasTitle) {
            HasTitle hasTitle = (HasTitle)view;
            hasTitle.setTitle(null);
        }
        group = (Group)group.copy();
        double[] scale = LienzoUtils.getScaleFactor(bb.getWidth(), bb.getHeight(), width, height);
        group.setScale(scale[0], scale[1]);
        return group;
    }

    private static BoundingBox getBoundingBox(ShapeView<?> view) {
        if (view instanceof WiresShape) {
            return ((WiresShape)view).getPath().getBoundingBox();
        }
        if (view instanceof WiresConnector) {
            WiresConnector wiresConnector = (WiresConnector)view;
            return wiresConnector.getGroup().getBoundingBox();
        }
        return null;
    }

    private static Group getGroup(ShapeView<?> view) {
        if (view instanceof WiresShape) {
            return ((WiresShape)view).getGroup();
        }
        if (view instanceof WiresConnector) {
            WiresConnector wiresConnector = (WiresConnector)view;
            return wiresConnector.getGroup();
        }
        return null;
    }
}

