/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires;

import com.ait.lienzo.client.core.shape.AbstractDirectionalMultiPointShape;
import com.ait.lienzo.client.core.shape.MultiPathDecorator;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnection;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresConnectorControl;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDecorators;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.DiscreteConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

public class WiresConnectorView<T>
extends WiresConnector
implements ShapeView<T>,
IsConnector<T>,
HasControlPoints<T>,
HasDecorators<Shape<?>> {
    protected String uuid;
    private WiresConnectorControl connectorControl;

    public WiresConnectorView(AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(line, headDecorator, tailDecorator);
        this.init();
    }

    public WiresConnectorView(WiresMagnet headMagnet, WiresMagnet tailMagnet, AbstractDirectionalMultiPointShape<?> line, MultiPathDecorator headDecorator, MultiPathDecorator tailDecorator) {
        super(headMagnet, tailMagnet, line, headDecorator, tailDecorator);
        this.init();
    }

    private void init() {
        ((AbstractDirectionalMultiPointShape)this.getLine().setFillColor((IColor)ColorName.WHITE)).setStrokeWidth(0.0);
    }

    public T setUUID(String uuid) {
        this.uuid = uuid;
        WiresUtils.assertShapeUUID(this.getGroup(), uuid);
        return this.cast();
    }

    public String getUUID() {
        return this.uuid;
    }

    public T setControl(WiresConnectorControl connectorControl) {
        this.connectorControl = connectorControl;
        return (T)((Object)this);
    }

    public WiresConnectorControl getControl() {
        return this.connectorControl;
    }

    public T connect(ShapeView headShapeView, Connection headConnection, ShapeView tailShapeView, Connection tailConnection) {
        WiresShape headWiresShape = (WiresShape)headShapeView;
        WiresShape tailWiresShape = (WiresShape)tailShapeView;
        return this.connect(headWiresShape.getMagnets(), headWiresShape.getGroup().getComputedLocation(), headConnection, tailWiresShape.getMagnets(), tailWiresShape.getGroup().getComputedLocation(), tailConnection);
    }

    T connect(MagnetManager.Magnets headMagnets, com.ait.lienzo.client.core.types.Point2D headAbsoluteLoc, Connection headConnection, MagnetManager.Magnets tailMagnets, com.ait.lienzo.client.core.types.Point2D tailAbsoluteLoc, Connection tailConnection) {
        WiresConnectorView.updateConnection(headConnection, headMagnets, headAbsoluteLoc, isAuto -> this.getHeadConnection().setAutoConnection(isAuto.booleanValue()), this::applyHeadMagnet);
        WiresConnectorView.updateConnection(tailConnection, tailMagnets, tailAbsoluteLoc, isAuto -> this.getTailConnection().setAutoConnection(isAuto.booleanValue()), this::applyTailMagnet);
        return this.cast();
    }

    public double getShapeX() {
        return this.getGroup().getX();
    }

    public double getShapeY() {
        return this.getGroup().getY();
    }

    public T setShapeX(double x) {
        this.getGroup().setX(x);
        return (T)((Object)this);
    }

    public T setShapeY(double y) {
        this.getGroup().setY(y);
        return (T)((Object)this);
    }

    public double getAlpha() {
        return this.getGroup().getAlpha();
    }

    public T setAlpha(double alpha) {
        this.getGroup().setAlpha(alpha);
        return (T)((Object)this);
    }

    public Point2D getShapeAbsoluteLocation() {
        return WiresUtils.getAbsolute(this.getGroup());
    }

    public String getFillColor() {
        return this.getLine().getFillColor();
    }

    public T setFillColor(String color) {
        this.getLine().setFillColor(color);
        if (null != this.getHead()) {
            this.getHead().setFillColor(color);
        }
        if (null != this.getTail()) {
            this.getTail().setFillColor(color);
        }
        return (T)((Object)this);
    }

    public double getFillAlpha() {
        return this.getLine().getFillAlpha();
    }

    public T setFillAlpha(double alpha) {
        this.getLine().setFillAlpha(alpha);
        if (null != this.getHead()) {
            this.getHead().setFillAlpha(alpha);
        }
        if (null != this.getTail()) {
            this.getTail().setFillAlpha(alpha);
        }
        return (T)((Object)this);
    }

    public String getStrokeColor() {
        return this.getLine().getStrokeColor();
    }

    public T setStrokeColor(String color) {
        this.getLine().setStrokeColor(color);
        if (null != this.getHead()) {
            this.getHead().setStrokeColor(color);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeColor(color);
        }
        return (T)((Object)this);
    }

    public double getStrokeAlpha() {
        return this.getLine().getStrokeAlpha();
    }

    public T setStrokeAlpha(double alpha) {
        this.getLine().setStrokeAlpha(alpha);
        if (null != this.getHead()) {
            this.getHead().setStrokeAlpha(alpha);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeAlpha(alpha);
        }
        return (T)((Object)this);
    }

    public double getStrokeWidth() {
        return this.getLine().getStrokeWidth();
    }

    public T setStrokeWidth(double width) {
        this.getLine().setStrokeWidth(width);
        if (null != this.getHead()) {
            this.getHead().setStrokeWidth(width);
        }
        if (null != this.getTail()) {
            this.getTail().setStrokeWidth(width);
        }
        return (T)((Object)this);
    }

    public T moveToTop() {
        this.getGroup().moveToTop();
        return (T)((Object)this);
    }

    public T moveToBottom() {
        this.getGroup().moveToBottom();
        return (T)((Object)this);
    }

    public T moveUp() {
        this.getGroup().moveUp();
        return (T)((Object)this);
    }

    public T moveDown() {
        this.getGroup().moveDown();
        return (T)((Object)this);
    }

    public T showControlPoints(HasControlPoints.ControlPointType type) {
        if (null != this.getControl()) {
            if (HasControlPoints.ControlPointType.POINTS.equals((Object)type)) {
                this.getControl().showControlPoints();
            } else {
                throw new UnsupportedOperationException("Control point type [" + type + "] not supported yet");
            }
        }
        return (T)((Object)this);
    }

    public T hideControlPoints() {
        if (null != this.getControl()) {
            this.getControl().hideControlPoints();
        }
        return (T)((Object)this);
    }

    public boolean areControlsVisible() {
        return this.getPointHandles().isVisible();
    }

    public List<Shape<?>> getDecorators() {
        ArrayList decorators = new ArrayList(3);
        decorators.add((Shape<?>)this.getLine());
        if (null != this.getHead()) {
            decorators.add((Shape<?>)this.getHead());
        }
        if (null != this.getTail()) {
            decorators.add((Shape<?>)this.getTail());
        }
        return decorators;
    }

    public void removeFromParent() {
        super.removeFromLayer();
    }

    public void destroy() {
        super.destroy();
        this.connectorControl = null;
    }

    private WiresConnector applyHeadMagnet(WiresMagnet headMagnet) {
        WiresConnectorView.ifNotSpecialConnection(this.getHeadConnection(), headMagnet, WiresConnectorView::clearConnectionOffset);
        return super.setHeadMagnet(headMagnet);
    }

    private WiresConnector applyTailMagnet(WiresMagnet tailMagnet) {
        WiresConnectorView.ifNotSpecialConnection(this.getTailConnection(), tailMagnet, WiresConnectorView::clearConnectionOffset);
        return super.setTailMagnet(tailMagnet);
    }

    private static void updateConnection(Connection connection, MagnetManager.Magnets magnets, com.ait.lienzo.client.core.types.Point2D abeLocation, Consumer<Boolean> isAutoConnectionConsumer, Consumer<WiresMagnet> magnetConsumer) {
        WiresMagnet[] magnet = new WiresMagnet[]{null};
        boolean[] auto = new boolean[]{false};
        if (null != connection) {
            DiscreteConnection dc;
            DiscreteConnection discreteConnection = dc = connection instanceof DiscreteConnection ? (DiscreteConnection)connection : null;
            if (null != dc) {
                dc.getMagnetIndex().ifPresent(index -> {
                    magnet[0] = magnets.getMagnet(index);
                });
                auto[0] = dc.isAuto();
            }
            if (null == magnet[0]) {
                magnet[0] = WiresConnectorView.getMagnetForConnection(connection, magnets, abeLocation);
                if (null != dc) {
                    dc.setIndex(magnet[0].getIndex());
                }
            }
        }
        isAutoConnectionConsumer.accept(auto[0]);
        magnetConsumer.accept(magnet[0]);
    }

    private static WiresMagnet getMagnetForConnection(Connection connection, MagnetManager.Magnets magnets, com.ait.lienzo.client.core.types.Point2D absLocation) {
        if (null != connection) {
            Point2D magnetAbs = new Point2D(absLocation.getX() + connection.getLocation().getX(), absLocation.getY() + connection.getLocation().getY());
            return WiresConnectorView.getMagnetNearTo(magnets, magnetAbs);
        }
        return null;
    }

    private static WiresMagnet getMagnetNearTo(MagnetManager.Magnets magnets, Point2D location) {
        return (WiresMagnet)StreamSupport.stream(magnets.getMagnets().spliterator(), false).sorted((m1, m2) -> WiresConnectorView.compare(m1, m2, location)).findFirst().get();
    }

    private static int compare(IControlHandle m1, IControlHandle m2, Point2D location) {
        double mx = location.getX();
        double my = location.getY();
        com.ait.lienzo.client.core.types.Point2D m1p = m1.getControl().getLocation();
        com.ait.lienzo.client.core.types.Point2D m2p = m2.getControl().getLocation();
        double d1 = ShapeUtils.dist((double)mx, (double)my, (double)m1p.getX(), (double)m1p.getY());
        double d2 = ShapeUtils.dist((double)mx, (double)my, (double)m2p.getX(), (double)m2p.getY());
        return Double.compare(d1, d2);
    }

    private static void ifNotSpecialConnection(WiresConnection connection, WiresMagnet magnet, Consumer<WiresConnection> regularConnectionConsumer) {
        if (!WiresConnection.isSpecialConnection((boolean)connection.isAutoConnection(), null != magnet ? Integer.valueOf(magnet.getIndex()) : null)) {
            regularConnectionConsumer.accept(connection);
        }
    }

    private static void clearConnectionOffset(WiresConnection connection) {
        connection.setXOffset(0.0);
        connection.setYOffset(0.0);
    }

    private T cast() {
        return (T)((Object)this);
    }
}

