/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires;

import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresLayoutContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.types.DragBounds;
import java.util.Collections;
import java.util.List;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDecorators;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDragBounds;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.lienzo.core.shape.wires.WiresDragConstraintEnforcer;

public class WiresShapeView<T>
extends WiresShape
implements ShapeView<T>,
HasDragBounds<T>,
HasDecorators<Shape<?>> {
    private String uuid;
    private WiresDragConstraintEnforcer dragEnforcer;

    public WiresShapeView(MultiPath path) {
        this(path, null);
    }

    public WiresShapeView(MultiPath path, LayoutContainer layoutContainer) {
        super(path, (LayoutContainer)(null != layoutContainer ? layoutContainer : new WiresLayoutContainer()));
        this.setListening(false);
    }

    public Shape<?> getShape() {
        return this.getPath();
    }

    public T setUUID(String uuid) {
        this.uuid = uuid;
        WiresUtils.assertShapeUUID(this.getGroup(), uuid);
        return this.cast();
    }

    public String getUUID() {
        return this.uuid;
    }

    public double getShapeX() {
        return this.getContainer().getAttributes().getX();
    }

    public double getShapeY() {
        return this.getContainer().getAttributes().getY();
    }

    public T setShapeX(double x) {
        this.getContainer().getAttributes().setX(x);
        return this.cast();
    }

    public T setShapeY(double y) {
        this.getContainer().getAttributes().setY(y);
        return this.cast();
    }

    public double getAlpha() {
        return this.getContainer().getAttributes().getAlpha();
    }

    public T setAlpha(double alpha) {
        this.getContainer().getAttributes().setAlpha(alpha);
        return this.cast();
    }

    public Point2D getShapeAbsoluteLocation() {
        return WiresUtils.getAbsolute(this.getContainer());
    }

    public String getFillColor() {
        return this.getShape().getFillColor();
    }

    public T setFillColor(String color) {
        this.getShape().setFillColor(color);
        return this.cast();
    }

    public double getFillAlpha() {
        return this.getShape().getFillAlpha();
    }

    public T setFillAlpha(double alpha) {
        this.getShape().setFillAlpha(alpha);
        return this.cast();
    }

    public String getStrokeColor() {
        return this.getShape().getStrokeColor();
    }

    public T setStrokeColor(String color) {
        this.getShape().setStrokeColor(color);
        return this.cast();
    }

    public double getStrokeAlpha() {
        return this.getShape().getStrokeAlpha();
    }

    public T setStrokeAlpha(double alpha) {
        this.getShape().setStrokeAlpha(alpha);
        return this.cast();
    }

    public double getStrokeWidth() {
        return this.getShape().getStrokeWidth();
    }

    public T setStrokeWidth(double width) {
        this.getShape().setStrokeWidth(width);
        return this.cast();
    }

    public T setDragBounds(double x1, double y1, double x2, double y2) {
        DragBounds dragBounds = new DragBounds(x1, y1, x2, y2);
        if (null == this.dragEnforcer) {
            this.dragEnforcer = WiresDragConstraintEnforcer.enforce((WiresContainer)this, (DragBounds)dragBounds);
        } else {
            this.dragEnforcer.setDragBounds(dragBounds);
        }
        return this.cast();
    }

    public T unsetDragBounds() {
        if (null != this.dragEnforcer) {
            this.dragEnforcer.remove();
            this.dragEnforcer = null;
        }
        return this.cast();
    }

    public T moveToTop() {
        this.getContainer().moveToTop();
        return this.cast();
    }

    public T moveToBottom() {
        this.getContainer().moveToBottom();
        return this.cast();
    }

    public T moveUp() {
        this.getContainer().moveUp();
        return this.cast();
    }

    public T moveDown() {
        this.getContainer().moveDown();
        return this.cast();
    }

    public void destroy() {
        super.destroy();
        this.unsetDragBounds();
    }

    public T setListening(boolean listening) {
        this.getPath().setFillBoundsForSelection(listening);
        this.getPath().setListening(listening);
        return this.cast();
    }

    public WiresDragConstraintEnforcer getDragEnforcer() {
        return this.dragEnforcer;
    }

    public List<Shape<?>> getDecorators() {
        return Collections.singletonList(this.getShape());
    }

    private T cast() {
        return (T)((Object)this);
    }
}

