/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.util;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Picture;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.LinearGradient;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoUtils;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;

public class LienzoShapeUtils {
    public static void scalePicture(Picture picture, double width, double height) {
        BoundingBox bb = picture.getBoundingBox();
        double[] scale = LienzoUtils.getScaleFactor(bb.getWidth(), bb.getHeight(), width, height);
        picture.setScale(scale[0], scale[1]);
    }

    public static LayoutContainer.Layout getWiresLayout(HasChildren.Layout layout) {
        switch (layout) {
            case CENTER: {
                return LayoutContainer.Layout.CENTER;
            }
            case LEFT: {
                return LayoutContainer.Layout.LEFT;
            }
            case RIGHT: {
                return LayoutContainer.Layout.RIGHT;
            }
            case TOP: {
                return LayoutContainer.Layout.TOP;
            }
            case BOTTOM: {
                return LayoutContainer.Layout.BOTTOM;
            }
        }
        throw new UnsupportedOperationException("Unsupported layout [" + layout.name() + "]");
    }

    public static LinearGradient getLinearGradient(String startColor, String endColor, Double width, Double height) {
        LinearGradient linearGradient = new LinearGradient(0.0, width.doubleValue(), 0.0, -height.doubleValue() / 2.0);
        linearGradient.addColorStop(1.0, endColor);
        linearGradient.addColorStop(0.0, startColor);
        return linearGradient;
    }

    public static Connection[] getDefaultConnections(WiresShape sourceShape, WiresShape targetShape) {
        MagnetManager.Magnets sourceMagnets = sourceShape.getMagnets();
        MagnetManager.Magnets targetMagnets = targetShape.getMagnets();
        int iSourceMagnet = 0;
        int iTargetMagnet = 0;
        double dist = Double.MAX_VALUE;
        for (int x = 0; x < sourceMagnets.size(); ++x) {
            if (!LienzoShapeUtils.isOddNumber(x)) continue;
            IPrimitive sourceControl = sourceMagnets.getMagnet(x).getControl();
            double sX = sourceControl.getX();
            double sY = sourceControl.getY();
            for (int y = 0; y < targetMagnets.size(); ++y) {
                double tY;
                IPrimitive targetControl;
                double tX;
                double _d;
                if (!LienzoShapeUtils.isOddNumber(y) || !((_d = ShapeUtils.dist((double)sX, (double)sY, (double)(tX = (targetControl = targetMagnets.getMagnet(y).getControl()).getX()), (double)(tY = targetControl.getY()))) < dist)) continue;
                dist = _d;
                iSourceMagnet = x;
                iTargetMagnet = y;
            }
        }
        MagnetConnection sConnection = MagnetConnection.Builder.at((double)sourceMagnets.getMagnet(iSourceMagnet).getX(), (double)sourceMagnets.getMagnet(iSourceMagnet).getY());
        MagnetConnection tConnection = MagnetConnection.Builder.at((double)targetMagnets.getMagnet(iTargetMagnet).getX(), (double)targetMagnets.getMagnet(iTargetMagnet).getY());
        return new Connection[]{sConnection, tConnection};
    }

    private static boolean isOddNumber(int i) {
        return i % 2 > 0;
    }
}

