/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Group;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderer;
import org.kie.workbench.common.stunner.core.client.components.glyph.GlyphRenderer;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

@ApplicationScoped
public class LienzoGlyphRenderers
implements LienzoGlyphRenderer<Glyph> {
    private final ManagedInstance<LienzoGlyphRenderer> rendererInstances;
    private final List<LienzoGlyphRenderer> renderers;

    protected LienzoGlyphRenderers() {
        this(null);
    }

    @Inject
    public LienzoGlyphRenderers(@Any ManagedInstance<LienzoGlyphRenderer> rendererInstances) {
        this.rendererInstances = rendererInstances;
        this.renderers = new ArrayList<LienzoGlyphRenderer>();
    }

    @PostConstruct
    public void init() {
        this.rendererInstances.forEach(this.renderers::add);
    }

    public Group render(Glyph glyph, double width, double height) {
        return (Group)this.getRenderer(glyph.getClass()).render(glyph, width, height);
    }

    private LienzoGlyphRenderer getRenderer(Class<?> type) {
        return (LienzoGlyphRenderer)GlyphRenderer.getRenderer(this.renderers::spliterator, type);
    }

    public Class<Glyph> getGlyphType() {
        return Glyph.class;
    }

    @PreDestroy
    public void destroy() {
        this.renderers.clear();
        this.rendererInstances.destroyAll();
    }
}

