/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.ILocationAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.LocationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.ShapeLocationsChangedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseEnterHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseExitHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
@Default
public class LocationControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements LocationControl<AbstractCanvasHandler, Element>,
CanvasControl.SessionAware<EditorSession> {
    private static final double LARGE_DISTANCE = 25.0;
    private static final double NORMAL_DISTANCE = 5.0;
    private static final double SHORT_DISTANCE = 1.0;
    private static Logger LOGGER = Logger.getLogger(LocationControlImpl.class.getName());
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final Event<ShapeLocationsChangedEvent> shapeLocationsChangedEvent;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;
    private final Collection<String> selectedIDs = new LinkedList<String>();
    private final Event<CanvasSelectionEvent> selectionEvent;
    final ILocationAcceptor LOCATION_ACCEPTOR = new ILocationAcceptor(){

        public boolean allow(WiresContainer[] wiresContainers, Point2D[] point2DS) {
            return true;
        }

        public boolean accept(WiresContainer[] wiresContainers, Point2D[] points) {
            CommandResult<CanvasViolation> result;
            if (wiresContainers.length != points.length) {
                throw new IllegalArgumentException("The location acceptor parameters size do not match.");
            }
            Element[] elements = new Element[wiresContainers.length];
            org.kie.workbench.common.stunner.core.graph.content.view.Point2D[] locations = new org.kie.workbench.common.stunner.core.graph.content.view.Point2D[points.length];
            int i = 0;
            for (WiresContainer container : wiresContainers) {
                if (container instanceof ShapeView) {
                    ShapeView shapeView = (ShapeView)container;
                    String uuid = shapeView.getUUID();
                    elements[i] = LocationControlImpl.this.canvasHandler.getGraphIndex().get(uuid);
                    locations[i] = new org.kie.workbench.common.stunner.core.graph.content.view.Point2D(points[i].getX(), points[i].getY());
                }
                ++i;
            }
            if (elements.length > 0 && CommandUtils.isError(result = LocationControlImpl.this.move(elements, locations))) {
                LOGGER.log(Level.SEVERE, "Update element's position command failed [result=" + result + "]");
                return false;
            }
            return true;
        }
    };

    protected LocationControlImpl() {
        this(null, null, null);
    }

    @Inject
    public LocationControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<ShapeLocationsChangedEvent> shapeLocationsChangedEvent, Event<CanvasSelectionEvent> selectionEvent) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.shapeLocationsChangedEvent = shapeLocationsChangedEvent;
        this.selectionEvent = selectionEvent;
    }

    public Collection<String> getSelectedIDs() {
        return this.selectedIDs;
    }

    public void bind(EditorSession session) {
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
    }

    private void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (KeysMatcher.doKeysMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ESC})) {
            this.getWiresManager().resetContext();
        }
        this.handleArrowKeys(keys);
    }

    public void handleArrowKeys(KeyboardEvent.Key ... keys) {
        int selectedIDsCount = this.selectedIDs.size();
        if (selectedIDsCount == 0) {
            return;
        }
        double movementDistance = 5.0;
        if (KeysMatcher.isKeyMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.CONTROL})) {
            movementDistance = 25.0;
        } else if (KeysMatcher.isKeyMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.SHIFT})) {
            movementDistance = 1.0;
        }
        double horizontalDistance = 0.0;
        double verticalDistance = 0.0;
        if (KeysMatcher.isKeyMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ARROW_LEFT})) {
            horizontalDistance = -movementDistance;
        } else if (KeysMatcher.isKeyMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ARROW_RIGHT})) {
            horizontalDistance = movementDistance;
        }
        if (KeysMatcher.isKeyMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ARROW_UP})) {
            verticalDistance = -movementDistance;
        } else if (KeysMatcher.isKeyMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ARROW_DOWN})) {
            verticalDistance = movementDistance;
        }
        if (verticalDistance == 0.0 && horizontalDistance == 0.0) {
            return;
        }
        ArrayList<Node> moveNodes = new ArrayList<Node>();
        ArrayList<org.kie.workbench.common.stunner.core.graph.content.view.Point2D> movePositions = new ArrayList<org.kie.workbench.common.stunner.core.graph.content.view.Point2D>();
        for (String uuid : this.selectedIDs) {
            Node node = this.canvasHandler.getGraphIndex().getNode(uuid);
            if (node == null) continue;
            org.kie.workbench.common.stunner.core.graph.content.view.Point2D nodePosition = GraphUtils.getPosition((View)((View)node.getContent()));
            org.kie.workbench.common.stunner.core.graph.content.view.Point2D movePosition = new org.kie.workbench.common.stunner.core.graph.content.view.Point2D(nodePosition.getX() + horizontalDistance, nodePosition.getY() + verticalDistance);
            moveNodes.add(node);
            movePositions.add(movePosition);
        }
        this.move(moveNodes.toArray(new Element[0]), movePositions.toArray(new org.kie.workbench.common.stunner.core.graph.content.view.Point2D[0]));
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    protected void doInit() {
        super.doInit();
        this.getWiresManager().setLocationAcceptor(this.LOCATION_ACCEPTOR);
    }

    public void register(Element element) {
        if (null != element.asNode() && this.checkNotRegistered(element)) {
            HasEventHandlers hasEventHandlers;
            AbstractCanvas canvas = this.canvasHandler.getAbstractCanvas();
            final Shape shape = canvas.getShape(element.getUUID());
            ShapeView shapeView = shape.getShapeView();
            shapeView.setDragEnabled(true);
            LocationControlImpl.ensureDragConstraints(canvas, shapeView);
            if (shape.getShapeView() instanceof HasEventHandlers && this.supportsMouseEnter(hasEventHandlers = (HasEventHandlers)shapeView) && this.supportsMouseExit(hasEventHandlers)) {
                MouseEnterHandler overHandler = new MouseEnterHandler(){

                    public void handle(MouseEnterEvent event) {
                        LocationControlImpl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.MOVE);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.MOUSE_ENTER, (ViewHandler)overHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler)overHandler);
                MouseExitHandler outHandler = new MouseExitHandler(){

                    public void handle(MouseExitEvent event) {
                        LocationControlImpl.this.canvasHandler.getAbstractCanvas().getView().setCursor(AbstractCanvas.Cursors.DEFAULT);
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.MOUSE_EXIT, (ViewHandler)outHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler)outHandler);
                DragHandler dragHandler = new DragHandler(){

                    public void start(DragEvent event) {
                    }

                    public void end(DragEvent event) {
                        LocationControlImpl.this.selectionEvent.fire((Object)new CanvasSelectionEvent((CanvasHandler)LocationControlImpl.this.canvasHandler, shape.getUUID()));
                    }

                    public void handle(DragEvent event) {
                    }
                };
                hasEventHandlers.addHandler(ViewEventType.DRAG, (ViewHandler)dragHandler);
                this.registerHandler(shape.getUUID(), (ViewHandler)dragHandler);
            }
        }
    }

    public CommandResult<CanvasViolation> move(Element[] elements, org.kie.workbench.common.stunner.core.graph.content.view.Point2D[] locations) {
        if (elements.length != locations.length) {
            throw new IllegalArgumentException("The length for the elements to move does not match the locations provided.");
        }
        CompositeCommand.Builder builder = new CompositeCommand.Builder().forward();
        for (int i = 0; i < elements.length; ++i) {
            Element element = elements[i];
            builder.addCommand(this.createMoveCommand(element, locations[i]));
        }
        CompositeCommand command = builder.build();
        CommandResult result = this.getCommandManager().allow((Object)this.canvasHandler, (Command)command);
        if (!CommandUtils.isError((CommandResult)result) && !CommandUtils.isError((CommandResult)(result = this.getCommandManager().execute((Object)this.canvasHandler, (Command)command)))) {
            List uuids = Arrays.stream(elements).map(Element::getUUID).collect(Collectors.toList());
            this.shapeLocationsChangedEvent.fire((Object)new ShapeLocationsChangedEvent(uuids, (CanvasHandler)this.canvasHandler));
        }
        return result;
    }

    protected void doClear() {
        this.selectedIDs.clear();
        super.doClear();
    }

    protected void doDestroy() {
        this.clear();
        this.getWiresManager().setLocationAcceptor(ILocationAcceptor.ALL);
        this.commandManagerProvider = null;
        super.doDestroy();
    }

    void onCanvasSelectionEvent(@Observes CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event)) {
            this.selectedIDs.clear();
            this.selectedIDs.addAll(event.getIdentifiers());
        }
    }

    void onCanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event)) {
            this.selectedIDs.clear();
        }
    }

    private CanvasCommand<AbstractCanvasHandler> createMoveCommand(Element element, org.kie.workbench.common.stunner.core.graph.content.view.Point2D location) {
        return this.canvasCommandFactory.updatePosition((Node)element, location);
    }

    private boolean supportsMouseEnter(HasEventHandlers shapeView) {
        return shapeView.supports(ViewEventType.MOUSE_ENTER);
    }

    private boolean supportsMouseExit(HasEventHandlers shapeView) {
        return shapeView.supports(ViewEventType.MOUSE_EXIT);
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    private static void ensureDragConstraints(AbstractCanvas<?> canvas, ShapeView shapeView) {
        Bounds bounds = canvas.getView().getPanel().getLocationConstraints();
        ShapeUtils.enforceLocationConstraints((ShapeView)shapeView, (Bounds)bounds);
    }

    private WiresManager getWiresManager() {
        WiresCanvas canvas = (WiresCanvas)this.canvasHandler.getCanvas();
        return canvas.getWiresManager();
    }
}

