/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ResizeControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.client.shape.view.HasControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ResizeHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Dependent
@Default
public class ResizeControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements ResizeControl<AbstractCanvasHandler, Element> {
    private static Logger LOGGER = Logger.getLogger(ResizeControlImpl.class.getName());
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    protected ResizeControlImpl() {
        this(null);
    }

    @Inject
    public ResizeControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    public void register(Element element) {
        Canvas canvas;
        Shape shape;
        if (this.checkNotRegistered(element) && this.supportsResize(shape = (canvas = this.canvasHandler.getCanvas()).getShape(element.getUUID()))) {
            this.registerResizeHandlers(element, shape);
        }
    }

    public CommandResult<CanvasViolation> resize(Element element, double width, double height) {
        return this.doResize(element, width, height);
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    protected void doDestroy() {
        super.doDestroy();
        this.commandManagerProvider = null;
    }

    private boolean supportsResize(Shape<?> shape) {
        ShapeView view = shape.getShapeView();
        boolean supportsResize = view instanceof HasEventHandlers && ((HasEventHandlers)view).supports(ViewEventType.RESIZE);
        boolean supportsCtrlPoints = view instanceof HasControlPoints;
        return supportsResize && supportsCtrlPoints;
    }

    protected void onCanvasSelectionEvent(@Observes CanvasSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (event.getIdentifiers().size() == 1) {
            String uuid = (String)event.getIdentifiers().iterator().next();
            if (this.isSameCanvas((AbstractCanvasHandlerEvent)event) && this.isRegistered(uuid)) {
                this.hideALLCPs();
                HasControlPoints<?> hasControlPoints = this.getControlPointsInstance(uuid);
                if (!hasControlPoints.areControlsVisible()) {
                    this.showCPs(hasControlPoints);
                }
            }
        } else if (event.getIdentifiers().size() > 1) {
            this.hideALLCPs();
        }
    }

    private void CanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent clearSelectionEvent) {
        PortablePreconditions.checkNotNull((String)"clearSelectionEvent", (Object)clearSelectionEvent);
        if (this.isSameCanvas((AbstractCanvasHandlerEvent)clearSelectionEvent)) {
            this.hideALLCPs();
        }
    }

    private void showCPs(HasControlPoints<?> hasControlPoints) {
        if (!hasControlPoints.areControlsVisible()) {
            hasControlPoints.showControlPoints(HasControlPoints.ControlPointType.RESIZE);
        }
    }

    private void hideALLCPs() {
        this.getRegisteredElements().forEach(uuid -> this.getControlPointsInstance((String)uuid).hideControlPoints());
    }

    private void hideCPs(HasControlPoints<?> hasControlPoints) {
        if (hasControlPoints.areControlsVisible()) {
            hasControlPoints.hideControlPoints();
        }
    }

    private HasControlPoints<?> getControlPointsInstance(String uuid) {
        Shape shape = this.canvasHandler.getCanvas().getShape(uuid);
        return (HasControlPoints)shape.getShapeView();
    }

    private boolean isSameCanvas(AbstractCanvasHandlerEvent event) {
        return null != this.canvasHandler && this.canvasHandler.equals((Object)event.getCanvasHandler());
    }

    private void registerResizeHandlers(final Element element, Shape<?> shape) {
        if (shape.getShapeView() instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            ResizeHandler resizeHandler = new ResizeHandler(){

                public void start(ResizeEvent event) {
                }

                public void handle(ResizeEvent event) {
                }

                public void end(ResizeEvent event) {
                    CommandResult result = ResizeControlImpl.this.doResize(element, event.getWidth(), event.getHeight());
                    if (CommandUtils.isError((CommandResult)result)) {
                        LOGGER.log(Level.SEVERE, "Command failed at resize end [result=" + result + "]");
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.RESIZE, (ViewHandler)resizeHandler);
            this.registerHandler(element.getUUID(), (ViewHandler)resizeHandler);
        }
    }

    private CommandResult<CanvasViolation> doResize(Element<? extends View<?>> element, double w, double h) {
        return this.getCommandManager().execute((Object)this.canvasHandler, (Command)this.canvasCommandFactory.resize(element, new BoundingBox(0.0, 0.0, w, h)));
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }
}

