/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components;

import com.ait.lienzo.client.core.image.ImageStrip;
import com.ait.lienzo.client.core.image.ImageStrips;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.core.client.shape.ImageStrip;
import org.kie.workbench.common.stunner.core.client.shape.ImageStripRegistry;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class LienzoImageStrips {
    private final ImageStrips imageStrips;
    private final Map<String, Integer> registered;

    public LienzoImageStrips() {
        this(ImageStrips.get());
    }

    LienzoImageStrips(ImageStrips imageStrips) {
        this.imageStrips = imageStrips;
        this.registered = new HashMap<String, Integer>();
    }

    public void register(org.kie.workbench.common.stunner.core.client.shape.ImageStrip[] strips, Command callback) {
        LinkedList<org.kie.workbench.common.stunner.core.client.shape.ImageStrip> candidates = new LinkedList<org.kie.workbench.common.stunner.core.client.shape.ImageStrip>();
        for (org.kie.workbench.common.stunner.core.client.shape.ImageStrip strip : strips) {
            String name = ImageStripRegistry.getName((org.kie.workbench.common.stunner.core.client.shape.ImageStrip)strip);
            Integer count = this.registered.get(name);
            if (null == count) {
                count = 1;
                candidates.add(strip);
            } else {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            this.registered.put(name, count);
        }
        if (!candidates.isEmpty()) {
            this.imageStrips.register((ImageStrip[])candidates.stream().map(LienzoImageStrips::convert).toArray(ImageStrip[]::new), () -> ((Command)callback).execute());
        } else {
            callback.execute();
        }
    }

    public void remove(org.kie.workbench.common.stunner.core.client.shape.ImageStrip[] strips) {
        for (org.kie.workbench.common.stunner.core.client.shape.ImageStrip strip : strips) {
            String name = ImageStripRegistry.getName((org.kie.workbench.common.stunner.core.client.shape.ImageStrip)strip);
            Integer count = this.registered.get(name);
            if (count == 1) {
                this.removeFromLienzo(name);
                this.registered.remove(name);
                continue;
            }
            this.registered.put(name, count - 1);
        }
    }

    void removeFromLienzo(String name) {
        Optional.ofNullable(this.imageStrips.get(name)).ifPresent(imageStrip -> this.imageStrips.remove(name));
    }

    @PreDestroy
    public void destroy() {
        new HashMap<String, Integer>(this.registered).keySet().forEach(this::removeFromLienzo);
        this.registered.clear();
    }

    Map<String, Integer> getRegistered() {
        return this.registered;
    }

    private static ImageStrip convert(org.kie.workbench.common.stunner.core.client.shape.ImageStrip strip) {
        return new ImageStrip(ImageStripRegistry.getName((org.kie.workbench.common.stunner.core.client.shape.ImageStrip)strip), strip.getImage().getSafeUri().asString(), strip.getWide(), strip.getHigh(), strip.getPadding(), LienzoImageStrips.convert(strip.getOrientation()));
    }

    private static ImageStrip.Orientation convert(ImageStrip.Orientation orientation) {
        return ImageStrip.Orientation.HORIZONTAL.equals((Object)orientation) ? ImageStrip.Orientation.HORIZONTAL : ImageStrip.Orientation.VERTICAL;
    }
}

