/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.mediators;

import com.ait.lienzo.client.core.mediator.EventFilter;
import com.ait.lienzo.client.core.mediator.IEventFilter;
import com.ait.lienzo.client.widget.panel.LienzoBoundsPanel;
import com.ait.lienzo.client.widget.panel.mediators.PanelMediators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.appformer.client.context.EditorContextProvider;
import org.appformer.client.context.OperatingSystem;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoPanel;
import org.kie.workbench.common.stunner.client.lienzo.components.views.LienzoCanvasNotification;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyEventHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;

@Dependent
public class LienzoCanvasMediators {
    static final AbstractCanvas.Cursors CURSOR_ZOOM = AbstractCanvas.Cursors.ROW_RESIZE;
    static final AbstractCanvas.Cursors CURSOR_PAN = AbstractCanvas.Cursors.POINTER;
    static final AbstractCanvas.Cursors CURSOR_PREVIEW = AbstractCanvas.Cursors.CROSSHAIR;
    static final AbstractCanvas.Cursors CURSOR_DEFAULT = AbstractCanvas.Cursors.DEFAULT;
    private final KeyEventHandler keyEventHandler;
    private final ClientTranslationService translationService;
    private final LienzoCanvasNotification notification;
    private final Function<LienzoBoundsPanel, PanelMediators> mediatorsBuilder;
    private PanelMediators mediators;
    Consumer<AbstractCanvas.Cursors> cursor;

    @Inject
    public LienzoCanvasMediators(KeyEventHandler keyEventHandler, ClientTranslationService translationService, LienzoCanvasNotification notification, EditorContextProvider editorContextProvider) {
        this(keyEventHandler, translationService, notification, LienzoCanvasMediators.getMediatorsBuilder(editorContextProvider));
    }

    private static Function<LienzoBoundsPanel, PanelMediators> getMediatorsBuilder(EditorContextProvider editorContextProvider) {
        return editorContextProvider.getOperatingSystem().orElse(OperatingSystem.LINUX).equals((Object)OperatingSystem.MACOS) ? panel -> PanelMediators.build((LienzoBoundsPanel)panel, (IEventFilter)EventFilter.META, (IEventFilter)EventFilter.ALT) : panel -> PanelMediators.build((LienzoBoundsPanel)panel, (IEventFilter)EventFilter.CONTROL, (IEventFilter)EventFilter.ALT);
    }

    LienzoCanvasMediators(KeyEventHandler keyEventHandler, ClientTranslationService translationService, LienzoCanvasNotification notification, Function<LienzoBoundsPanel, PanelMediators> mediatorsBuilder) {
        this.keyEventHandler = keyEventHandler;
        this.translationService = translationService;
        this.notification = notification;
        this.mediatorsBuilder = mediatorsBuilder;
    }

    public void init(Supplier<LienzoCanvas> canvas) {
        this.keyEventHandler.addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyShortcutKeyDownThenUp(new KeyboardEvent.Key[]{KeyboardEvent.Key.ALT}, "Navigate | Hold and drag to Pan", this::enablePan, this::clear));
        this.keyEventHandler.addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyShortcutKeyDownThenUp(new KeyboardEvent.Key[]{KeyboardEvent.Key.CONTROL}, "Navigate | Hold and scroll to Zoom", this::enableZoom, this::clear));
        this.keyEventHandler.addKeyShortcutCallback((KeyboardControl.KeyShortcutCallback)new KeyboardControl.KogitoKeyShortcutKeyDownThenUp(new KeyboardEvent.Key[]{KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.ALT}, "Navigate | Hold to Preview", this::enablePreview, this::clear));
        this.keyEventHandler.setTimerDelay(150).addKeyShortcutCallback(new KeyboardControl.KeyShortcutCallback(){

            public void onKeyShortcut(KeyboardEvent.Key ... keys) {
                if (KeysMatcher.doKeysMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.CONTROL})) {
                    LienzoCanvasMediators.this.enableZoom();
                } else if (KeysMatcher.doKeysMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ALT})) {
                    LienzoCanvasMediators.this.enablePan();
                } else if (KeysMatcher.doKeysMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.ALT}) || KeysMatcher.doKeysMatch((KeyboardEvent.Key[])keys, (KeyboardEvent.Key[])new KeyboardEvent.Key[]{KeyboardEvent.Key.ALT, KeyboardEvent.Key.CONTROL})) {
                    LienzoCanvasMediators.this.enablePreview();
                }
            }

            public void onKeyUp(KeyboardEvent.Key key) {
                LienzoCanvasMediators.this.clear();
            }
        });
        this.cursor = c -> ((LienzoCanvas)((Object)((Object)canvas.get()))).getView().setCursor(c);
        LienzoPanel panel = (LienzoPanel)canvas.get().getView().getPanel();
        this.mediators = this.mediatorsBuilder.apply(panel.getView());
        this.notification.init(() -> panel);
        this.setScaleAboutPoint(false);
    }

    public void setMinScale(double minScale) {
        this.mediators.getZoomMediator().setMinScale(minScale);
    }

    public void setMaxScale(double maxScale) {
        this.mediators.getZoomMediator().setMaxScale(maxScale);
        this.mediators.getPreviewMediator().setMaxScale(maxScale);
    }

    public void setZoomFactor(double factor) {
        this.mediators.getZoomMediator().setZoomFactor(factor);
    }

    public void setScaleAboutPoint(boolean scaleAboutPoint) {
        this.mediators.getZoomMediator().setScaleAboutPoint(scaleAboutPoint);
    }

    public void enable() {
        this.keyEventHandler.setEnabled(true);
    }

    public void disable() {
        this.keyEventHandler.setEnabled(false);
        this.clear();
    }

    @PreDestroy
    public void destroy() {
        if (null != this.mediators) {
            this.mediators.destroy();
            this.mediators = null;
        }
    }

    PanelMediators getMediators() {
        return this.mediators;
    }

    private void enableZoom() {
        if (null != this.mediators) {
            this.cursor.accept(CURSOR_ZOOM);
        }
    }

    private void enablePan() {
        if (null != this.mediators) {
            this.cursor.accept(CURSOR_PAN);
        }
    }

    private void enablePreview() {
        if (null != this.mediators && this.mediators.enablePreview()) {
            this.cursor.accept(CURSOR_PREVIEW);
            this.notification.show(this.translationService.getNotNullValue("org.kie.workbench.common.stunner.core.client.mediator.zoomArea"));
        }
    }

    private void clear() {
        if (null != this.mediators) {
            this.cursor.accept(CURSOR_DEFAULT);
            this.mediators.disablePreview();
            this.notification.hide();
        }
    }
}

