/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IContainmentAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractAcceptorControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

@Dependent
public class ContainmentAcceptorControlImpl
extends AbstractAcceptorControl
implements ContainmentAcceptorControl<AbstractCanvasHandler> {
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private CanvasHighlight canvasHighlight;
    private final IContainmentAcceptor CONTAINMENT_ACCEPTOR = new IContainmentAcceptor(){

        public boolean containmentAllowed(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!ContainmentAcceptorControlImpl.this.isWiresViewAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return ContainmentAcceptorControlImpl.this.allow((Element)parentNode, childNode);
        }

        public boolean acceptContainment(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!ContainmentAcceptorControlImpl.this.isWiresViewAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return ContainmentAcceptorControlImpl.this.accept((Element)parentNode, childNode);
        }
    };

    @Inject
    public ContainmentAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    protected void onEnable(WiresCanvas.View view) {
        view.setContainmentAcceptor(this.CONTAINMENT_ACCEPTOR);
        this.canvasHighlight = new CanvasHighlight(this.getCanvasHandler());
    }

    @Override
    protected void onDisable(WiresCanvas.View view) {
        view.setContainmentAcceptor(IContainmentAcceptor.NONE);
        this.canvasHighlight.destroy();
        this.canvasHighlight = null;
    }

    public boolean allow(Element parent, Node candidate) {
        return this.evaluate(parent, candidate, command -> this.getCommandManager().allow((Object)this.getCanvasHandler(), command), true);
    }

    public boolean accept(Element parent, Node candidate) {
        return this.evaluate(parent, candidate, command -> this.getCommandManager().execute((Object)this.getCanvasHandler(), command), false);
    }

    private boolean evaluate(Element parent, Node candidate, Function<Command<AbstractCanvasHandler, CanvasViolation>, CommandResult<CanvasViolation>> executor, boolean highlightInvalid) {
        if (parent == null && candidate == null) {
            return false;
        }
        CommandResult<CanvasViolation> result = executor.apply((Command<AbstractCanvasHandler, CanvasViolation>)this.canvasCommandFactory.updateChildNode((Node)parent, candidate));
        if (highlightInvalid && CommandUtils.isError(result)) {
            this.canvasHighlight.invalid(result.getViolations());
        } else {
            this.canvasHighlight.unhighLight();
        }
        return this.isCommandSuccess(candidate, result);
    }
}

