/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Picture;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.shared.core.types.ColorName;
import com.ait.lienzo.shared.core.types.IColor;
import com.google.gwt.core.client.Scheduler;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderer;
import org.kie.workbench.common.stunner.client.lienzo.shape.util.LienzoPictureUtils;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoShapeUtils;
import org.kie.workbench.common.stunner.core.client.shape.ImageDataUriGlyph;

@ApplicationScoped
public class LienzoPictureGlyphRenderer
implements LienzoGlyphRenderer<ImageDataUriGlyph> {
    private final BiConsumer<String, Consumer<Picture>> pictureBuilder;

    public LienzoPictureGlyphRenderer() {
        this.pictureBuilder = (uri, consumer) -> new Picture(uri, consumer::accept);
    }

    LienzoPictureGlyphRenderer(BiConsumer<String, Consumer<Picture>> pictureBuilder) {
        this.pictureBuilder = pictureBuilder;
    }

    public Class<ImageDataUriGlyph> getGlyphType() {
        return ImageDataUriGlyph.class;
    }

    public Group render(ImageDataUriGlyph glyph, double width, double height) {
        return this.render(glyph.getUri().asString(), width, height);
    }

    public Group render(String data, double width, double height) {
        DestroyableGroup group = new DestroyableGroup();
        Rectangle decorator = (Rectangle)((Rectangle)new Rectangle(width, height).setCornerRadius(5.0).setFillColor((IColor)ColorName.LIGHTGREY)).setFillAlpha(0.7);
        this.pictureBuilder.accept(data, picture -> {
            group.picture = picture;
            LienzoShapeUtils.scalePicture(picture, width, height);
            group.remove((IPrimitive)decorator);
            group.add((IPrimitive)picture);
        });
        group.add((IPrimitive)decorator);
        return group;
    }

    private static class DestroyableGroup
    extends Group {
        private Picture picture;

        private DestroyableGroup() {
        }

        public boolean removeFromParent() {
            LienzoPictureUtils.tryDestroy(this.picture, p -> Scheduler.get().scheduleFixedDelay(() -> !LienzoPictureUtils.retryDestroy(p), 200));
            return super.removeFromParent();
        }
    }
}

