/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.toolbox.actions;

import com.ait.lienzo.client.core.event.AbstractNodeMouseEvent;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.toolbox.items.ButtonItem;
import com.ait.lienzo.client.core.shape.toolbox.items.DecoratedItem;
import com.ait.lienzo.client.core.shape.toolbox.items.DecoratorItem;
import com.ait.lienzo.client.core.shape.toolbox.items.TooltipItem;
import com.ait.lienzo.client.core.shape.toolbox.items.decorator.BoxDecorator;
import com.ait.lienzo.client.core.shape.toolbox.items.impl.ToolboxFactory;
import com.ait.lienzo.client.core.shape.toolbox.items.impl.WiresShapeToolbox;
import com.ait.lienzo.client.core.shape.toolbox.items.tooltip.ToolboxTextTooltip;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.tooling.common.api.java.util.function.Consumer;
import java.util.Optional;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderers;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.IsToolboxActionDraggable;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseMoveEvent;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

public abstract class AbstractActionsToolboxView<V extends AbstractActionsToolboxView>
implements ActionsToolboxView<V> {
    public static final double BUTTON_SIZE = 15.0;
    public static final double BUTTON_PADDING = 5.0;
    private final LienzoGlyphRenderers glyphRenderers;
    private final ToolboxFactory toolboxFactory;
    private WiresShapeToolbox toolboxView;
    private ToolboxTextTooltip tooltip;
    private WiresCanvas canvas;

    public AbstractActionsToolboxView(LienzoGlyphRenderers glyphRenderers, ToolboxFactory toolboxFactory) {
        this.glyphRenderers = glyphRenderers;
        this.toolboxFactory = toolboxFactory;
    }

    protected abstract void configure(ActionsToolbox var1);

    protected abstract ToolboxTextTooltip createTooltip(ActionsToolbox var1);

    protected abstract double getGlyphSize();

    public V init(ActionsToolbox toolbox) {
        return this.init(toolbox, (WiresCanvas)toolbox.getCanvas(), (WiresShape)toolbox.getShape().getShapeView());
    }

    public V show() {
        this.toolboxView.show();
        return this.cast();
    }

    public V hide() {
        this.toolboxView.hide();
        return this.cast();
    }

    public void destroy() {
        Optional.ofNullable(this.toolboxView).ifPresent(WiresShapeToolbox::destroy);
        Optional.ofNullable(this.tooltip).ifPresent(ToolboxTextTooltip::destroy);
        this.toolboxView = null;
        this.tooltip = null;
        this.canvas = null;
    }

    public void hideAndDestroy() {
        Optional.ofNullable(this.toolboxView).ifPresent(WiresShapeToolbox::hideAndDestroy);
        this.toolboxView = null;
        this.destroy();
    }

    protected V init(ActionsToolbox toolbox, WiresCanvas canvas, WiresShape shape) {
        this.canvas = canvas;
        Layer topLayer = canvas.getView().getLayer().getTopLayer();
        this.toolboxView = this.toolboxFactory.forWiresShape(shape).attachTo(topLayer);
        this.configure(toolbox);
        this.tooltip = this.createTooltip(toolbox);
        this.initButtons(toolbox);
        return this.cast();
    }

    private void initButtons(ActionsToolbox<ActionsToolboxView<?>> toolbox) {
        for (ToolboxAction toolboxAction : toolbox) {
            ButtonItem button = this.addButton(toolbox.getGlyph(toolboxAction), toolbox.getTitle(toolboxAction));
            button.onClick(event -> this.onButtonClick(toolbox, toolboxAction, button, (AbstractNodeMouseEvent)event));
            if (!(toolboxAction instanceof IsToolboxActionDraggable)) continue;
            button.onMoveStart(event -> this.onButtonMoveStart(toolbox, (IsToolboxActionDraggable)toolboxAction, button, (AbstractNodeMouseEvent)event));
        }
    }

    protected void onButtonClick(ActionsToolbox<ActionsToolboxView<?>> toolbox, ToolboxAction toolboxAction, ButtonItem button, AbstractNodeMouseEvent event) {
        toolboxAction.onMouseClick((CanvasHandler)toolbox.getCanvasHandler(), toolbox.getElementUUID(), new MouseClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY()));
    }

    protected void onButtonMoveStart(ActionsToolbox<ActionsToolboxView<?>> toolbox, IsToolboxActionDraggable toolboxAction, ButtonItem button, AbstractNodeMouseEvent event) {
        toolboxAction.onMoveStart((CanvasHandler)toolbox.getCanvasHandler(), toolbox.getElementUUID(), new MouseMoveEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY()));
    }

    ButtonItem addButton(Glyph glyph, String title) {
        ButtonItem button = (ButtonItem)((ButtonItem)((ButtonItem)((ButtonItem)this.toolboxFactory.buttons().button(this.renderGlyph(glyph, this.getGlyphSize())).decorate((DecoratorItem)this.createDecorator())).tooltip((TooltipItem)this.tooltip.createItem(title))).onMouseEnter(event -> this.onMouseEnter())).onMouseExit(event -> this.onMouseExit());
        this.addButton(button);
        return button;
    }

    protected void addButton(ButtonItem buttonItem) {
        this.toolboxView.add(new DecoratedItem[]{buttonItem});
    }

    protected Consumer<Text> defaultTextConsumer() {
        return text -> text.setFontSize(10.0).setFontFamily("Verdana");
    }

    protected WiresShapeToolbox getToolboxView() {
        return this.toolboxView;
    }

    protected ToolboxFactory getToolboxFactory() {
        return this.toolboxFactory;
    }

    protected Group renderGlyph(Glyph glyph, double size) {
        return this.glyphRenderers.render(glyph, size, size);
    }

    protected BoxDecorator createDecorator() {
        return this.getToolboxFactory().decorators().box();
    }

    private void onMouseEnter() {
        if (null != this.canvas) {
            this.canvas.getView().setCursor(AbstractCanvas.Cursors.POINTER);
        }
    }

    private void onMouseExit() {
        if (null != this.canvas) {
            this.canvas.getView().setCursor(AbstractCanvas.Cursors.DEFAULT);
        }
    }

    private V cast() {
        return (V)this;
    }
}

