/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IConnectionAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresConnection;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresMagnet;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractAcceptorControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2DConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

@Dependent
@Default
public class ConnectionAcceptorControlImpl
extends AbstractAcceptorControl
implements ConnectionAcceptorControl<AbstractCanvasHandler> {
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final CanvasHighlight canvasHighlight;
    private final IConnectionAcceptor CONNECTION_ACCEPTOR = new IConnectionAcceptor(){

        public boolean acceptHead(WiresConnection head, WiresMagnet wiresMagnet) {
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.getCanvasHandler(), head.getConnector());
            Node sourceNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.getCanvasHandler(), wiresMagnet);
            Connection connection = ConnectionAcceptorControlImpl.createConnection(head, wiresMagnet);
            return ConnectionAcceptorControlImpl.this.acceptSource(sourceNode, edge, connection);
        }

        public boolean acceptTail(WiresConnection tail, WiresMagnet wiresMagnet) {
            WiresConnection head = tail.getConnector().getHeadConnection();
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.getCanvasHandler(), head.getConnector());
            Node targetNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.getCanvasHandler(), wiresMagnet);
            Connection connection = ConnectionAcceptorControlImpl.createConnection(tail, wiresMagnet);
            return ConnectionAcceptorControlImpl.this.acceptTarget(targetNode, edge, connection);
        }

        public boolean headConnectionAllowed(WiresConnection head, WiresShape shape) {
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.getCanvasHandler(), head.getConnector());
            Node sourceNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)shape);
            return ConnectionAcceptorControlImpl.this.allowSource(sourceNode, edge, (Connection)ConnectionAcceptorControlImpl.createConnection((Element)sourceNode));
        }

        public boolean tailConnectionAllowed(WiresConnection tail, WiresShape shape) {
            Edge edge = WiresUtils.getEdge(ConnectionAcceptorControlImpl.this.getCanvasHandler(), tail.getConnector());
            Node targetNode = WiresUtils.getNode(ConnectionAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)shape);
            return ConnectionAcceptorControlImpl.this.allowTarget(targetNode, edge, (Connection)ConnectionAcceptorControlImpl.createConnection((Element)targetNode));
        }
    };

    @Inject
    public ConnectionAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, CanvasHighlight canvasHighlight) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.canvasHighlight = canvasHighlight;
    }

    @Override
    protected void onInit(WiresCanvas canvas) {
        this.canvasHighlight.setCanvasHandler(this.getCanvasHandler());
        canvas.getWiresManager().setConnectionAcceptor(this.CONNECTION_ACCEPTOR);
    }

    public boolean allowSource(Node source, Edge<ViewConnector<?>, Node> connector, Connection connection) {
        if (ConnectionAcceptorControlImpl.isSourceConnectionChanged(connector, connection)) {
            CommandResult violations = this.getCommandManager().allow((Object)this.getCanvasHandler(), (Command)this.canvasCommandFactory.setSourceNode(source, connector, connection));
            boolean accepts = this.isAccept((CommandResult<CanvasViolation>)violations);
            if (ConnectionAcceptorControlImpl.isSourceChanged(source, connector)) {
                this.highlight(source, connector, accepts);
            }
            return accepts;
        }
        return true;
    }

    public boolean allowTarget(Node target, Edge<ViewConnector<?>, Node> connector, Connection connection) {
        if (ConnectionAcceptorControlImpl.isTargetConnectionChanged(connector, connection)) {
            CommandResult violations = this.getCommandManager().allow((Object)this.getCanvasHandler(), (Command)this.canvasCommandFactory.setTargetNode(target, connector, connection));
            boolean accepts = this.isAccept((CommandResult<CanvasViolation>)violations);
            if (ConnectionAcceptorControlImpl.isTargetChanged(target, connector)) {
                this.highlight(target, connector, accepts);
            }
            return accepts;
        }
        return true;
    }

    public boolean acceptSource(Node source, Edge<ViewConnector<?>, Node> connector, Connection connection) {
        this.ensureUnHighLight();
        if (ConnectionAcceptorControlImpl.isSourceChanged(source, connector)) {
            CommandResult violations = this.getCommandManager().execute((Object)this.getCanvasHandler(), (Command)this.canvasCommandFactory.setSourceNode(source, connector, connection));
            return this.isAccept((CommandResult<CanvasViolation>)violations);
        }
        return true;
    }

    public boolean acceptTarget(Node target, Edge<ViewConnector<?>, Node> connector, Connection connection) {
        this.ensureUnHighLight();
        if (ConnectionAcceptorControlImpl.isTargetChanged(target, connector)) {
            CommandResult violations = this.getCommandManager().execute((Object)this.getCanvasHandler(), (Command)this.canvasCommandFactory.setTargetNode(target, connector, connection));
            return this.isAccept((CommandResult<CanvasViolation>)violations);
        }
        return true;
    }

    private static boolean isSourceChanged(Node node, Edge<ViewConnector<?>, Node> connector) {
        return !ConnectionAcceptorControlImpl.eqNode(node, connector.getSourceNode());
    }

    private static boolean isSourceConnectionChanged(Edge<ViewConnector<?>, Node> connector, Connection connection) {
        ViewConnector vc = (ViewConnector)connector.getContent();
        return !ConnectionAcceptorControlImpl.eqConnection(connection, null != vc ? vc.getSourceConnection() : Optional.empty());
    }

    private static boolean isTargetChanged(Node node, Edge<ViewConnector<?>, Node> connector) {
        return !ConnectionAcceptorControlImpl.eqNode(node, connector.getTargetNode());
    }

    private static boolean isTargetConnectionChanged(Edge<ViewConnector<?>, Node> connector, Connection connection) {
        ViewConnector vc = (ViewConnector)connector.getContent();
        return !ConnectionAcceptorControlImpl.eqConnection(connection, null != vc ? vc.getTargetConnection() : Optional.empty());
    }

    private static boolean eqNode(Element<?> e1, Element<?> e2) {
        return ConnectionAcceptorControlImpl.eq(e1, e2);
    }

    private static boolean eqConnection(Connection c1, Optional<Connection> c2) {
        return ConnectionAcceptorControlImpl.eq(c1, c2.orElse(null));
    }

    private static boolean eq(Object n1, Object n2) {
        if (n1 == null && n2 == null) {
            return true;
        }
        return null != n1 && n1.equals(n2);
    }

    private boolean isAccept(CommandResult<CanvasViolation> result) {
        return !CommandUtils.isError(result);
    }

    private void highlight(Node node, Edge<ViewConnector<?>, Node> connector, boolean valid) {
        this.canvasHighlight.unhighLight();
        if (null != node && valid) {
            if (!node.getInEdges().contains(connector)) {
                this.canvasHighlight.highLight((Element)node);
            }
        } else if (null != node) {
            this.canvasHighlight.invalid((Element)node);
        }
    }

    private void ensureUnHighLight() {
        this.canvasHighlight.unhighLight();
    }

    public static Connection createConnection(WiresConnection wiresConnection, WiresMagnet wiresMagnet) {
        if (null == wiresMagnet && null == wiresConnection) {
            return null;
        }
        if (null == wiresMagnet) {
            return Point2DConnection.at((Point2D)Point2D.create((double)wiresConnection.getPoint().getX(), (double)wiresConnection.getPoint().getY()));
        }
        return new MagnetConnection.Builder().atX(wiresMagnet.getX()).atY(wiresMagnet.getY()).auto(null != wiresConnection && wiresConnection.isAutoConnection()).magnet(wiresMagnet.getIndex()).build();
    }

    public static MagnetConnection createConnection(Element element) {
        return null != element ? MagnetConnection.Builder.atCenter((Element)element) : null;
    }

    @Override
    protected void onDestroy(WiresCanvas canvas) {
        canvas.getWiresManager().setConnectionAcceptor(IConnectionAcceptor.NONE);
        this.canvasHighlight.destroy();
    }
}

