/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.impl;

import com.ait.lienzo.client.core.animation.AnimationCallback;
import com.ait.lienzo.client.core.animation.AnimationProperties;
import com.ait.lienzo.client.core.animation.AnimationProperty;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.shape.Shape;
import java.util.LinkedList;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.LienzoShapeView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.MultipleAnimationHandle;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateAttributeHandler;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHandler;
import org.uberfire.mvp.Command;

public class ShapeStateAttributeAnimationHandler<V extends LienzoShapeView>
implements ShapeStateHandler {
    private static final long ANIMATION_DURATION = 50L;
    private final ShapeStateAttributeHandler<V> handler = new ShapeStateAttributeHandler(this::applyState);
    private IAnimationHandle animationHandle;
    private Command completeCallback = () -> {};

    public ShapeStateAttributeHandler<V> getAttributesHandler() {
        return this.handler;
    }

    public ShapeStateAttributeAnimationHandler<V> onComplete(Command completeCallback) {
        this.completeCallback = completeCallback;
        return this;
    }

    public void applyState(ShapeState shapeState) {
        ShapeState currentState = this.getShapeState();
        if (!shapeState.equals((Object)currentState)) {
            if (null != this.animationHandle) {
                this.animationHandle.stop();
                this.setAnimationHandle(null);
            }
            this.handler.applyState(shapeState);
        }
    }

    public ShapeStateAttributeAnimationHandler<V> shapeAttributesChanged() {
        this.handler.shapeAttributesChanged();
        return this;
    }

    public ShapeState reset() {
        if (null != this.animationHandle) {
            this.animationHandle.stop();
            this.setAnimationHandle(null);
        }
        return this.handler.reset();
    }

    public ShapeState getShapeState() {
        return this.handler.getShapeState();
    }

    private void applyState(V view, ShapeStateAttributeHandler.ShapeStateAttributes attributes) {
        LinkedList<IAnimationHandle> handles = new LinkedList<IAnimationHandle>();
        view.getDecorators().forEach(dec -> handles.add(this.animate((Shape)dec, attributes, 50L)));
        this.setAnimationHandle(new MultipleAnimationHandle(handles));
    }

    private IAnimationHandle animate(Shape<?> shape, ShapeStateAttributeHandler.ShapeStateAttributes attributes, long duration) {
        AnimationProperties properties = new AnimationProperties();
        attributes.consume((attr, value) -> {
            switch (attr) {
                case FILL_COLOR: {
                    properties.push(AnimationProperty.Properties.FILL_COLOR((String)((String)value)));
                    break;
                }
                case FILL_ALPHA: {
                    properties.push(AnimationProperty.Properties.FILL_ALPHA((double)((Double)value)));
                    break;
                }
                case STROKE_COLOR: {
                    properties.push(AnimationProperty.Properties.STROKE_COLOR((String)((String)value)));
                    break;
                }
                case STROKE_ALPHA: {
                    properties.push(AnimationProperty.Properties.STROKE_ALPHA((double)((Double)value)));
                    break;
                }
                case STROKE_WIDTH: {
                    properties.push(AnimationProperty.Properties.STROKE_WIDTH((double)((Double)value)));
                }
            }
        });
        return shape.animate(AnimationTweener.LINEAR, properties, (double)duration, (IAnimationCallback)new AnimationCallback(){

            public void onClose(IAnimation animation, IAnimationHandle handle) {
                super.onClose(animation, handle);
                if (null != ShapeStateAttributeAnimationHandler.this.animationHandle && !ShapeStateAttributeAnimationHandler.this.animationHandle.isRunning()) {
                    ShapeStateAttributeAnimationHandler.this.setAnimationHandle(null);
                    ShapeStateAttributeAnimationHandler.this.completeCallback.execute();
                }
            }
        });
    }

    void setAnimationHandle(IAnimationHandle animationHandle) {
        this.animationHandle = animationHandle;
    }
}

