/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext;

import com.ait.lienzo.client.core.shape.GroupOf;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.ITextWrapper;
import com.ait.lienzo.client.core.shape.ITextWrapperWithBoundaries;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.TextBoundsWrap;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.layout.AbstractContainerLayout;
import com.ait.lienzo.client.core.shape.wires.layout.direction.DirectionLayout;
import com.ait.lienzo.client.core.shape.wires.layout.label.LabelLayout;
import com.ait.lienzo.client.core.shape.wires.layout.size.SizeConstraints;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext.TextWrapperProvider;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext.WiresShapeViewExt;
import org.kie.workbench.common.stunner.core.client.shape.TextWrapperStrategy;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.util.Exceptions;

public class WiresTextDecorator
implements HasTitle<WiresTextDecorator> {
    private static final double TEXT_ALPHA = 1.0;
    private static final String TEXT_FONT_FAMILY = "Verdana";
    private static final double TEXT_FONT_SIZE = 10.0;
    private static final String TEXT_FILL_COLOR = "#000000";
    private static final String TEXT_STROKE_COLOR = "#000000";
    private static final double TEXT_STROKE_WIDTH = 0.0;
    private static final TextAlign TEXT_ALIGN = TextAlign.CENTER;
    private final Supplier<ViewEventHandlerManager> eventHandlerManager;
    private ViewHandler<TextEnterEvent> textOverHandlerViewHandler;
    private ViewHandler<TextExitEvent> textOutEventViewHandler;
    private ViewHandler<TextClickEvent> textClickEventViewHandler;
    private ViewHandler<TextDoubleClickEvent> textDblClickEventViewHandler;
    private Text text;
    private ITextWrapper textWrapper;
    private LabelLayout labelLayout;
    private Optional<HasTitle.Size> sizeConstraints = Optional.empty();
    private Map<Enum, Double> margins = Collections.emptyMap();
    private WiresShapeViewExt<WiresShapeViewExt> shape;

    public WiresTextDecorator(Supplier<ViewEventHandlerManager> eventHandlerManager, WiresShapeViewExt shape) {
        this.eventHandlerManager = eventHandlerManager;
        this.shape = shape;
        this.initialize();
    }

    public void setTextClickHandler(ViewHandler<TextClickEvent> textClickEventViewHandler) {
        this.textClickEventViewHandler = textClickEventViewHandler;
    }

    public void setTextDblClickHandler(ViewHandler<TextDoubleClickEvent> textDblClickEventViewHandler) {
        this.textDblClickEventViewHandler = textDblClickEventViewHandler;
    }

    public void setTextEnterHandler(ViewHandler<TextEnterEvent> textOverHandlerViewHandler) {
        this.textOverHandlerViewHandler = textOverHandlerViewHandler;
    }

    public void setTextExitHandler(ViewHandler<TextExitEvent> textOutEventViewHandler) {
        this.textOutEventViewHandler = textOutEventViewHandler;
    }

    private void initialize() {
        this.text = (Text)((Text)((Text)((Text)((Text)new Text("").setAlpha(1.0)).setFontFamily(TEXT_FONT_FAMILY).setFontSize(10.0).setFillColor("#000000")).setStrokeColor("#000000")).setStrokeWidth(0.0)).setTextAlign(TEXT_ALIGN).setDraggable(false);
        this.textWrapper = new TextBoundsWrap(this.text, this.shape.getPath().getBoundingBox());
        this.text.setWrapper(this.textWrapper);
        this.text.setFillBoundsForSelection(true);
        this.initializeHandlers();
        this.setTextBoundaries(this.shape.getPath().getBoundingBox());
    }

    private void initializeHandlers() {
        this.registerTextEnterHandler();
        this.registerTextExitHandler();
        this.registerClickHandler();
        this.registerDoubleClickHandler();
    }

    private void registerClickHandler() {
        HandlerRegistration registration = this.text.addNodeMouseClickHandler(event -> {
            if (null != this.textClickEventViewHandler) {
                this.eventHandlerManager.get().skipClickHandler();
                TextClickEvent e = new TextClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textClickEventViewHandler.handle((ViewEvent)e);
                this.eventHandlerManager.get().restoreClickHandler();
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_CLICK, registration);
    }

    private void registerDoubleClickHandler() {
        HandlerRegistration registration = this.text.addNodeMouseDoubleClickHandler(event -> {
            if (null != this.textDblClickEventViewHandler) {
                this.eventHandlerManager.get().skipClickHandler();
                TextDoubleClickEvent e = new TextDoubleClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textDblClickEventViewHandler.handle((ViewEvent)e);
                this.eventHandlerManager.get().restoreClickHandler();
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_DBL_CLICK, registration);
    }

    private void registerTextEnterHandler() {
        HandlerRegistration registration = this.text.addNodeMouseEnterHandler(event -> {
            if (null != this.textOverHandlerViewHandler && this.hasText()) {
                TextEnterEvent textOverEvent = new TextEnterEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textOverHandlerViewHandler.handle((ViewEvent)textOverEvent);
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_ENTER, registration);
    }

    private void registerTextExitHandler() {
        HandlerRegistration registration = this.text.addNodeMouseExitHandler(event -> {
            if (null != this.textOutEventViewHandler && this.hasText()) {
                TextExitEvent textOutEvent = new TextExitEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textOutEventViewHandler.handle((ViewEvent)textOutEvent);
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_EXIT, registration);
    }

    public WiresTextDecorator setTitle(String title) {
        if (null == title) {
            this.text.setText(null);
        } else {
            this.text.setText(title.trim());
        }
        return this;
    }

    public WiresTextDecorator setMargins(Map<Enum, Double> margins) {
        this.margins = margins;
        return this;
    }

    public WiresTextDecorator setTitleRotation(double degrees) {
        this.text.setRotationDegrees(degrees);
        return this;
    }

    public WiresTextDecorator setTitleStrokeColor(String color) {
        this.text.setStrokeColor(color);
        return this;
    }

    public WiresTextDecorator setTitleFontFamily(String fontFamily) {
        this.text.setFontFamily(fontFamily);
        return this;
    }

    public WiresTextDecorator setTitleFontSize(double fontSize) {
        this.text.setFontSize(fontSize);
        return this;
    }

    public WiresTextDecorator setTitleFontColor(String fillColor) {
        this.text.setFillColor(fillColor);
        return this;
    }

    public WiresTextDecorator setTitleAlpha(double alpha) {
        this.text.setAlpha(alpha);
        return this;
    }

    public WiresTextDecorator setTitleStrokeWidth(double strokeWidth) {
        this.text.setStrokeWidth(strokeWidth);
        return this;
    }

    public String getTitleFontFamily() {
        return this.text.getFontFamily();
    }

    public double getTitleFontSize() {
        return this.text.getFontSize();
    }

    public String getTitlePosition() {
        return this.getLabelLayout().getDirectionLayout().getReferencePosition().toString();
    }

    public String getOrientation() {
        return this.getLabelLayout().getDirectionLayout().getOrientation().name();
    }

    public double getMarginX() {
        return this.getLabelLayout().getSizeConstraints().getMarginX();
    }

    public String getFontPosition() {
        return this.getLabelLayout().getDirectionLayout().getReferencePosition().name();
    }

    public String getFontAlignment() {
        return this.getLabelLayout().getDirectionLayout().getVerticalAlignment().name();
    }

    public WiresTextDecorator setTitleStrokeAlpha(double strokeAlpha) {
        this.text.setStrokeAlpha(strokeAlpha);
        return this;
    }

    public WiresTextDecorator setTextWrapper(TextWrapperStrategy strategy) {
        ITextWrapper wrapper;
        this.textWrapper = wrapper = this.getTextWrapper(strategy);
        this.text.setWrapper(this.textWrapper);
        this.update();
        return this;
    }

    public WiresTextDecorator setTitleXOffsetPosition(Double xOffset) {
        this.text.setX(xOffset.doubleValue());
        return this;
    }

    public WiresTextDecorator setTitleYOffsetPosition(Double yOffset) {
        this.text.setY(yOffset.doubleValue());
        return this;
    }

    public void setTextBoundaries(double width, double height) {
        this.setTextBoundaries(new BoundingBox(0.0, 0.0, width, height));
    }

    ITextWrapper getTextWrapper(TextWrapperStrategy strategy) {
        return TextWrapperProvider.get(strategy, this.text);
    }

    public WiresTextDecorator moveTitleToTop() {
        this.text.moveToTop();
        this.moveShapeChildrenToFront();
        return this;
    }

    private void moveShapeChildrenToFront() {
        this.shape.getChildShapes().toList().stream().map(WiresContainer::getGroup).forEach(GroupOf::moveToTop);
    }

    public Text getView() {
        return this.text;
    }

    public LabelLayout getLabelLayout() {
        return Optional.ofNullable(this.labelLayout).orElseGet(() -> new LabelLayout.Builder().horizontalAlignment(DirectionLayout.HorizontalAlignment.CENTER).verticalAlignment(DirectionLayout.VerticalAlignment.MIDDLE).orientation(DirectionLayout.Orientation.HORIZONTAL).referencePosition(DirectionLayout.ReferencePosition.INSIDE).sizeConstraints(this.getDefaultSizeConstraints()).build());
    }

    private SizeConstraints getDefaultSizeConstraints() {
        return new SizeConstraints(100.0, 100.0, SizeConstraints.Type.PERCENTAGE);
    }

    private <T extends Enum<T>> T convertEnum(Enum<?> input, Class<T> outputType) {
        return (T)((Enum)Exceptions.swallow(() -> Enum.valueOf(outputType, input.name()), null));
    }

    public WiresTextDecorator setTitlePosition(HasTitle.VerticalAlignment verticalAlignment, HasTitle.HorizontalAlignment horizontalAlignment, HasTitle.ReferencePosition referencePosition, HasTitle.Orientation orientation) {
        this.labelLayout = new LabelLayout.Builder().horizontalAlignment(this.convertEnum((Enum<?>)horizontalAlignment, (Class)DirectionLayout.HorizontalAlignment.class)).verticalAlignment(this.convertEnum((Enum<?>)verticalAlignment, (Class)DirectionLayout.VerticalAlignment.class)).orientation(this.convertEnum((Enum<?>)orientation, (Class)DirectionLayout.Orientation.class)).referencePosition(this.convertEnum((Enum<?>)referencePosition, (Class)DirectionLayout.ReferencePosition.class)).margins(this.margins.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(Optional.ofNullable(this.convertEnum((Enum)e.getKey(), DirectionLayout.VerticalAlignment.class)).orElse((DirectionLayout.VerticalAlignment)this.convertEnum((Enum)e.getKey(), DirectionLayout.HorizontalAlignment.class)), e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).sizeConstraints(this.sizeConstraints.map(s -> new SizeConstraints(s.getWidth(), s.getHeight(), this.convertEnum((Enum<?>)s.getType(), (Class)SizeConstraints.Type.class))).orElse(this.getDefaultSizeConstraints())).build();
        return this;
    }

    public WiresTextDecorator setTextSizeConstraints(HasTitle.Size sizeConstraints) {
        this.sizeConstraints = Optional.ofNullable(sizeConstraints);
        return this;
    }

    public void update() {
        this.setTextBoundaries(this.shape.getPath().getBoundingBox());
    }

    public void destroy() {
        if (null != this.text) {
            this.text.removeFromParent();
            this.text = null;
        }
        this.deregisterHandler(this.textOverHandlerViewHandler);
        this.deregisterHandler(this.textOutEventViewHandler);
        this.deregisterHandler(this.textClickEventViewHandler);
        this.deregisterHandler(this.textDblClickEventViewHandler);
        this.eventHandlerManager.get().destroy();
        this.textWrapper = null;
        this.labelLayout = null;
        this.sizeConstraints = null;
        this.margins.clear();
        this.margins = null;
        this.shape = null;
    }

    private void deregisterHandler(ViewHandler<?> handler) {
        if (null != handler) {
            this.eventHandlerManager.get().removeHandler(handler);
        }
    }

    private boolean hasText() {
        String text = this.text.getText();
        return null != text && text.trim().length() > 0;
    }

    void setTextBoundaries(BoundingBox boundaries) {
        Optional.ofNullable(this.textWrapper).filter(wrapper -> wrapper instanceof ITextWrapperWithBoundaries).map(wrapper -> (ITextWrapperWithBoundaries)wrapper).ifPresent(wrapper -> wrapper.setWrapBoundaries(this.shape.getLabelContainerLayout().map(layout -> layout.getMaxSize((IPrimitive)this.text)).orElse(boundaries)));
        this.shape.getLabelContainerLayout().ifPresent(AbstractContainerLayout::execute);
    }
}

