/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.index.bounds;

import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresLayer;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoLayerUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.index.bounds.CanvasBoundsIndexer;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.BoundsIndexer;

@Dependent
public class CanvasBoundsIndexerImpl
implements CanvasBoundsIndexer<AbstractCanvasHandler> {
    AbstractCanvasHandler canvasHandler;

    public BoundsIndexer<AbstractCanvasHandler, Node<View<?>, Edge>> build(AbstractCanvasHandler context) {
        this.canvasHandler = context;
        return this;
    }

    public Node<View<?>, Edge> getAt(double x, double y) {
        Shape shape;
        WiresCanvas canvas = (WiresCanvas)this.canvasHandler.getAbstractCanvas();
        WiresLayer lienzoLayer = canvas.getView().getLayer();
        String viewUUID = LienzoLayerUtils.getUUID_At(lienzoLayer, x, y);
        if (null != viewUUID && viewUUID.trim().length() > 0 && null != (shape = canvas.getShape(viewUUID))) {
            return this.canvasHandler.getGraphIndex().getNode(shape.getUUID());
        }
        return null;
    }

    public Node<View<?>, Edge> getAt(double x, double y, double width, double height, Element parentNode) {
        Node node;
        Shape shape;
        WiresCanvas canvas = (WiresCanvas)this.canvasHandler.getAbstractCanvas();
        WiresLayer lienzoLayer = canvas.getView().getLayer();
        String viewUUID_UL = LienzoLayerUtils.getUUID_At(lienzoLayer, x, y);
        String viewUUID_UR = LienzoLayerUtils.getUUID_At(lienzoLayer, x + width, y);
        String viewUUID_CC = LienzoLayerUtils.getUUID_At(lienzoLayer, x + width / 2.0, y + height / 2.0);
        String viewUUID_LL = LienzoLayerUtils.getUUID_At(lienzoLayer, x, y + height);
        String viewUUID_LR = LienzoLayerUtils.getUUID_At(lienzoLayer, x + width, y + height);
        if (null != viewUUID_UL && viewUUID_UL.trim().length() > 0) {
            Node node2;
            Shape shape2 = canvas.getShape(viewUUID_UL);
            if (null != shape2 && (node2 = this.canvasHandler.getGraphIndex().getNode(shape2.getUUID())) != parentNode) {
                return node2;
            }
        } else if (null != viewUUID_UR && viewUUID_UR.trim().length() > 0) {
            Node node3;
            Shape shape3 = canvas.getShape(viewUUID_UR);
            if (null != shape3 && (node3 = this.canvasHandler.getGraphIndex().getNode(shape3.getUUID())) != parentNode) {
                return node3;
            }
        } else if (null != viewUUID_CC && viewUUID_CC.trim().length() > 0) {
            Node node4;
            Shape shape4 = canvas.getShape(viewUUID_CC);
            if (null != shape4 && (node4 = this.canvasHandler.getGraphIndex().getNode(shape4.getUUID())) != parentNode) {
                return node4;
            }
        } else if (null != viewUUID_LL && viewUUID_LL.trim().length() > 0) {
            Node node5;
            Shape shape5 = canvas.getShape(viewUUID_LL);
            if (null != shape5 && (node5 = this.canvasHandler.getGraphIndex().getNode(shape5.getUUID())) != parentNode) {
                return node5;
            }
        } else if (null != viewUUID_LR && viewUUID_LR.trim().length() > 0 && null != (shape = canvas.getShape(viewUUID_LR)) && (node = this.canvasHandler.getGraphIndex().getNode(shape.getUUID())) != parentNode) {
            return node;
        }
        return null;
    }

    public double[] getTrimmedBounds() {
        return new double[0];
    }

    public void destroy() {
        this.canvasHandler = null;
    }
}

