/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.image.Image;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Shape;
import java.util.function.BiFunction;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.LienzoGlyphRenderer;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoShapeUtils;
import org.kie.workbench.common.stunner.core.client.shape.ImageStripGlyph;
import org.kie.workbench.common.stunner.core.client.shape.ImageStripRegistry;

@Dependent
public class LienzoImageStripGlyphRenderer
implements LienzoGlyphRenderer<ImageStripGlyph> {
    private final BiFunction<String, Integer, Image> imageBuilder;

    public LienzoImageStripGlyphRenderer() {
        this.imageBuilder = Image::new;
    }

    LienzoImageStripGlyphRenderer(BiFunction<String, Integer, Image> imageBuilder) {
        this.imageBuilder = imageBuilder;
    }

    public Class<ImageStripGlyph> getGlyphType() {
        return ImageStripGlyph.class;
    }

    public Group render(ImageStripGlyph glyph, double width, double height) {
        Group group = new Group();
        Image image = this.imageBuilder.apply(ImageStripRegistry.getName((Class)glyph.getStripType()), glyph.getIndex());
        this.scaleShape(image, width, height);
        group.add((IPrimitive)image);
        return group;
    }

    protected void scaleShape(Image image, double width, double height) {
        double iWidth = image.getWidth();
        double iHeight = image.getHeight();
        if (width != iWidth || height != iHeight) {
            LienzoShapeUtils.scale((Shape)image, width, height);
        }
    }
}

