/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.animation;

import com.ait.lienzo.client.core.animation.AnimationCallback;
import com.ait.lienzo.client.core.animation.AnimationProperties;
import com.ait.lienzo.client.core.animation.AnimationProperty;
import com.ait.lienzo.client.core.animation.AnimationTweener;
import com.ait.lienzo.client.core.animation.IAnimation;
import com.ait.lienzo.client.core.animation.IAnimationCallback;
import com.ait.lienzo.client.core.animation.IAnimationHandle;
import com.ait.lienzo.client.core.shape.Shape;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.LienzoShapeView;
import org.kie.workbench.common.stunner.core.client.animation.AbstractAnimation;
import org.kie.workbench.common.stunner.core.client.animation.AnimationHandle;

public class ShapeViewDecoratorAnimation
extends AbstractAnimation<LienzoShapeView<?>> {
    private final boolean isStrokeNotFill;
    private final Supplier<LienzoShapeView<?>> shapeView;
    private final String color;
    private final double alpha;
    private final double strokeWidth;
    private final AnimationCallback animationCallback = new AnimationCallback(){

        public void onStart(IAnimation animation, IAnimationHandle handle) {
            super.onStart(animation, handle);
            if (null != ShapeViewDecoratorAnimation.this.getCallback()) {
                ShapeViewDecoratorAnimation.this.getCallback().onStart();
            }
        }

        public void onFrame(IAnimation animation, IAnimationHandle handle) {
            super.onFrame(animation, handle);
            if (null != ShapeViewDecoratorAnimation.this.getCallback()) {
                ShapeViewDecoratorAnimation.this.getCallback().onFrame();
            }
        }

        public void onClose(IAnimation animation, IAnimationHandle handle) {
            super.onClose(animation, handle);
            if (null != ShapeViewDecoratorAnimation.this.getCallback()) {
                ShapeViewDecoratorAnimation.this.getCallback().onComplete();
            }
        }
    };

    public static ShapeViewDecoratorAnimation newStrokeDecoratorAnimation(Supplier<LienzoShapeView<?>> shapeView, String strokeColor, double strokeWidth, double strokeAlpha) {
        return new ShapeViewDecoratorAnimation(shapeView, strokeColor, strokeWidth, strokeAlpha);
    }

    public static ShapeViewDecoratorAnimation newFillDecoratorAnimation(Supplier<LienzoShapeView<?>> shapeView, String fillColor, double fillAlpha) {
        return new ShapeViewDecoratorAnimation(shapeView, fillColor, fillAlpha);
    }

    ShapeViewDecoratorAnimation(Supplier<LienzoShapeView<?>> shapeView, String fillColor, double fillAlpha) {
        this.isStrokeNotFill = false;
        this.shapeView = shapeView;
        this.color = fillColor;
        this.alpha = fillAlpha;
        this.strokeWidth = 0.0;
    }

    ShapeViewDecoratorAnimation(Supplier<LienzoShapeView<?>> shapeView, String strokeColor, double strokeWidth, double strokeAlpha) {
        this.isStrokeNotFill = true;
        this.shapeView = shapeView;
        this.color = strokeColor;
        this.alpha = strokeAlpha;
        this.strokeWidth = strokeWidth;
    }

    public LienzoShapeView<?> getSource() {
        return this.shapeView.get();
    }

    public AnimationHandle run() {
        final LinkedList handles = new LinkedList();
        this.getDecorators().forEach(dec -> handles.add(this.animate((Shape<?>)dec)));
        return new AnimationHandle(){

            public AnimationHandle run() {
                handles.forEach(IAnimationHandle::run);
                return this;
            }

            public AnimationHandle stop() {
                handles.forEach(IAnimationHandle::stop);
                return this;
            }

            public boolean isRunning() {
                for (IAnimationHandle h : handles) {
                    if (!h.isRunning()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Supplier<LienzoShapeView<?>> getShapeView() {
        return this.shapeView;
    }

    public String getColor() {
        return this.color;
    }

    public double getStrokeWidth() {
        return this.strokeWidth;
    }

    public double getAlpha() {
        return this.alpha;
    }

    private IAnimationHandle animate(Shape<?> shape) {
        AnimationProperties properties = this.isStrokeNotFill ? AnimationProperties.toPropertyList((AnimationProperty)AnimationProperty.Properties.STROKE_COLOR((String)this.color), (AnimationProperty[])new AnimationProperty[]{AnimationProperty.Properties.STROKE_ALPHA((double)this.alpha), AnimationProperty.Properties.STROKE_WIDTH((double)this.strokeWidth)}) : AnimationProperties.toPropertyList((AnimationProperty)AnimationProperty.Properties.FILL_COLOR((String)this.color), (AnimationProperty[])new AnimationProperty[]{AnimationProperty.Properties.FILL_ALPHA((double)this.alpha)});
        return shape.animate(AnimationTweener.LINEAR, properties, (double)this.getDuration(), (IAnimationCallback)this.getAnimationCallback());
    }

    private List<Shape<?>> getDecorators() {
        return this.getSource().getDecorators();
    }

    AnimationCallback getAnimationCallback() {
        return this.animationCallback;
    }
}

