/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.util;

import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.shape.wires.OptionalBounds;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.LinearGradient;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;

public class LienzoShapeUtils {
    public static void scale(Shape shape, double width, double height) {
        BoundingBox bb = shape.getBoundingBox();
        double[] scale = LienzoShapeUtils.getScaleFactor(bb.getWidth(), bb.getHeight(), width, height);
        shape.setScale(scale[0], scale[1]);
    }

    public static double[] getScaleFactor(double width, double height, double targetWidth, double targetHeight) {
        return new double[]{width > 0.0 ? targetWidth / width : 1.0, height > 0.0 ? targetHeight / height : 1.0};
    }

    public static LayoutContainer.Layout getWiresLayout(HasChildren.Layout layout) {
        switch (layout) {
            case CENTER: {
                return LayoutContainer.Layout.CENTER;
            }
            case LEFT: {
                return LayoutContainer.Layout.LEFT;
            }
            case RIGHT: {
                return LayoutContainer.Layout.RIGHT;
            }
            case TOP: {
                return LayoutContainer.Layout.TOP;
            }
            case BOTTOM: {
                return LayoutContainer.Layout.BOTTOM;
            }
        }
        throw new UnsupportedOperationException("Unsupported layout [" + layout.name() + "]");
    }

    public static LinearGradient getLinearGradient(String startColor, String endColor, Double width, Double height) {
        LinearGradient linearGradient = new LinearGradient(0.0, width.doubleValue(), 0.0, -height.doubleValue() / 2.0);
        linearGradient.addColorStop(1.0, endColor);
        linearGradient.addColorStop(0.0, startColor);
        return linearGradient;
    }

    public static OptionalBounds translateBounds(Bounds bounds) {
        OptionalBounds result = OptionalBounds.createEmptyBounds();
        if (bounds.hasUpperLeft()) {
            Bound upperLeft = bounds.getUpperLeft();
            if (upperLeft.hasX()) {
                result.setMinX(upperLeft.getX());
            }
            if (upperLeft.hasY()) {
                result.setMinY(upperLeft.getY());
            }
        }
        if (bounds.hasLowerRight()) {
            Bound lowerRight = bounds.getLowerRight();
            if (lowerRight.hasX()) {
                result.setMaxX(lowerRight.getX());
            }
            if (lowerRight.hasY()) {
                result.setMaxY(lowerRight.getY());
            }
        }
        return result;
    }
}

