/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.util.ScratchPad;
import com.ait.lienzo.shared.core.types.DataURLType;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasExport;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;

@ApplicationScoped
public class LienzoCanvasExport
implements CanvasExport<AbstractCanvasHandler> {
    static final String BG_COLOR = "#FFFFFF";

    public String toImageData(AbstractCanvasHandler canvasHandler, Layer.URLDataType urlDataType) {
        LienzoLayer layer = LienzoCanvasExport.getLayer(canvasHandler);
        Layer lienzoLayer = layer.getLienzoLayer();
        return LienzoCanvasExport.layerToDataURL(lienzoLayer, LienzoCanvasExport.getDataType(urlDataType), 0, 0, lienzoLayer.getWidth(), lienzoLayer.getHeight(), BG_COLOR);
    }

    public String toImageData(AbstractCanvasHandler canvasHandler, Layer.URLDataType urlDataType, int x, int y, int width, int height) {
        LienzoLayer layer = LienzoCanvasExport.getLayer(canvasHandler);
        Layer lienzoLayer = layer.getLienzoLayer();
        return LienzoCanvasExport.layerToDataURL(lienzoLayer, LienzoCanvasExport.getDataType(urlDataType), x, y, width, height, BG_COLOR);
    }

    private static String layerToDataURL(Layer layer, DataURLType dataURLType, int x, int y, int width, int height, String bgColor) {
        ScratchPad scratchPad = layer.getScratchPad();
        if (null != bgColor) {
            scratchPad.getContext().setFillColor(bgColor);
            scratchPad.getContext().fillRect((double)x, (double)y, (double)width, (double)height);
        }
        layer.drawWithTransforms(scratchPad.getContext(), 1.0, new BoundingBox((double)x, (double)y, (double)width, (double)height));
        String data = scratchPad.toDataURL(dataURLType, 1.0);
        scratchPad.clear();
        return data;
    }

    private static DataURLType getDataType(Layer.URLDataType type) {
        switch (type) {
            case JPG: {
                return DataURLType.JPG;
            }
            case PNG: {
                return DataURLType.PNG;
            }
        }
        throw new UnsupportedOperationException("Export data type [" + type.name() + "] not supported ");
    }

    private static LienzoLayer getLayer(AbstractCanvasHandler canvasHandler) {
        return (LienzoLayer)canvasHandler.getCanvas().getLayer();
    }
}

