/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.drag;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresConnectorView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresShapeView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.drag.ConnectorDragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.drag.ShapeViewDragProxy;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;

@Dependent
public class ConnectorDragProxyImpl
implements ConnectorDragProxy<AbstractCanvasHandler> {
    private final ShapeViewDragProxy<AbstractCanvas> shapeViewDragProxyFactory;
    private final GraphBoundsIndexer graphBoundsIndexer;
    private AbstractCanvasHandler canvasHandler;
    private WiresConnectorView<?> connectorShapeView;

    @Inject
    public ConnectorDragProxyImpl(ShapeViewDragProxy<AbstractCanvas> shapeViewDragProxyFactory, GraphBoundsIndexer graphBoundsIndexer) {
        this.shapeViewDragProxyFactory = shapeViewDragProxyFactory;
        this.graphBoundsIndexer = graphBoundsIndexer;
    }

    public DragProxy<AbstractCanvasHandler, ConnectorDragProxy.Item, DragProxyCallback> proxyFor(AbstractCanvasHandler context) {
        this.canvasHandler = context;
        this.shapeViewDragProxyFactory.proxyFor((Object)context.getAbstractCanvas());
        this.graphBoundsIndexer.setRootUUID(context.getDiagram().getMetadata().getCanvasRootUUID());
        return this;
    }

    public DragProxy<AbstractCanvasHandler, ConnectorDragProxy.Item, DragProxyCallback> show(ConnectorDragProxy.Item item, int x, int y, final DragProxyCallback callback) {
        Node sourceNode = item.getSourceNode();
        Shape sourceNodeShape = this.getCanvas().getShape(sourceNode.getUUID());
        WiresShapeView transientShapeView = new WiresShapeView((MultiPath)((MultiPath)new MultiPath().rect(0.0, 0.0, 1.0, 1.0).setFillAlpha(0.0)).setStrokeAlpha(0.0));
        this.getWiresManager().getMagnetManager().createMagnets(transientShapeView);
        Edge edge = item.getEdge();
        Shape edgeShape = item.getShapeFactory().newShape(((View)edge.getContent()).getDefinition());
        EdgeShape connectorShape = (EdgeShape)edgeShape;
        this.connectorShapeView = (WiresConnectorView)edgeShape.getShapeView();
        this.getWiresManager().register(this.connectorShapeView);
        connectorShape.applyProperties((Object)edge, MutationContext.STATIC);
        MagnetConnection centerConnection = new MagnetConnection.Builder().atX(0.0).atY(0.0).magnet(0).build();
        this.connectorShapeView.connect(sourceNodeShape.getShapeView(), (Connection)centerConnection, transientShapeView, (Connection)centerConnection);
        this.graphBoundsIndexer.build((Object)this.canvasHandler.getDiagram().getGraph());
        this.shapeViewDragProxyFactory.show(transientShapeView, x, y, (Object)new DragProxyCallback(){

            public void onStart(int x, int y) {
                callback.onStart(x, y);
            }

            public void onMove(int x, int y) {
                callback.onMove(x, y);
            }

            public void onComplete(int x, int y) {
                callback.onComplete(x, y);
                ConnectorDragProxyImpl.this.deregisterTransientConnector();
                ConnectorDragProxyImpl.this.getCanvas().draw();
            }
        });
        return this;
    }

    public void clear() {
        if (null != this.shapeViewDragProxyFactory) {
            this.shapeViewDragProxyFactory.clear();
        }
        this.deregisterTransientConnector();
    }

    public void destroy() {
        this.clear();
        this.graphBoundsIndexer.destroy();
        this.shapeViewDragProxyFactory.destroy();
        this.canvasHandler = null;
    }

    private WiresManager getWiresManager() {
        AbstractCanvas canvas = this.canvasHandler.getAbstractCanvas();
        LienzoLayer layer = (LienzoLayer)canvas.getLayer();
        return WiresManager.get((Layer)layer.getLienzoLayer());
    }

    private void deregisterTransientConnector() {
        if (null != this.connectorShapeView) {
            this.getWiresManager().deregister(this.connectorShapeView);
            this.getCanvas().draw();
            this.connectorShapeView = null;
        }
    }

    private AbstractCanvas<?> getCanvas() {
        return this.canvasHandler.getAbstractCanvas();
    }
}

