/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.impl;

import java.util.function.Function;
import org.kie.workbench.common.stunner.client.lienzo.shape.animation.ShapeDecoratorAnimation;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHandler;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateStrokeHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class AnimatedShapeStateStrokeHandler<V extends ShapeView<?>, S extends Shape<V>>
implements ShapeStateHandler<V, S> {
    private final ShapeStateStrokeHandler<V, S> handler;

    public AnimatedShapeStateStrokeHandler() {
        this.handler = new ShapeStateStrokeHandler(AnimatedShapeStateStrokeHandler::applyAnimatedStrokeState);
    }

    public AnimatedShapeStateStrokeHandler(Function<ShapeState, String> stateColorProvider) {
        this.handler = new ShapeStateStrokeHandler(AnimatedShapeStateStrokeHandler::applyAnimatedStrokeState, stateColorProvider);
    }

    AnimatedShapeStateStrokeHandler(ShapeStateStrokeHandler<V, S> handler) {
        this.handler = handler;
    }

    public ShapeStateHandler<V, S> forShape(S shape) {
        this.handler.forShape(shape);
        return this;
    }

    public ShapeStateHandler<V, S> shapeUpdated() {
        this.handler.shapeUpdated();
        return this;
    }

    public void applyState(ShapeState shapeState) {
        this.handler.applyState(shapeState);
    }

    public ShapeState reset() {
        return this.handler.reset();
    }

    public ShapeState getShapeState() {
        return this.handler.getShapeState();
    }

    public ShapeStateStrokeHandler<V, S> getWrapped() {
        return this.handler;
    }

    private static void applyAnimatedStrokeState(Shape<? extends ShapeView<?>> shape, ShapeStateStrokeHandler.ShapeStrokeState state) {
        new ShapeDecoratorAnimation(state.getStrokeColor(), state.getStrokeWidth(), state.getStrokeAlpha()).forShape(shape).run();
    }
}

