/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires;

import com.ait.lienzo.client.core.Attribute;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.wires.WiresLayoutContainer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.tooling.nativetools.client.collection.NFastArrayList;
import java.util.function.Predicate;

public class WiresScalableContainer
extends WiresLayoutContainer {
    private final NFastArrayList<IPrimitive<?>> scalableChildren = new NFastArrayList();
    private Group transformableContainer;
    private double width = -1.0;
    private double height = -1.0;

    public WiresScalableContainer() {
    }

    WiresScalableContainer(Group transformableContainer) {
        this();
        this.transformableContainer = transformableContainer;
    }

    private boolean isScalable(IPrimitive<?> child) {
        return this.hasWidthHeight().test(child);
    }

    private void scaleChildTo(IPrimitive<?> child, double x, double y, double width, double height) {
        if (this.hasWidthHeight().test(child)) {
            if (width > 0.0) {
                child.getAttributes().setWidth(width);
            }
            if (height > 0.0) {
                child.getAttributes().setHeight(height);
            }
        }
        child.getAttributes().setX(x);
        child.getAttributes().setY(y);
    }

    public WiresScalableContainer addScalable(IPrimitive<?> child) {
        if (this.isScalable(child)) {
            this.scalableChildren.add(child);
            this.add(child);
        } else {
            if (null == this.transformableContainer) {
                this.transformableContainer = new Group();
                this.getGroup().add((IPrimitive)this.transformableContainer);
            }
            this.transformableContainer.add(child);
        }
        return this;
    }

    public void scaleTo(double x, double y, double width, double height) {
        this.scaleTo(x, y, width, height, () -> {}, () -> {});
    }

    public void scaleTo(double x, double y, double width, double height, Runnable before, Runnable after) {
        if (this.isSizeChanged(width, height)) {
            this.width = width;
            this.height = height;
            before.run();
            if (null != this.transformableContainer) {
                BoundingBox bb = this.transformableContainer.getBoundingBox();
                double sx = width / bb.getWidth();
                double sy = height / bb.getHeight();
                ((Group)((Group)this.transformableContainer.setX(x)).setY(y)).setScale(sx, sy);
            }
            for (int i = 0; i < this.scalableChildren.size(); ++i) {
                IPrimitive child = (IPrimitive)this.scalableChildren.get(i);
                this.scaleChildTo(child, x, y, width, height);
            }
            after.run();
        }
    }

    private double getWidth(IPrimitive<?> prim) {
        return prim.getAttributes().getDouble(Attribute.WIDTH.getProperty());
    }

    private double getHeight(IPrimitive<?> prim) {
        return prim.getAttributes().getDouble(Attribute.HEIGHT.getProperty());
    }

    private Predicate<IPrimitive> hasWidthHeight() {
        return primitive -> this.getWidth((IPrimitive<?>)primitive) > 0.0 && this.getHeight((IPrimitive<?>)primitive) > 0.0;
    }

    private boolean isSizeChanged(double width, double height) {
        return this.width != width || this.height != height;
    }
}

