/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.ITextWrapper;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.shape.TextBoundsWrap;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextEnterEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextExitEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;

public class WiresTextDecorator {
    private static final double TEXT_ALPHA = 1.0;
    private static final String TEXT_FONT_FAMILY = "Verdana";
    private static final double TEXT_FONT_SIZE = 10.0;
    private static final String TEXT_FILL_COLOR = "#000000";
    private static final String TEXT_STROKE_COLOR = "#000000";
    private static final double TEXT_STROKE_WIDTH = 0.5;
    private static final TextAlign TEXT_ALIGN = TextAlign.CENTER;
    private static final LayoutContainer.Layout TEXT_LAYOUT_ALIGN = LayoutContainer.Layout.CENTER;
    private final Supplier<ViewEventHandlerManager> eventHandlerManager;
    private final Group textContainer = new Group();
    private ViewHandler<TextEnterEvent> textOverHandlerViewHandler;
    private ViewHandler<TextExitEvent> textOutEventViewHandler;
    private ViewHandler<TextClickEvent> textClickEventViewHandler;
    private ViewHandler<TextDoubleClickEvent> textDblClickEventViewHandler;
    private Text text;
    private TextBoundsWrap textWrapper;
    private LayoutContainer.Layout currentTextLayout;
    private double width;
    private double height;

    public WiresTextDecorator(Supplier<ViewEventHandlerManager> eventHandlerManager) {
        this.eventHandlerManager = eventHandlerManager;
        this.initialize();
    }

    public void setTextClickHandler(ViewHandler<TextClickEvent> textClickEventViewHandler) {
        this.textClickEventViewHandler = textClickEventViewHandler;
    }

    public void setTextDblClickHandler(ViewHandler<TextDoubleClickEvent> textDblClickEventViewHandler) {
        this.textDblClickEventViewHandler = textDblClickEventViewHandler;
    }

    public void setTextEnterHandler(ViewHandler<TextEnterEvent> textOverHandlerViewHandler) {
        this.textOverHandlerViewHandler = textOverHandlerViewHandler;
    }

    public void setTextExitHandler(ViewHandler<TextExitEvent> textOutEventViewHandler) {
        this.textOutEventViewHandler = textOutEventViewHandler;
    }

    private void initialize() {
        this.text = (Text)((Text)((Text)((Text)((Text)new Text("").setAlpha(1.0)).setFontFamily(TEXT_FONT_FAMILY).setFontSize(10.0).setFillColor("#000000")).setStrokeColor("#000000")).setStrokeWidth(0.5)).setTextAlign(TEXT_ALIGN).setDraggable(false);
        this.textWrapper = new TextBoundsWrap(this.text, new BoundingBox(0.0, 0.0, 1.0, 1.0));
        this.text.setWrapper((ITextWrapper)this.textWrapper);
        this.currentTextLayout = TEXT_LAYOUT_ALIGN;
        this.textContainer.add((IPrimitive)this.text);
        this.text.setFillBoundsForSelection(true);
        this.initializeHandlers();
    }

    private void initializeHandlers() {
        this.registerTextEnterHandler();
        this.registerTextExitHandler();
        this.registerClickHandler();
        this.registerDoubleClickHandler();
    }

    private void registerClickHandler() {
        HandlerRegistration registration = this.text.addNodeMouseClickHandler(event -> {
            if (null != this.textClickEventViewHandler) {
                this.eventHandlerManager.get().skipClickHandler();
                TextClickEvent e = new TextClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textClickEventViewHandler.handle((ViewEvent)e);
                this.eventHandlerManager.get().restoreClickHandler();
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_CLICK, registration);
    }

    private void registerDoubleClickHandler() {
        HandlerRegistration registration = this.text.addNodeMouseDoubleClickHandler(event -> {
            if (null != this.textDblClickEventViewHandler) {
                this.eventHandlerManager.get().skipClickHandler();
                TextDoubleClickEvent e = new TextDoubleClickEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textDblClickEventViewHandler.handle((ViewEvent)e);
                this.eventHandlerManager.get().restoreClickHandler();
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_DBL_CLICK, registration);
    }

    private void registerTextEnterHandler() {
        HandlerRegistration registration = this.text.addNodeMouseEnterHandler(event -> {
            if (null != this.textOverHandlerViewHandler && this.hasText()) {
                TextEnterEvent textOverEvent = new TextEnterEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textOverHandlerViewHandler.handle((ViewEvent)textOverEvent);
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_ENTER, registration);
    }

    private void registerTextExitHandler() {
        HandlerRegistration registration = this.text.addNodeMouseExitHandler(event -> {
            if (null != this.textOutEventViewHandler && this.hasText()) {
                TextExitEvent textOutEvent = new TextExitEvent((double)event.getX(), (double)event.getY(), (double)event.getMouseEvent().getClientX(), (double)event.getMouseEvent().getClientY());
                this.textOutEventViewHandler.handle((ViewEvent)textOutEvent);
            }
        });
        this.eventHandlerManager.get().addHandlersRegistration(ViewEventType.TEXT_EXIT, registration);
    }

    public void setTitle(String title) {
        if (null == title) {
            this.text.setText(null);
        } else {
            this.text.setText(title.trim());
        }
    }

    public boolean setTitlePosition(HasTitle.Position position) {
        LayoutContainer.Layout layout = LayoutContainer.Layout.CENTER;
        switch (position) {
            case BOTTOM: {
                layout = LayoutContainer.Layout.BOTTOM;
                break;
            }
            case TOP: {
                layout = LayoutContainer.Layout.TOP;
                break;
            }
            case LEFT: {
                layout = LayoutContainer.Layout.LEFT;
                break;
            }
            case RIGHT: {
                layout = LayoutContainer.Layout.RIGHT;
            }
        }
        boolean changed = !this.currentTextLayout.equals((Object)layout);
        this.currentTextLayout = layout;
        return changed;
    }

    public void setTitleRotation(double degrees) {
        this.text.setRotationDegrees(degrees);
    }

    public void setTitleStrokeColor(String color) {
        this.text.setStrokeColor(color);
    }

    public void setTitleFontFamily(String fontFamily) {
        this.text.setFontFamily(fontFamily);
    }

    public void setTitleFontSize(double fontSize) {
        this.text.setFontSize(fontSize);
    }

    public void setTitleFontColor(String fillColor) {
        this.text.setFillColor(fillColor);
    }

    public void setTitleAlpha(double alpha) {
        this.text.setAlpha(alpha);
    }

    public void setTitleStrokeWidth(double strokeWidth) {
        this.text.setStrokeWidth(strokeWidth);
    }

    public void moveTitleToTop() {
        this.textContainer.moveToTop();
    }

    public IPrimitive<?> getView() {
        return this.textContainer;
    }

    public LayoutContainer.Layout getLayout() {
        return this.currentTextLayout;
    }

    public void update() {
        this.updateTextBoundaries();
    }

    public void resize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void destroy() {
        if (null != this.text) {
            this.text.removeFromParent();
            this.text = null;
        }
        this.textContainer.removeFromParent();
        this.deregisterHandler(this.textOverHandlerViewHandler);
        this.deregisterHandler(this.textOutEventViewHandler);
        this.deregisterHandler(this.textClickEventViewHandler);
        this.deregisterHandler(this.textDblClickEventViewHandler);
    }

    private void deregisterHandler(ViewHandler<?> handler) {
        if (null != handler) {
            this.eventHandlerManager.get().removeHandler(handler);
        }
    }

    private boolean hasText() {
        String text = this.text.getText();
        return null != text && text.trim().length() > 0;
    }

    private void updateTextBoundaries() {
        this.setTextBoundaries(new BoundingBox(0.0, 9.0, this.width, this.height));
    }

    void setTextBoundaries(BoundingBox boundaries) {
        switch (this.getLayout()) {
            case LEFT: {
                if (null == boundaries) break;
                this.textWrapper.setWrapBoundaries(new BoundingBox(boundaries.getMinY(), boundaries.getMaxX(), boundaries.getMaxY(), boundaries.getMaxX()));
                break;
            }
            case RIGHT: {
                if (null == boundaries) break;
                this.textWrapper.setWrapBoundaries(new BoundingBox(boundaries.getMinY(), boundaries.getMaxX(), boundaries.getMaxY(), boundaries.getMaxX()));
                break;
            }
            default: {
                this.textWrapper.setWrapBoundaries(boundaries);
            }
        }
    }
}

