/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.util;

import com.ait.lienzo.client.core.shape.Picture;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.LinearGradient;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoUtils;
import org.kie.workbench.common.stunner.core.client.shape.HasChildren;

public class LienzoShapeUtils {
    public static void scalePicture(Picture picture, double width, double height) {
        BoundingBox bb = picture.getBoundingBox();
        double[] scale = LienzoUtils.getScaleFactor(bb.getWidth(), bb.getHeight(), width, height);
        picture.setScale(scale[0], scale[1]);
    }

    public static LayoutContainer.Layout getWiresLayout(HasChildren.Layout layout) {
        switch (layout) {
            case CENTER: {
                return LayoutContainer.Layout.CENTER;
            }
            case LEFT: {
                return LayoutContainer.Layout.LEFT;
            }
            case RIGHT: {
                return LayoutContainer.Layout.RIGHT;
            }
            case TOP: {
                return LayoutContainer.Layout.TOP;
            }
            case BOTTOM: {
                return LayoutContainer.Layout.BOTTOM;
            }
        }
        throw new UnsupportedOperationException("Unsupported layout [" + layout.name() + "]");
    }

    public static LinearGradient getLinearGradient(String startColor, String endColor, Double width, Double height) {
        LinearGradient linearGradient = new LinearGradient(0.0, width.doubleValue(), 0.0, -height.doubleValue() / 2.0);
        linearGradient.addColorStop(1.0, endColor);
        linearGradient.addColorStop(0.0, startColor);
        return linearGradient;
    }
}

