/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IContainmentAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractAcceptorControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasHighlight;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
@Default
public class ContainmentAcceptorControlImpl
extends AbstractAcceptorControl
implements ContainmentAcceptorControl<AbstractCanvasHandler> {
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final CanvasHighlight canvasHighlight;
    private final IContainmentAcceptor CONTAINMENT_ACCEPTOR = new IContainmentAcceptor(){

        public boolean containmentAllowed(WiresContainer wiresContainer, WiresShape[] shapes) {
            if (!ContainmentAcceptorControlImpl.this.isWiresParentAccept(wiresContainer)) {
                return false;
            }
            Node parentNode = this.toNode(wiresContainer);
            return ContainmentAcceptorControlImpl.this.allow((Element)parentNode, this.toNodeArray(shapes));
        }

        public boolean acceptContainment(WiresContainer wiresContainer, WiresShape[] shapes) {
            if (!ContainmentAcceptorControlImpl.this.isWiresParentAccept(wiresContainer)) {
                return false;
            }
            Node parentNode = this.toNode(wiresContainer);
            return ContainmentAcceptorControlImpl.this.accept((Element)parentNode, this.toNodeArray(shapes));
        }

        private Node[] toNodeArray(WiresShape[] shapes) {
            ArrayList<Node> nodes = new ArrayList<Node>(shapes.length);
            for (WiresShape shape : shapes) {
                Node node = this.toNode((WiresContainer)shape);
                if (null == node) continue;
                nodes.add(node);
            }
            return nodes.toArray(new Node[nodes.size()]);
        }

        private Node toNode(WiresContainer shape) {
            return WiresUtils.getNode(ContainmentAcceptorControlImpl.this.getCanvasHandler(), shape);
        }
    };

    @Inject
    public ContainmentAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, CanvasHighlight canvasHighlight) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.canvasHighlight = canvasHighlight;
    }

    @Override
    protected void onInit(WiresCanvas canvas) {
        canvas.getWiresManager().setContainmentAcceptor(this.CONTAINMENT_ACCEPTOR);
        this.canvasHighlight.setCanvasHandler(this.getCanvasHandler());
    }

    @Override
    protected void onDestroy(WiresCanvas canvas) {
        canvas.getWiresManager().setContainmentAcceptor(IContainmentAcceptor.NONE);
        this.canvasHighlight.destroy();
    }

    public boolean allow(Element parent, Node[] children) {
        return this.evaluate(parent, children, command -> this.getCommandManager().allow((Object)this.getCanvasHandler(), command), true);
    }

    public boolean accept(Element parent, Node[] children) {
        return this.evaluate(parent, children, command -> this.getCommandManager().execute((Object)this.getCanvasHandler(), command), false);
    }

    private boolean evaluate(Element parent, Node[] children, Function<Command<AbstractCanvasHandler, CanvasViolation>, CommandResult<CanvasViolation>> executor, boolean highlights) {
        if (children == null || children.length == 0) {
            return false;
        }
        if (parent == null && children.length >= 2) {
            return false;
        }
        boolean success = true;
        if (!ContainmentAcceptorControlImpl.areInSameParent(parent, children)) {
            Collection childNodes = Stream.of(children).collect(Collectors.toSet());
            CanvasCommand command = this.canvasCommandFactory.updateChildren((Node)parent, childNodes);
            CommandResult<CanvasViolation> result = executor.apply((Command<AbstractCanvasHandler, CanvasViolation>)command);
            success = this.isCommandSuccess(result);
            if (highlights && !success) {
                this.canvasHighlight.invalid(result.getViolations());
            }
        }
        if (!highlights || success) {
            this.canvasHighlight.unhighLight();
        }
        return success;
    }

    static boolean areInSameParent(Element parent, Node[] children) {
        return Stream.of(children).map(GraphUtils::getParent).noneMatch(childParent -> !Objects.equals(parent, childParent));
    }
}

