/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas;

import com.ait.lienzo.client.core.config.LienzoCore;
import com.ait.lienzo.client.core.shape.Node;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvasView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.ViewEventHandlerManager;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoLayerUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasSettings;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasDrawnEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.uberfire.mvp.Command;

public abstract class LienzoCanvas<V extends LienzoCanvasView>
extends AbstractCanvas<V> {
    private static final ViewEventType[] SUPPORTED_EVENT_TYPES = new ViewEventType[]{ViewEventType.MOUSE_CLICK, ViewEventType.MOUSE_DBL_CLICK, ViewEventType.MOUSE_MOVE};
    private ViewEventHandlerManager eventHandlerManager;

    protected LienzoCanvas(Event<CanvasClearEvent> canvasClearEvent, Event<CanvasShapeAddedEvent> canvasShapeAddedEvent, Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent, Event<CanvasDrawnEvent> canvasDrawnEvent, Event<CanvasFocusedEvent> canvasFocusedEvent) {
        super(canvasClearEvent, canvasShapeAddedEvent, canvasShapeRemovedEvent, canvasDrawnEvent, canvasFocusedEvent);
    }

    public AbstractCanvas<V> initialize(CanvasPanel panel, CanvasSettings settings) {
        this.eventHandlerManager = new ViewEventHandlerManager((Node<?>)((LienzoLayer)((LienzoCanvasView)this.getView()).getLayer()).getLienzoLayer(), SUPPORTED_EVENT_TYPES);
        return this.initialize(panel, settings, this.eventHandlerManager);
    }

    AbstractCanvas<V> initialize(CanvasPanel panel, CanvasSettings settings, ViewEventHandlerManager viewEventHandlerManager) {
        LienzoCore.get().setHidpiEnabled(settings.isHiDPIEnabled());
        this.eventHandlerManager = viewEventHandlerManager;
        return super.initialize(panel, settings);
    }

    public Optional<Shape> getShapeAt(double x, double y) {
        Object lienzoLayer = ((LienzoCanvasView)this.getView()).getLayer();
        String uuid = LienzoLayerUtils.getUUID_At(lienzoLayer, x, y);
        return Optional.ofNullable(this.getShape(uuid));
    }

    public void onAfterDraw(Command callback) {
        ((LienzoLayer)((LienzoCanvasView)this.getView()).getLayer()).onAfterDraw(callback);
    }

    public void focus() {
        ((LienzoCanvasView)this.getView()).getLienzoPanel().focus();
    }

    public boolean supports(ViewEventType type) {
        return this.eventHandlerManager.supports(type);
    }

    public AbstractCanvas<V> addHandler(ViewEventType type, ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.addHandler(type, eventHandler);
        return this;
    }

    public AbstractCanvas<V> removeHandler(ViewHandler<? extends ViewEvent> eventHandler) {
        this.eventHandlerManager.removeHandler(eventHandler);
        return this;
    }

    public AbstractCanvas<V> enableHandlers() {
        this.eventHandlerManager.enable();
        return this;
    }

    public AbstractCanvas<V> disableHandlers() {
        this.eventHandlerManager.disable();
        return this;
    }

    public Shape<?> getAttachableShape() {
        return null;
    }

    public void destroy() {
        if (null != this.eventHandlerManager) {
            this.eventHandlerManager.destroy();
            this.eventHandlerManager = null;
        }
        super.destroy();
    }

    ViewEventHandlerManager getEventHandlerManager() {
        return this.eventHandlerManager;
    }
}

