/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.canvas.TransformImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.uberfire.mvp.Command;

@Dependent
public class LienzoLayer {
    private static Logger LOGGER = Logger.getLogger(LienzoLayer.class.getName());
    private final LienzoCustomLayer layer;

    public void setSkipDraw(boolean skipDraw) {
        this.layer.skipDraw = skipDraw;
    }

    public LienzoLayer() {
        this(new LienzoCustomLayer());
    }

    LienzoLayer(LienzoCustomLayer layer) {
        this.layer = layer;
    }

    public LienzoLayer add(IPrimitive<?> shape) {
        if (this.layer.getChildNodes().contains(shape)) {
            LOGGER.log(Level.WARNING, "Cannot add a primitive shape into the layer twice!");
        } else {
            this.layer.add(shape);
        }
        return this;
    }

    public LienzoLayer delete(IPrimitive<?> shape) {
        this.layer.remove(shape);
        return this;
    }

    public void clear() {
        this.layer.clear();
    }

    public void onAfterDraw(Command callback) {
        this.layer.setOnLayerAfterDraw(layer1 -> callback.execute());
    }

    public Layer getTopLayer() {
        return this.isReady() ? this.layer.getScene().getTopLayer() : null;
    }

    public void add(Layer layer) {
        if (this.isReady()) {
            this.layer.getScene().add(layer);
        }
    }

    public boolean isReady() {
        return null != this.layer.getScene();
    }

    public void remove(Layer layer) {
        if (this.isReady()) {
            this.layer.getScene().remove(layer);
        }
    }

    public void destroy() {
        this.layer.removeAll();
        this.layer.removeFromParent();
    }

    public Layer getLienzoLayer() {
        return this.layer;
    }

    protected Point2D getTranslate() {
        return new Point2D(this.layer.getAbsoluteTransform().getTranslateX(), this.layer.getAbsoluteTransform().getTranslateY());
    }

    protected Point2D getScale() {
        return new Point2D(this.layer.getAbsoluteTransform().getScaleX(), this.layer.getAbsoluteTransform().getScaleY());
    }

    public org.kie.workbench.common.stunner.core.client.canvas.Transform getTransform() {
        return new TransformImpl(this.getTranslate(), this.getScale());
    }

    public void translate(double tx, double ty) {
        this.setTransform(t -> this.translate(t, tx, ty));
    }

    public void scale(double sx, double sy) {
        this.setTransform(t -> this.scale(t, sx, sy));
    }

    public void scale(double delta) {
        this.setTransform(t -> this.scale(t, delta));
    }

    private void setTransform(TransformCallback callback) {
        Transform transform = this.getViewPort().getTransform();
        if (transform == null) {
            transform = new Transform();
            this.getViewPort().setTransform(transform);
        }
        callback.apply(transform);
        this.getViewPort().setTransform(transform);
    }

    private void scale(Transform transform, double sx, double sy) {
        transform.scale(sx, sy);
        this.getViewPort().batch();
    }

    private void scale(Transform transform, double delta) {
        transform.scale(delta);
    }

    private void translate(Transform transform, double tx, double ty) {
        transform.translate(tx, ty);
    }

    private Viewport getViewPort() {
        return this.layer.getViewport();
    }

    private static interface TransformCallback {
        public void apply(Transform var1);
    }

    static class LienzoCustomLayer
    extends Layer {
        private boolean skipDraw = false;

        LienzoCustomLayer() {
        }

        public Layer draw(Context2D context) {
            if (this.skipDraw) {
                return this;
            }
            return super.draw(context);
        }
    }
}

