/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.wires;

import com.ait.lienzo.client.core.shape.wires.MagnetManager;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import com.ait.lienzo.client.core.shape.wires.handlers.WiresDockingControl;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.shared.core.types.Direction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;

@Dependent
public class WiresLayer
extends LienzoLayer {
    private static Logger LOGGER = Logger.getLogger(WiresLayer.class.getName());
    static final Direction[] MAGNET_CARDINALS = MagnetManager.FOUR_CARDINALS;
    private WiresManager wiresManager;

    public WiresLayer use(WiresManager wiresManager) {
        this.wiresManager = wiresManager;
        return this;
    }

    public LienzoLayer add(WiresShape wiresShape) {
        if (this.contains(wiresShape)) {
            LOGGER.log(Level.WARNING, "Cannot add a WiresShape into the WiresLayer twice!");
        } else {
            this.wiresManager.register(wiresShape);
            this.wiresManager.getMagnetManager().createMagnets(wiresShape, MAGNET_CARDINALS);
            WiresUtils.assertShapeGroup(wiresShape.getGroup(), "stnner.wiresCanvas");
        }
        return this;
    }

    private boolean contains(WiresShape wiresShape) {
        return null != this.wiresManager.getShape(wiresShape.uuid());
    }

    public LienzoLayer add(WiresConnector wiresConnector) {
        this.wiresManager.register(wiresConnector);
        WiresUtils.assertShapeGroup(wiresConnector.getGroup(), "stnner.wiresCanvas");
        return this;
    }

    public LienzoLayer delete(WiresShape wiresShape) {
        this.wiresManager.deregister(wiresShape);
        return this;
    }

    public LienzoLayer delete(WiresConnector wiresConnector) {
        this.wiresManager.deregister(wiresConnector);
        return this;
    }

    public WiresLayer addChild(WiresContainer parent, WiresShape child) {
        parent.add(child);
        return this;
    }

    public WiresLayer deleteChild(WiresContainer parent, WiresShape child) {
        parent.remove(child);
        return this;
    }

    public WiresLayer dock(WiresContainer parent, WiresShape child) {
        WiresDockingControl dockingControl = child.getControl().getDockingControl();
        dockingControl.dock(parent);
        Point2D candidateLocation = dockingControl.getCandidateLocation();
        if (null != candidateLocation) {
            child.setLocation(candidateLocation);
        }
        return this;
    }

    public WiresLayer undock(WiresShape child) {
        child.getControl().getDockingControl().undock();
        return this;
    }

    public WiresManager getWiresManager() {
        return this.wiresManager;
    }

    @Override
    public void destroy() {
        WiresManager.remove((WiresManager)this.wiresManager);
        this.wiresManager = null;
        super.destroy();
    }
}

