/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.glyph;

import com.ait.lienzo.client.core.shape.Picture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.components.glyph.AbstractLienzoShapeGlyphRenderer;
import org.kie.workbench.common.stunner.core.client.shape.SvgDataUriGlyph;
import org.kie.workbench.common.stunner.core.client.util.SvgDataUriGenerator;

@Dependent
public class LienzoSvgDataUriGlyphRenderer
extends AbstractLienzoShapeGlyphRenderer<SvgDataUriGlyph, Picture> {
    private final SvgDataUriGenerator svgDataUriUtil;
    private final BiConsumer<String, Consumer<Picture>> pictureBuilder;

    protected LienzoSvgDataUriGlyphRenderer() {
        this(null, null);
    }

    @Inject
    public LienzoSvgDataUriGlyphRenderer(SvgDataUriGenerator svgDataUriUtil) {
        this(svgDataUriUtil, (uri, consumer) -> new Picture(uri, consumer::accept));
    }

    LienzoSvgDataUriGlyphRenderer(SvgDataUriGenerator svgDataUriUtil, BiConsumer<String, Consumer<Picture>> pictureBuilder) {
        this.svgDataUriUtil = svgDataUriUtil;
        this.pictureBuilder = pictureBuilder;
    }

    public Class<SvgDataUriGlyph> getGlyphType() {
        return SvgDataUriGlyph.class;
    }

    @Override
    protected void getShape(SvgDataUriGlyph glyph, double width, double height, Consumer<Picture> shapeConsumer) {
        String content = this.svgDataUriUtil.generate(glyph.getSvg(), glyph.getDefs(), glyph.getValidUseRefIds());
        String encoded = SvgDataUriGenerator.encodeBase64((String)content);
        this.pictureBuilder.accept(encoded, shapeConsumer::accept);
    }
}

