/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.widgets.palette.bs3.BS3PaletteWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.bs3.factory.BS3PaletteFactory;
import org.kie.workbench.common.stunner.client.widgets.session.presenter.impl.AbstractClientSessionPresenter;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RedoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RefreshSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SessionCommandFactory;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SwitchGridSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.UndoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.VisitGraphSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.client.util.ClientSessionUtils;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidationViolation;
import org.kie.workbench.common.stunner.core.client.validation.canvas.CanvasValidatorCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractProjectDiagramEditor<R extends ClientResourceType>
extends KieEditor {
    private static Logger LOGGER = Logger.getLogger(AbstractProjectDiagramEditor.class.getName());
    private final PlaceManager placeManager;
    private final ErrorPopupPresenter errorPopupPresenter;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private final R resourceType;
    private final ClientProjectDiagramService projectDiagramServices;
    private final AbstractClientSessionManager clientSessionManager;
    private final AbstractClientSessionPresenter clientSessionPresenter;
    private final BS3PaletteFactory paletteFactory;
    private final ClientSessionUtils sessionUtils;
    private final ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder;
    private final ClearSelectionSessionCommand sessionClearSelectionCommand;
    private final VisitGraphSessionCommand sessionVisitGraphCommand;
    private final SwitchGridSessionCommand sessionSwitchGridCommand;
    private final ClearSessionCommand sessionClearCommand;
    private final DeleteSelectionSessionCommand sessionDeleteSelectionCommand;
    private final UndoSessionCommand sessionUndoCommand;
    private final RedoSessionCommand sessionRedoCommand;
    private final ValidateSessionCommand sessionValidateCommand;
    private final RefreshSessionCommand sessionRefreshCommand;
    private AbstractClientFullSession session;
    private BS3PaletteWidget paletteWidget;
    private String title = "Project Diagram Editor";

    @Inject
    public AbstractProjectDiagramEditor(View view, PlaceManager placeManager, ErrorPopupPresenter errorPopupPresenter, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SavePopUpPresenter savePopUpPresenter, R resourceType, ClientProjectDiagramService projectDiagramServices, AbstractClientSessionManager clientSessionManager, AbstractClientSessionPresenter clientSessionPresenter, BS3PaletteFactory paletteFactory, ClientSessionUtils sessionUtils, SessionCommandFactory sessionCommandFactory, ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder) {
        super((KieEditorView)view);
        this.placeManager = placeManager;
        this.errorPopupPresenter = errorPopupPresenter;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
        this.savePopUpPresenter = savePopUpPresenter;
        this.resourceType = resourceType;
        this.projectDiagramServices = projectDiagramServices;
        this.clientSessionManager = clientSessionManager;
        this.clientSessionPresenter = clientSessionPresenter;
        this.paletteFactory = paletteFactory;
        this.sessionUtils = sessionUtils;
        this.menuItemsBuilder = menuItemsBuilder;
        this.sessionClearSelectionCommand = sessionCommandFactory.newClearSelectionCommand();
        this.sessionVisitGraphCommand = sessionCommandFactory.newVisitGraphCommand();
        this.sessionSwitchGridCommand = sessionCommandFactory.newSwitchGridCommand();
        this.sessionClearCommand = sessionCommandFactory.newClearCommand();
        this.sessionDeleteSelectionCommand = sessionCommandFactory.newDeleteSelectedElementsCommand();
        this.sessionUndoCommand = sessionCommandFactory.newUndoCommand();
        this.sessionRedoCommand = sessionCommandFactory.newRedoCommand();
        this.sessionValidateCommand = sessionCommandFactory.newValidateCommand();
        this.sessionRefreshCommand = sessionCommandFactory.newRefreshSessionCommand();
    }

    protected abstract int getCanvasWidth();

    protected abstract int getCanvasHeight();

    @PostConstruct
    public void init() {
        this.getView().init((Object)this);
        this.session = (AbstractClientFullSession)this.clientSessionManager.newFullSession();
        this.clientSessionPresenter.initialize((AbstractClientSession)this.session, this.getCanvasWidth(), this.getCanvasHeight());
        this.getView().setWidget((IsWidget)this.clientSessionPresenter.getView());
        this.bindCommands();
    }

    protected void doStartUp(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.resourceType);
    }

    protected void loadContent() {
        this.projectDiagramServices.getByPath((Path)this.versionRecordManager.getCurrentPath(), (ServiceCallback)new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.open(item);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.showError(error);
            }
        });
    }

    protected void open(ProjectDiagram diagram) {
        this.showLoadingViews();
        Command callback = () -> this.hideLoadingViews();
        this.paletteWidget = this.buildPalette(diagram);
        this.clientSessionPresenter.getView().setPalette((IsWidget)this.paletteWidget.getView());
        this.clientSessionPresenter.open((Diagram)diagram, callback);
        this.updateTitle(((ProjectMetadata)diagram.getMetadata()).getTitle());
    }

    protected Command onValidate() {
        this.showLoadingViews();
        return () -> {
            this.session.getCanvasValidationControl().validate();
            this.hideLoadingViews();
        };
    }

    protected void save(final String commitMessage) {
        this.showLoadingViews();
        this.session.getCanvasValidationControl().validate(new CanvasValidatorCallback(){

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.doSave(commitMessage);
            }

            public void onFail(Iterable<CanvasValidationViolation> violations) {
                AbstractProjectDiagramEditor.this.log(Level.WARNING, "Validation failed [violations=" + violations.toString() + "].");
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }
        });
    }

    protected void doSave(String commitMessage) {
        String thumbData = this.sessionUtils.canvasToImageData((ClientSession)this.session);
        AbstractCanvasHandler canvasHandler = this.session.getCanvasHandler();
        Diagram diagram = canvasHandler.getDiagram();
        diagram.getMetadata().setThumbData(thumbData);
        this.projectDiagramServices.saveOrUpdate((Path)this.versionRecordManager.getCurrentPath(), this.getDiagram(), this.metadata, commitMessage, new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.getSaveSuccessCallback(item.hashCode());
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.showError(error);
            }
        });
    }

    protected void makeMenuBar() {
        MenuItem clearItem = this.menuItemsBuilder.newClearItem(this::menu_clear);
        this.sessionClearCommand.listen(() -> clearItem.setEnabled(this.sessionClearCommand.isEnabled()));
        MenuItem clearSelectionItem = this.menuItemsBuilder.newClearSelectionItem(this::menu_clearSelection);
        this.sessionClearSelectionCommand.listen(() -> clearSelectionItem.setEnabled(this.sessionClearSelectionCommand.isEnabled()));
        MenuItem visitGraphItem = this.menuItemsBuilder.newVisitGraphItem(this::menu_visitGraph);
        this.sessionVisitGraphCommand.listen(() -> visitGraphItem.setEnabled(this.sessionVisitGraphCommand.isEnabled()));
        MenuItem switchGridItem = this.menuItemsBuilder.newSwitchGridItem(this::menu_switchGrid);
        this.sessionSwitchGridCommand.listen(() -> switchGridItem.setEnabled(this.sessionSwitchGridCommand.isEnabled()));
        MenuItem deleteSelectionItem = this.menuItemsBuilder.newDeleteSelectionItem(this::menu_deleteSelected);
        this.sessionDeleteSelectionCommand.listen(() -> deleteSelectionItem.setEnabled(this.sessionDeleteSelectionCommand.isEnabled()));
        MenuItem undoItem = this.menuItemsBuilder.newUndoItem(this::menu_undo);
        this.sessionUndoCommand.listen(() -> undoItem.setEnabled(this.sessionUndoCommand.isEnabled()));
        MenuItem redoItem = this.menuItemsBuilder.newRedoItem(this::menu_redo);
        this.sessionRedoCommand.listen(() -> redoItem.setEnabled(this.sessionRedoCommand.isEnabled()));
        MenuItem validateItem = this.menuItemsBuilder.newValidateItem(this::menu_validate);
        this.sessionValidateCommand.listen(() -> validateItem.setEnabled(this.sessionValidateCommand.isEnabled()));
        MenuItem refreshItem = this.menuItemsBuilder.newRefreshItem(this::menu_refresh);
        this.sessionRefreshCommand.listen(() -> refreshItem.setEnabled(this.sessionRefreshCommand.isEnabled()));
        this.menuBuilder.addNewTopLevelMenu(clearItem).addNewTopLevelMenu(clearSelectionItem).addNewTopLevelMenu(visitGraphItem).addNewTopLevelMenu(switchGridItem).addNewTopLevelMenu(deleteSelectionItem).addNewTopLevelMenu(undoItem).addNewTopLevelMenu(redoItem).addNewTopLevelMenu(validateItem).addNewTopLevelMenu(refreshItem);
        if (this.menuItemsBuilder.isDevItemsEnabled()) {
            this.menuBuilder.addNewTopLevelMenu(this.menuItemsBuilder.newDevItems());
        }
        this.menus = this.menuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(() -> this.onSave())).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.fileNameValidator).addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.fileNameValidator).addDelete((Path)this.versionRecordManager.getPathToLatest()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).build();
    }

    private void menu_clear() {
        this.sessionClearCommand.execute();
    }

    private void menu_clearSelection() {
        this.sessionClearSelectionCommand.execute();
    }

    private void menu_visitGraph() {
        this.sessionVisitGraphCommand.execute();
    }

    private void menu_switchGrid() {
        this.sessionSwitchGridCommand.execute();
    }

    private void menu_deleteSelected() {
        this.sessionDeleteSelectionCommand.execute();
    }

    private void menu_undo() {
        this.sessionUndoCommand.execute();
    }

    private void menu_redo() {
        this.sessionRedoCommand.execute();
    }

    private void menu_validate() {
        this.sessionValidateCommand.execute();
    }

    private void menu_refresh() {
        this.showLoadingViews();
        this.sessionRefreshCommand.execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Diagram>(){

            public void onSuccess(Diagram result) {
                AbstractProjectDiagramEditor.this.log(Level.FINE, "Diagram refresh successful.");
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.showError(error);
            }
        });
    }

    protected void doOpen() {
        if (null != this.session && this.session.isOpened()) {
            this.clientSessionManager.resume((AbstractClientSession)this.session);
        }
    }

    protected void showLoadingViews() {
        this.getView().showLoading();
        this.clientSessionPresenter.getView().setLoading(true);
    }

    protected void hideLoadingViews() {
        this.getView().hideBusyIndicator();
        this.clientSessionPresenter.getView().setLoading(false);
    }

    protected void doClose() {
        this.disposeSession();
    }

    protected void doFocus() {
    }

    protected void doLostFocus() {
        this.hidePaletteFloatingView();
    }

    void onSessionErrorEvent(@Observes OnSessionErrorEvent errorEvent) {
        if (null != this.session && this.session.equals((Object)errorEvent.getSession())) {
            this.executeWithConfirm("An error happened [" + errorEvent.getError() + "]. Do you wantto refresh the diagram (Last changes can be lost)? ", this::menu_refresh);
        }
    }

    public String getTitleText() {
        return this.title;
    }

    protected Menus getMenus() {
        if (this.menus == null) {
            this.makeMenuBar();
        }
        return this.menus;
    }

    protected boolean _onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentDiagramHash()));
    }

    private void bindCommands() {
        this.sessionClearSelectionCommand.bind((ClientSession)this.session);
        this.sessionVisitGraphCommand.bind((ClientSession)this.session);
        this.sessionSwitchGridCommand.bind((AbstractClientReadOnlySession)this.session);
        this.sessionClearCommand.bind(this.session);
        this.sessionDeleteSelectionCommand.bind((ClientSession)this.session);
        this.sessionUndoCommand.bind((ClientSession)this.session);
        this.sessionRedoCommand.bind((ClientSession)this.session);
        this.sessionValidateCommand.bind((ClientSession)this.session);
        this.sessionRefreshCommand.bind((ClientSession)this.session);
    }

    private void unbindCommands() {
        this.sessionClearSelectionCommand.unbind();
        this.sessionVisitGraphCommand.unbind();
        this.sessionSwitchGridCommand.unbind();
        this.sessionClearCommand.unbind();
        this.sessionDeleteSelectionCommand.unbind();
        this.sessionUndoCommand.unbind();
        this.sessionRedoCommand.unbind();
        this.sessionValidateCommand.unbind();
        this.sessionRefreshCommand.unbind();
    }

    private void resume() {
        this.clientSessionManager.resume((AbstractClientSession)this.session);
    }

    private void pauseSession() {
        this.clientSessionManager.pause();
    }

    private void disposeSession() {
        this.clientSessionManager.dispose();
        this.unbindCommands();
        if (null != this.paletteWidget) {
            this.destroyPalette();
        }
        this.paletteWidget = null;
        this.session = null;
    }

    private BS3PaletteWidget buildPalette(ProjectDiagram diagram) {
        return (BS3PaletteWidget)this.paletteFactory.forCanvasHandler((CanvasHandler)this.session.getCanvasHandler()).newPalette(((ProjectMetadata)diagram.getMetadata()).getShapeSetId());
    }

    private void destroyPalette() {
        if (null != this.paletteWidget) {
            this.paletteWidget.unbind();
            this.paletteWidget.destroy();
        }
    }

    private void updateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, this.title));
    }

    private void hidePaletteFloatingView() {
        if (null != this.paletteWidget) {
            this.paletteWidget.getFloatingView().hide();
        }
    }

    private void showError(ClientRuntimeError error) {
        this.errorPopupPresenter.showMessage(error.toString());
        this.hideLoadingViews();
    }

    protected int getCurrentDiagramHash() {
        if (this.getDiagram() == null) {
            return 0;
        }
        return this.getDiagram().getName().hashCode();
    }

    protected ProjectDiagram getDiagram() {
        return null != this.clientSessionPresenter.getCanvasHandler() ? (ProjectDiagram)this.clientSessionPresenter.getCanvasHandler().getDiagram() : null;
    }

    private Graph getGraph() {
        return null != this.getDiagram() ? this.getDiagram().getGraph() : null;
    }

    private void executeWithConfirm(String message, Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)message, null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    protected View getView() {
        return (View)this.baseView;
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    public static interface View
    extends UberView<AbstractProjectDiagramEditor>,
    KieEditorView,
    IsWidget {
        public void setWidget(IsWidget var1);
    }
}

