/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconRotate;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.kie.workbench.common.stunner.client.widgets.menu.dev.MenuDevCommandsBuilder;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class ProjectDiagramEditorMenuItemsBuilder {
    private final MenuDevCommandsBuilder menuDevCommandsBuilder;

    protected ProjectDiagramEditorMenuItemsBuilder() {
        this(null);
    }

    @Inject
    public ProjectDiagramEditorMenuItemsBuilder(MenuDevCommandsBuilder menuDevCommandsBuilder) {
        this.menuDevCommandsBuilder = menuDevCommandsBuilder;
    }

    public MenuItem newClearSelectionItem(Command command) {
        return this.buildItem(this.buildClearSelectionItem(command));
    }

    private IsWidget buildClearSelectionItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.BAN);
                this.setTitle("Clear selection");
                this.addClickHandler(clickEvent -> command.execute());
            }
        };
    }

    public MenuItem newVisitGraphItem(Command command) {
        return this.buildItem(this.buildVisitGraphItem(command));
    }

    private IsWidget buildVisitGraphItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.AUTOMOBILE);
                this.setTitle("Visit graph");
                this.addClickHandler(clickEvent -> command.execute());
            }
        };
    }

    public MenuItem newSwitchGridItem(Command command) {
        return this.buildItem(this.buildSwitchGridItem(command));
    }

    private IsWidget buildSwitchGridItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.TH);
                this.setTitle("Switch grid");
                this.addClickHandler(clickEvent -> command.execute());
            }
        };
    }

    public MenuItem newClearItem(Command command) {
        return this.buildItem(this.buildClearItem(command));
    }

    private IsWidget buildClearItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.ERASER);
                this.setTitle("Clear");
                this.addClickHandler(clickEvent -> ProjectDiagramEditorMenuItemsBuilder.this.executeWithConfirm(command));
            }
        };
    }

    public MenuItem newDeleteSelectionItem(Command command) {
        return this.buildItem(this.buildDeleteSelectionItem(command));
    }

    private IsWidget buildDeleteSelectionItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.TRASH_O);
                this.setTitle("Delete selected");
                this.addClickHandler(clickEvent -> ProjectDiagramEditorMenuItemsBuilder.this.executeWithConfirm(command));
            }
        };
    }

    public MenuItem newUndoItem(Command command) {
        return this.buildItem(this.buildUndoItem(command));
    }

    private IsWidget buildUndoItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.UNDO);
                this.setTitle("Undo");
                this.addClickHandler(clickEvent -> command.execute());
            }
        };
    }

    public MenuItem newRedoItem(Command command) {
        return this.buildItem(this.buildRedoItem(command));
    }

    private IsWidget buildRedoItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.UNDO);
                this.setIconRotate(IconRotate.ROTATE_180);
                this.setTitle("Redo");
                this.addClickHandler(clickEvent -> command.execute());
            }
        };
    }

    public MenuItem newRefreshItem(Command command) {
        return this.buildItem(this.buildRefreshItem(command));
    }

    private IsWidget buildRefreshItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.REFRESH);
                this.setTitle("Refresh");
                this.addClickHandler(clickEvent -> ProjectDiagramEditorMenuItemsBuilder.this.executeWithConfirm(command));
            }
        };
    }

    public MenuItem newValidateItem(Command command) {
        return this.buildItem(this.buildValidateItem(command));
    }

    private IsWidget buildValidateItem(final Command command) {
        return new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.CHECK);
                this.setTitle("Validate");
                this.addClickHandler(clickEvent -> command.execute());
            }
        };
    }

    public boolean isDevItemsEnabled() {
        return this.menuDevCommandsBuilder.isEnabled();
    }

    public MenuItem newDevItems() {
        return this.menuDevCommandsBuilder.build();
    }

    private IsWidget buildDevItems(final Command switchLogLevelCommand, final Command logGraphCommand, final Command logCommandHistoryCommand, final Command logSessionCommand) {
        final AnchorListItem switchLogLevelItem = new AnchorListItem("Switch log level"){
            {
                super(x0);
                this.setIcon(IconType.REFRESH);
                this.addClickHandler(event -> switchLogLevelCommand.execute());
            }
        };
        final AnchorListItem logSessionItem = new AnchorListItem("Log session"){
            {
                super(x0);
                this.setIcon(IconType.PRINT);
                this.addClickHandler(event -> logSessionCommand.execute());
            }
        };
        final AnchorListItem logGraphItem = new AnchorListItem("Log Graph"){
            {
                super(x0);
                this.setIcon(IconType.PRINT);
                this.addClickHandler(event -> logGraphCommand.execute());
            }
        };
        final AnchorListItem logCommandHistoryItem = new AnchorListItem("Log Command History"){
            {
                super(x0);
                this.setIcon(IconType.PRINT);
                this.addClickHandler(event -> logCommandHistoryCommand.execute());
            }
        };
        return new ButtonGroup(){
            {
                this.add((Widget)new Button(){
                    {
                        this.setToggleCaret(false);
                        this.setDataToggle(Toggle.DROPDOWN);
                        this.setIcon(IconType.COG);
                        this.setSize(ButtonSize.SMALL);
                        this.setTitle("Development");
                    }
                });
                this.add((Widget)new DropDownMenu(){
                    {
                        this.addStyleName("pull-right");
                        this.add((Widget)switchLogLevelItem);
                        this.add((Widget)logSessionItem);
                        this.add((Widget)logGraphItem);
                        this.add((Widget)logCommandHistoryItem);
                    }
                });
            }
        };
    }

    private void executeWithConfirm(Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)this.getConfirmMessage(), null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    private String getConfirmMessage() {
        return "Are you sure?";
    }

    private MenuItem buildItem(final IsWidget widget) {
        return new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom(){

                    public IsWidget build() {
                        return widget;
                    }
                };
            }
        }.build();
    }
}

