/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.widgets.explorer.tree.TreeExplorer;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSessionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProjectDiagramExplorerScreen")
public class ProjectDiagramExplorerScreen {
    public static final String SCREEN_ID = "ProjectDiagramExplorerScreen";
    public static final String TITLE = "Explorer";
    private final AbstractClientSessionManager clientSessionManager;
    private final TreeExplorer treeExplorer;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private PlaceRequest placeRequest;
    private String title = "Explorer";

    protected ProjectDiagramExplorerScreen() {
        this(null, null, null);
    }

    @Inject
    public ProjectDiagramExplorerScreen(AbstractClientSessionManager clientSessionManager, TreeExplorer treeExplorer, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent) {
        this.clientSessionManager = clientSessionManager;
        this.treeExplorer = treeExplorer;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
    }

    @OnOpen
    public void onOpen() {
        AbstractClientSession current = this.clientSessionManager.getCurrentSession();
        if (null != current) {
            this.show((ClientSession)current);
        }
    }

    @OnClose
    public void onClose() {
        this.close();
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return null;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.treeExplorer.asWidget();
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "stunnerProjectDiagramExplorerScreenContext";
    }

    public void show(ClientSession session) {
        this.treeExplorer.show(session.getCanvasHandler());
        this.updateTitle(session);
    }

    public void close() {
        this.treeExplorer.clear();
    }

    private void updateTitle(ClientSession session) {
        String title = TITLE;
        if (null != session.getCanvasHandler() && null != session.getCanvasHandler().getDiagram()) {
            Diagram diagram = session.getCanvasHandler().getDiagram();
            title = diagram.getMetadata().getTitle();
        }
        this.doUpdateTitle(title);
    }

    private void doUpdateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, this.title));
    }
}

