/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class ProjectDiagramWorkbenchDocks {
    private static Logger LOGGER = Logger.getLogger(ProjectDiagramWorkbenchDocks.class.getName());
    private static final UberfireDockPosition POSITION = UberfireDockPosition.EAST;
    private final UberfireDocks uberfireDocks;
    String perspectiveId;
    boolean enabled;

    protected ProjectDiagramWorkbenchDocks() {
        this(null);
    }

    @Inject
    public ProjectDiagramWorkbenchDocks(UberfireDocks uberfireDocks) {
        this.uberfireDocks = uberfireDocks;
        this.enabled = false;
    }

    public void setup(String perspectiveId) {
        this.perspectiveId = perspectiveId;
        this.setupDocks();
        this.disableDocks();
    }

    public void enableDocks() {
        if (!this.isEnabled()) {
            this.log(Level.INFO, "Enabling docks");
            this.uberfireDocks.enable(POSITION, this.perspectiveId);
            this.enabled = true;
        }
    }

    public void disableDocks() {
        if (this.isEnabled()) {
            this.log(Level.INFO, "Disabling docks");
            this.uberfireDocks.disable(POSITION, this.perspectiveId);
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void onDockReadyEvent(@Observes UberfireDockReadyEvent dockReadyEvent) {
        String currentPerspectiveId = dockReadyEvent.getCurrentPerspective();
        this.log(Level.INFO, "Stunner WB Docks ready for perspective [" + currentPerspectiveId + "].");
        if (null != currentPerspectiveId && currentPerspectiveId.equals(this.perspectiveId)) {
            this.enableDocks();
        } else {
            this.disableDocks();
        }
    }

    private void setupDocks() {
        UberfireDock propertiesDock = this.createPropertiesDock(this.perspectiveId);
        UberfireDock explorerDock = this.createExplorerDock(this.perspectiveId);
        this.uberfireDocks.add(new UberfireDock[]{propertiesDock});
        this.uberfireDocks.add(new UberfireDock[]{explorerDock});
    }

    private UberfireDock createPropertiesDock(String perspectiveId) {
        return new UberfireDock(POSITION, "PENCIL_SQUARE_O", (PlaceRequest)new DefaultPlaceRequest("ProjectDiagramPropertiesScreen"), perspectiveId).withSize(450.0).withLabel("Properties");
    }

    private UberfireDock createExplorerDock(String perspectiveId) {
        return new UberfireDock(POSITION, "LIST_UL", (PlaceRequest)new DefaultPlaceRequest("ProjectDiagramExplorerScreen"), perspectiveId).withSize(450.0).withLabel("Explorer");
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

