/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenterFactory;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearStatesSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.DeleteSelectionSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RedoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.RefreshSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SessionCommandFactory;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SwitchGridSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.UndoSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ValidateSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.VisitGraphSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientReadOnlySession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.client.util.ClientSessionUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.core.validation.impl.ValidationUtils;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractProjectDiagramEditor<R extends ClientResourceType>
extends KieEditor {
    private static Logger LOGGER = Logger.getLogger(AbstractProjectDiagramEditor.class.getName());
    private final PlaceManager placeManager;
    private final ErrorPopupPresenter errorPopupPresenter;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private final R resourceType;
    private final ClientProjectDiagramService projectDiagramServices;
    private final SessionManager sessionManager;
    private final SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory;
    private final ClientSessionUtils sessionUtils;
    private final ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder;
    private final ClearStatesSessionCommand sessionClearStatesCommand;
    private final VisitGraphSessionCommand sessionVisitGraphCommand;
    private final SwitchGridSessionCommand sessionSwitchGridCommand;
    private final ClearSessionCommand sessionClearCommand;
    private final DeleteSelectionSessionCommand sessionDeleteSelectionCommand;
    private final UndoSessionCommand sessionUndoCommand;
    private final RedoSessionCommand sessionRedoCommand;
    private final ValidateSessionCommand sessionValidateCommand;
    private final RefreshSessionCommand sessionRefreshCommand;
    protected SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter;
    private String title = "Project Diagram Editor";

    @Inject
    public AbstractProjectDiagramEditor(View view, PlaceManager placeManager, ErrorPopupPresenter errorPopupPresenter, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SavePopUpPresenter savePopUpPresenter, R resourceType, ClientProjectDiagramService projectDiagramServices, SessionManager sessionManager, SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory, ClientSessionUtils sessionUtils, SessionCommandFactory sessionCommandFactory, ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder) {
        super((KieEditorView)view);
        this.placeManager = placeManager;
        this.errorPopupPresenter = errorPopupPresenter;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
        this.savePopUpPresenter = savePopUpPresenter;
        this.resourceType = resourceType;
        this.projectDiagramServices = projectDiagramServices;
        this.sessionManager = sessionManager;
        this.sessionPresenterFactory = sessionPresenterFactory;
        this.sessionUtils = sessionUtils;
        this.menuItemsBuilder = menuItemsBuilder;
        this.sessionClearStatesCommand = sessionCommandFactory.newClearStatesCommand();
        this.sessionVisitGraphCommand = sessionCommandFactory.newVisitGraphCommand();
        this.sessionSwitchGridCommand = sessionCommandFactory.newSwitchGridCommand();
        this.sessionClearCommand = sessionCommandFactory.newClearCommand();
        this.sessionDeleteSelectionCommand = sessionCommandFactory.newDeleteSelectedElementsCommand();
        this.sessionUndoCommand = sessionCommandFactory.newUndoCommand();
        this.sessionRedoCommand = sessionCommandFactory.newRedoCommand();
        this.sessionValidateCommand = sessionCommandFactory.newValidateCommand();
        this.sessionRefreshCommand = sessionCommandFactory.newRefreshSessionCommand();
    }

    protected abstract int getCanvasWidth();

    protected abstract int getCanvasHeight();

    @PostConstruct
    public void init() {
        this.getView().init((Object)this);
    }

    protected void doStartUp(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.resourceType);
    }

    protected void loadContent() {
        this.projectDiagramServices.getByPath((Path)this.versionRecordManager.getCurrentPath(), (ServiceCallback)new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.open(item);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.showError(error);
            }
        });
    }

    protected void open(final ProjectDiagram diagram) {
        this.showLoadingViews();
        AbstractClientFullSession session = this.newSession((Diagram)diagram);
        this.presenter = this.sessionPresenterFactory.newPresenterEditor();
        this.getView().setWidget(this.presenter.getView());
        this.presenter.withToolbar(false).withPalette(true).displayNotifications(type -> true).open((Diagram)diagram, (ClientSession)session, (SessionPresenter.SessionPresenterCallback)new SessionPresenter.SessionPresenterCallback<AbstractClientFullSession, Diagram>(){

            public void afterSessionOpened() {
            }

            public void afterCanvasInitialized() {
            }

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.bindCommands();
                AbstractProjectDiagramEditor.this.updateTitle(((ProjectMetadata)diagram.getMetadata()).getTitle());
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.showError(error);
            }
        });
    }

    private AbstractClientFullSession newSession(Diagram diagram) {
        return (AbstractClientFullSession)this.sessionManager.getSessionFactory(diagram, ClientFullSession.class).newSession();
    }

    protected Command onValidate() {
        return () -> this.validate(() -> {
            this.onValidationSuccess();
            this.hideLoadingViews();
        });
    }

    protected void save() {
        final Command continueSaveOnceValid = () -> super.save();
        this.sessionValidateCommand.execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                continueSaveOnceValid.execute();
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                Violation.Type maxSeverity = ValidationUtils.getMaxSeverity(violations);
                if (maxSeverity.equals((Object)Violation.Type.ERROR)) {
                    AbstractProjectDiagramEditor.this.onValidationFailed(violations);
                } else {
                    continueSaveOnceValid.execute();
                }
            }
        });
    }

    protected void save(String commitMessage) {
        super.save(commitMessage);
        this.showLoadingViews();
        String thumbData = this.sessionUtils.canvasToImageData((ClientSession)this.getSession());
        AbstractCanvasHandler canvasHandler = this.getSession().getCanvasHandler();
        Diagram diagram = canvasHandler.getDiagram();
        diagram.getMetadata().setThumbData(thumbData);
        this.projectDiagramServices.saveOrUpdate((Path)this.versionRecordManager.getCurrentPath(), this.getDiagram(), this.metadata, commitMessage, new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.getSaveSuccessCallback(item.hashCode());
                AbstractProjectDiagramEditor.this.onSaveSuccess();
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onSaveError(error);
            }
        });
    }

    protected void makeMenuBar() {
        MenuItem clearItem = this.menuItemsBuilder.newClearItem(this::menu_clear);
        this.sessionClearCommand.listen(() -> clearItem.setEnabled(this.sessionClearCommand.isEnabled()));
        MenuItem clearStatesItem = this.menuItemsBuilder.newClearSelectionItem(this::menu_clearStates);
        this.sessionClearStatesCommand.listen(() -> clearStatesItem.setEnabled(this.sessionClearStatesCommand.isEnabled()));
        MenuItem visitGraphItem = this.menuItemsBuilder.newVisitGraphItem(this::menu_visitGraph);
        this.sessionVisitGraphCommand.listen(() -> visitGraphItem.setEnabled(this.sessionVisitGraphCommand.isEnabled()));
        MenuItem switchGridItem = this.menuItemsBuilder.newSwitchGridItem(this::menu_switchGrid);
        this.sessionSwitchGridCommand.listen(() -> switchGridItem.setEnabled(this.sessionSwitchGridCommand.isEnabled()));
        MenuItem deleteSelectionItem = this.menuItemsBuilder.newDeleteSelectionItem(this::menu_deleteSelected);
        this.sessionDeleteSelectionCommand.listen(() -> deleteSelectionItem.setEnabled(this.sessionDeleteSelectionCommand.isEnabled()));
        MenuItem undoItem = this.menuItemsBuilder.newUndoItem(this::menu_undo);
        this.sessionUndoCommand.listen(() -> undoItem.setEnabled(this.sessionUndoCommand.isEnabled()));
        MenuItem redoItem = this.menuItemsBuilder.newRedoItem(this::menu_redo);
        this.sessionRedoCommand.listen(() -> redoItem.setEnabled(this.sessionRedoCommand.isEnabled()));
        MenuItem validateItem = this.menuItemsBuilder.newValidateItem(this::menu_validate);
        this.sessionValidateCommand.listen(() -> validateItem.setEnabled(this.sessionValidateCommand.isEnabled()));
        MenuItem refreshItem = this.menuItemsBuilder.newRefreshItem(this::menu_refresh);
        this.sessionRefreshCommand.listen(() -> refreshItem.setEnabled(this.sessionRefreshCommand.isEnabled()));
        this.menuBuilder.addNewTopLevelMenu(clearItem).addNewTopLevelMenu(clearStatesItem).addNewTopLevelMenu(visitGraphItem).addNewTopLevelMenu(switchGridItem).addNewTopLevelMenu(deleteSelectionItem).addNewTopLevelMenu(undoItem).addNewTopLevelMenu(redoItem).addNewTopLevelMenu(validateItem).addNewTopLevelMenu(refreshItem);
        if (this.menuItemsBuilder.isDevItemsEnabled()) {
            this.menuBuilder.addNewTopLevelMenu(this.menuItemsBuilder.newDevItems());
        }
        this.menus = this.menuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(() -> this.onSave())).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.fileNameValidator).addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.fileNameValidator).addDelete((Path)this.versionRecordManager.getPathToLatest()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).build();
    }

    private void validate(final Command callback) {
        this.showLoadingViews();
        this.sessionValidateCommand.execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                callback.execute();
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                AbstractProjectDiagramEditor.this.onValidationFailed(violations);
            }
        });
    }

    private void menu_clear() {
        this.sessionClearCommand.execute();
    }

    private void menu_clearStates() {
        this.sessionClearStatesCommand.execute();
    }

    private void menu_visitGraph() {
        this.sessionVisitGraphCommand.execute();
    }

    private void menu_switchGrid() {
        this.sessionSwitchGridCommand.execute();
    }

    private void menu_deleteSelected() {
        this.sessionDeleteSelectionCommand.execute();
    }

    private void menu_undo() {
        this.sessionUndoCommand.execute();
    }

    private void menu_redo() {
        this.sessionRedoCommand.execute();
    }

    private void menu_refresh() {
        this.showLoadingViews();
        this.sessionRefreshCommand.execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<ClientRuntimeError>(){

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.log(Level.FINE, "Diagram refresh successful.");
                AbstractProjectDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.showError(error);
            }
        });
    }

    private void menu_validate() {
        this.validate(() -> this.hideLoadingViews());
    }

    protected void doOpen() {
        if (null != this.getSession()) {
            this.sessionManager.resume((ClientSession)this.getSession());
        }
    }

    protected void showLoadingViews() {
        this.getView().showLoading();
    }

    protected void hideLoadingViews() {
        this.getView().hideBusyIndicator();
    }

    protected void doClose() {
        this.destroySession();
    }

    protected void doFocus() {
        this.log(Level.FINE, "Focusing Stunner Project Diagram Editor...");
        if (null != this.getSession() && !this.isSameSession(this.sessionManager.getCurrentSession())) {
            this.sessionManager.open((ClientSession)this.getSession());
        } else if (null != this.getSession()) {
            this.log(Level.FINE, "Session already active, no action.");
        }
    }

    protected void doLostFocus() {
    }

    void onSessionErrorEvent(@Observes OnSessionErrorEvent errorEvent) {
        if (this.isSameSession(errorEvent.getSession())) {
            this.executeWithConfirm("An error happened [" + errorEvent.getError() + "]. Do you wantto refresh the diagram (Last changes can be lost)? ", this::menu_refresh);
        }
    }

    private boolean isSameSession(ClientSession other) {
        return null != other && null != this.getSession() && other.equals(this.getSession());
    }

    public String getTitleText() {
        return this.title;
    }

    protected Menus getMenus() {
        if (this.menus == null) {
            this.makeMenuBar();
        }
        return this.menus;
    }

    protected boolean _onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentDiagramHash()));
    }

    void bindCommands() {
        this.sessionClearStatesCommand.bind((ClientSession)this.getSession());
        this.sessionVisitGraphCommand.bind((ClientSession)this.getSession());
        this.sessionSwitchGridCommand.bind((AbstractClientSession)this.getSession());
        this.sessionClearCommand.bind((ClientFullSession)this.getSession());
        this.sessionDeleteSelectionCommand.bind((ClientSession)this.getSession());
        this.sessionUndoCommand.bind((ClientSession)this.getSession());
        this.sessionRedoCommand.bind((ClientSession)this.getSession());
        this.sessionValidateCommand.bind((ClientSession)this.getSession());
        this.sessionRefreshCommand.bind((ClientSession)this.getSession());
    }

    void unbindCommands() {
        this.sessionClearStatesCommand.unbind();
        this.sessionVisitGraphCommand.unbind();
        this.sessionSwitchGridCommand.unbind();
        this.sessionClearCommand.unbind();
        this.sessionDeleteSelectionCommand.unbind();
        this.sessionUndoCommand.unbind();
        this.sessionRedoCommand.unbind();
        this.sessionValidateCommand.unbind();
        this.sessionRefreshCommand.unbind();
    }

    private void pauseSession() {
        this.sessionManager.pause();
    }

    private void destroySession() {
        this.unbindCommands();
        this.presenter.clear();
        this.presenter.destroy();
    }

    private void updateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, this.title));
    }

    private AbstractClientFullSession getSession() {
        return null != this.presenter ? (AbstractClientFullSession)this.presenter.getInstance() : null;
    }

    protected int getCurrentDiagramHash() {
        if (this.getDiagram() == null) {
            return 0;
        }
        return this.getDiagram().hashCode();
    }

    protected CanvasHandler getCanvasHandler() {
        return null != this.sessionManager.getCurrentSession() ? this.sessionManager.getCurrentSession().getCanvasHandler() : null;
    }

    protected ProjectDiagram getDiagram() {
        return null != this.getCanvasHandler() ? (ProjectDiagram)this.getCanvasHandler().getDiagram() : null;
    }

    private void executeWithConfirm(String message, Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)message, null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    protected View getView() {
        return (View)this.baseView;
    }

    private void onSaveSuccess() {
        String message = "Diagram saved successfully.";
        this.log(Level.INFO, "Diagram saved successfully.");
        ((SessionPresenter.View)this.presenter.getView()).showMessage("Diagram saved successfully.");
    }

    private void onSaveError(ClientRuntimeError error) {
        this.showError(error.toString());
    }

    private void onValidationSuccess() {
        this.log(Level.INFO, "Validation SUCCESS.");
    }

    private void onValidationFailed(Collection<DiagramElementViolation<RuleViolation>> violations) {
        this.log(Level.WARNING, "Validation FAILED [violations=" + violations.toString() + "]");
        this.hideLoadingViews();
    }

    private void showError(ClientRuntimeError error) {
        this.showError(error.toString());
    }

    private void showError(String message) {
        this.log(Level.SEVERE, message);
        this.errorPopupPresenter.showMessage(message);
        this.hideLoadingViews();
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    public static interface View
    extends UberView<AbstractProjectDiagramEditor>,
    KieEditorView,
    IsWidget {
        public void setWidget(IsWidget var1);
    }
}

