/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDockReadyEvent;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class ProjectDiagramWorkbenchDocks {
    private static Logger LOGGER = Logger.getLogger(ProjectDiagramWorkbenchDocks.class.getName());
    private static final UberfireDockPosition POSITION = UberfireDockPosition.EAST;
    private final UberfireDocks uberfireDocks;
    String perspectiveId;
    boolean enabled;
    boolean attached;
    private UberfireDock propertiesDock;
    private UberfireDock explorerDock;

    protected ProjectDiagramWorkbenchDocks() {
        this(null);
    }

    @Inject
    public ProjectDiagramWorkbenchDocks(UberfireDocks uberfireDocks) {
        this.uberfireDocks = uberfireDocks;
        this.attached = false;
        this.enabled = false;
    }

    public void setup(String perspectiveId) {
        this.perspectiveId = perspectiveId;
    }

    public void enableDocks() {
        if (!this.isEnabled()) {
            this.log(Level.INFO, "Enabling docks");
            this.uberfireDocks.enable(POSITION, this.perspectiveId);
            this.enabled = true;
        }
    }

    public void disableDocks() {
        if (this.isEnabled()) {
            this.log(Level.INFO, "Disabling docks");
            this.uberfireDocks.disable(POSITION, this.perspectiveId);
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void attachDocks() {
        if (null == this.propertiesDock) {
            this.propertiesDock = this.createPropertiesDock(this.perspectiveId);
        }
        if (null == this.explorerDock) {
            this.explorerDock = this.createExplorerDock(this.perspectiveId);
        }
        if (!this.attached) {
            this.log(Level.INFO, "Attaching docks");
            this.uberfireDocks.add(new UberfireDock[]{this.propertiesDock});
            this.uberfireDocks.add(new UberfireDock[]{this.explorerDock});
            this.attached = true;
        }
    }

    private void detachDocks() {
        if (this.attached) {
            this.log(Level.INFO, "Detaching docks");
            if (null != this.propertiesDock) {
                this.uberfireDocks.remove(new UberfireDock[]{this.propertiesDock});
            }
            if (null != this.explorerDock) {
                this.uberfireDocks.remove(new UberfireDock[]{this.explorerDock});
            }
            this.attached = false;
        }
    }

    void onDockReadyEvent(@Observes UberfireDockReadyEvent dockReadyEvent) {
        String currentPerspectiveId = dockReadyEvent.getCurrentPerspective();
        if (null != currentPerspectiveId && currentPerspectiveId.equals(this.perspectiveId)) {
            this.attachDocks();
        } else {
            this.detachDocks();
        }
    }

    private UberfireDock createPropertiesDock(String perspectiveId) {
        return new UberfireDock(POSITION, "PENCIL_SQUARE_O", (PlaceRequest)new DefaultPlaceRequest("ProjectDiagramPropertiesScreen"), perspectiveId).withSize(450.0).withLabel("Properties");
    }

    private UberfireDock createExplorerDock(String perspectiveId) {
        return new UberfireDock(POSITION, "EYE", (PlaceRequest)new DefaultPlaceRequest("ProjectDiagramExplorerScreen"), perspectiveId).withSize(450.0).withLabel("Explore");
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

