/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.util.HashUtil;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.core.validation.impl.ValidationUtils;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorProxy;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.editor.ProjectDiagramResource;
import org.kie.workbench.common.stunner.project.editor.impl.ProjectDiagramResourceImpl;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.AbstractPlaceEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractProjectDiagramEditor<R extends ClientResourceType>
extends KieEditor<ProjectDiagramResource> {
    private static Logger LOGGER = Logger.getLogger(AbstractProjectDiagramEditor.class.getName());
    private static final String TITLE_FORMAT_TEMPLATE = "#title.#suffix - #type";
    private PlaceManager placeManager;
    private ErrorPopupPresenter errorPopupPresenter;
    private Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private R resourceType;
    protected ClientProjectDiagramService projectDiagramServices;
    private final ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances;
    private final ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances;
    private AbstractProjectEditorMenuSessionItems<?> menuSessionItems;
    private ProjectMessagesListener projectMessagesListener;
    private Event<OnDiagramFocusEvent> onDiagramFocusEvent;
    private Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent;
    private Optional<SessionEditorPresenter<EditorSession>> editorSessionPresenter = Optional.empty();
    private Optional<SessionViewerPresenter<ViewerSession>> viewerSessionPresenter = Optional.empty();
    private final DiagramClientErrorHandler diagramClientErrorHandler;
    private final ClientTranslationService translationService;
    private final Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller;
    private String title = "Project Diagram Editor";
    private final TextEditorView xmlEditorView;
    protected ProjectDiagramEditorProxy editorProxy = ProjectDiagramEditorProxy.NULL_EDITOR;
    private boolean menuBarInitialzed = false;

    @Inject
    public AbstractProjectDiagramEditor(View view, PlaceManager placeManager, ErrorPopupPresenter errorPopupPresenter, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SavePopUpPresenter savePopUpPresenter, R resourceType, ClientProjectDiagramService projectDiagramServices, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, AbstractProjectEditorMenuSessionItems<?> menuSessionItems, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, ProjectMessagesListener projectMessagesListener, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService, TextEditorView xmlEditorView, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller) {
        super((KieEditorView)view);
        this.placeManager = placeManager;
        this.errorPopupPresenter = errorPopupPresenter;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
        this.savePopUpPresenter = savePopUpPresenter;
        this.resourceType = resourceType;
        this.projectDiagramServices = projectDiagramServices;
        this.editorSessionPresenterInstances = editorSessionPresenterInstances;
        this.viewerSessionPresenterInstances = viewerSessionPresenterInstances;
        this.menuSessionItems = menuSessionItems;
        this.projectMessagesListener = projectMessagesListener;
        this.diagramClientErrorHandler = diagramClientErrorHandler;
        this.onDiagramFocusEvent = onDiagramFocusEvent;
        this.onDiagramLostFocusEvent = onDiagramLostFocusEvent;
        this.translationService = translationService;
        this.xmlEditorView = xmlEditorView;
        this.projectDiagramResourceServiceCaller = projectDiagramResourceServiceCaller;
    }

    protected abstract int getCanvasWidth();

    protected abstract int getCanvasHeight();

    @PostConstruct
    public void init() {
        this.title = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramEditorDefaultTitle");
        this.getView().init((Object)this);
        this.projectMessagesListener.enable();
        this.menuSessionItems.setLoadingStarts(this::showLoadingViews).setLoadingCompleted(this::hideLoadingViews).setErrorConsumer(this::showError);
    }

    protected void doStartUp(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.resourceType);
    }

    protected void loadContent() {
        this.destroySession();
        this.projectDiagramServices.getByPath((Path)this.versionRecordManager.getCurrentPath(), (ServiceCallback)new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.open(item);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onLoadError(error);
            }
        });
    }

    public void open(ProjectDiagram diagram) {
        this.editorProxy = this.makeStunnerEditorProxy();
        this.showLoadingViews();
        if (!this.isReadOnly()) {
            this.openSession(diagram);
        } else {
            this.openReadOnlySession(diagram);
        }
    }

    protected ProjectDiagramEditorProxy makeStunnerEditorProxy() {
        ProjectDiagramEditorProxy proxy = new ProjectDiagramEditorProxy();
        proxy.setContentSupplier(() -> new ProjectDiagramResourceImpl(this.getDiagram()));
        proxy.setSaveAfterValidationConsumer(continueSaveOnceValid -> this.menuSessionItems.getCommands().getValidateSessionCommand().execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                continueSaveOnceValid.execute();
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                Violation.Type maxSeverity = ValidationUtils.getMaxSeverity(violations);
                if (maxSeverity.equals((Object)Violation.Type.ERROR)) {
                    AbstractProjectDiagramEditor.this.onValidationFailed(violations);
                } else {
                    continueSaveOnceValid.execute();
                }
            }
        }));
        proxy.setSaveAfterUserConfirmationConsumer(commitMessage -> {
            final ObservablePath diagramPath = this.versionRecordManager.getCurrentPath();
            this.projectDiagramServices.saveOrUpdate((Path)diagramPath, this.getDiagram(), this.metadata, (String)commitMessage, new ServiceCallback<ProjectDiagram>(){

                public void onSuccess(ProjectDiagram item) {
                    AbstractProjectDiagramEditor.this.getSaveSuccessCallback(item.hashCode()).callback((Object)diagramPath);
                    AbstractProjectDiagramEditor.this.onSaveSuccess();
                    AbstractProjectDiagramEditor.this.hideLoadingViews();
                }

                public void onError(ClientRuntimeError error) {
                    AbstractProjectDiagramEditor.this.onSaveError(error);
                }
            });
        });
        proxy.setShowNoChangesSinceLastSaveMessageConsumer(message -> ((SessionPresenter.View)this.getSessionPresenter().getView()).showMessage(message));
        proxy.setHashCodeSupplier(() -> {
            if (null == this.getDiagram()) {
                return 0;
            }
            int hash = this.getDiagram().hashCode();
            if (null == this.getCanvasHandler() || null == this.getCanvasHandler().getCanvas() || null == this.getCanvasHandler().getCanvas().getShapes()) {
                return hash;
            }
            Collection collectionOfShapes = this.getCanvasHandler().getCanvas().getShapes();
            ArrayList shapes = new ArrayList();
            shapes.addAll(collectionOfShapes);
            shapes.sort((a, b) -> a.getShapeView().getShapeX() == b.getShapeView().getShapeX() ? (int)Math.round(a.getShapeView().getShapeY() - b.getShapeView().getShapeY()) : (int)Math.round(a.getShapeView().getShapeX() - b.getShapeView().getShapeX()));
            for (Shape shape : shapes) {
                hash = HashUtil.combineHashCodes((int[])new int[]{hash, Double.hashCode(shape.getShapeView().getShapeX()), Double.hashCode(shape.getShapeView().getShapeY())});
            }
            return hash;
        });
        return proxy;
    }

    protected ProjectDiagramEditorProxy makeXmlEditorProxy() {
        ProjectDiagramEditorProxy proxy = new ProjectDiagramEditorProxy();
        proxy.setContentSupplier(() -> new ProjectDiagramResourceImpl(this.xmlEditorView.getContent()));
        proxy.setSaveAfterValidationConsumer(Command::execute);
        proxy.setSaveAfterUserConfirmationConsumer(commitMessage -> {
            final ObservablePath diagramPath = this.versionRecordManager.getCurrentPath();
            this.projectDiagramServices.saveAsXml((Path)diagramPath, this.xmlEditorView.getContent(), this.metadata, (String)commitMessage, new ServiceCallback<String>(){

                public void onSuccess(String xml) {
                    AbstractProjectDiagramEditor.this.getSaveSuccessCallback(xml.hashCode()).callback((Object)diagramPath);
                    AbstractProjectDiagramEditor.this.notification.fire((Object)new NotificationEvent(org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants.INSTANCE.ItemSavedSuccessfully()));
                    AbstractProjectDiagramEditor.this.hideLoadingViews();
                }

                public void onError(ClientRuntimeError error) {
                    AbstractProjectDiagramEditor.this.onSaveError(error);
                }
            });
        });
        proxy.setShowNoChangesSinceLastSaveMessageConsumer(message -> this.notification.fire((Object)new NotificationEvent(message)));
        proxy.setHashCodeSupplier(() -> this.xmlEditorView.getContent().hashCode());
        return proxy;
    }

    protected boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void openSession(final ProjectDiagram diagram) {
        this.editorSessionPresenter = Optional.of(this.newSessionEditorPresenter());
        this.editorSessionPresenter.get().open((Diagram)diagram, (SessionPresenter.SessionPresenterCallback)new SessionPresenter.SessionPresenterCallback<Diagram>(){

            public void afterSessionOpened() {
            }

            public void afterCanvasInitialized() {
            }

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.initialiseKieEditorForSession(diagram);
                AbstractProjectDiagramEditor.this.menuSessionItems.bind(AbstractProjectDiagramEditor.this.getSession());
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onLoadError(error);
            }
        });
    }

    protected void openReadOnlySession(final ProjectDiagram diagram) {
        this.viewerSessionPresenter = Optional.of(this.newSessionViewerPresenter());
        this.viewerSessionPresenter.get().open((Diagram)diagram, (SessionPresenter.SessionPresenterCallback)new SessionPresenter.SessionPresenterCallback<Diagram>(){

            public void afterSessionOpened() {
            }

            public void afterCanvasInitialized() {
            }

            public void onSuccess() {
                AbstractProjectDiagramEditor.this.initialiseKieEditorForSession(diagram);
                AbstractProjectDiagramEditor.this.menuSessionItems.bind(AbstractProjectDiagramEditor.this.getSession());
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.onLoadError(error);
            }
        });
    }

    protected void initialiseKieEditorForSession(ProjectDiagram diagram) {
        this.resetEditorPages(((ProjectMetadata)diagram.getMetadata()).getOverview());
        this.updateTitle(((ProjectMetadata)diagram.getMetadata()).getTitle());
        this.setOriginalHash(this.getCurrentDiagramHash());
        this.hideLoadingViews();
        this.onDiagramLoad();
    }

    protected void onDiagramLoad() {
    }

    protected SessionEditorPresenter<EditorSession> newSessionEditorPresenter() {
        SessionEditorPresenter presenter = (SessionEditorPresenter)((SessionEditorPresenter)this.editorSessionPresenterInstances.get()).withToolbar(false).withPalette(true).displayNotifications(type -> true);
        this.getView().setWidget((IsWidget)presenter.getView());
        return presenter;
    }

    protected SessionViewerPresenter<ViewerSession> newSessionViewerPresenter() {
        SessionViewerPresenter presenter = (SessionViewerPresenter)((SessionViewerPresenter)this.viewerSessionPresenterInstances.get()).withToolbar(false).withPalette(false).displayNotifications(type -> true);
        this.getView().setWidget((IsWidget)presenter.getView());
        return presenter;
    }

    protected void onValidate(Command finished) {
        this.onValidationSuccess();
        this.hideLoadingViews();
        finished.execute();
    }

    protected void save() {
        Command continueSaveOnceValid = () -> super.save();
        this.doSave(continueSaveOnceValid);
    }

    protected void doSave(Command continueSaveOnceValid) {
        this.editorProxy.saveAfterValidation(continueSaveOnceValid);
    }

    protected void save(String commitMessage) {
        super.save(commitMessage);
        this.doSave(commitMessage);
    }

    protected void doSave(String commitMessage) {
        this.editorProxy.saveAfterUserConfirmation(commitMessage);
    }

    public RemoteCallback<Path> getSaveSuccessCallback(int newHash) {
        return path -> {
            this.versionRecordManager.reloadVersions(path);
            this.setOriginalHash(newHash);
        };
    }

    public void hideDiagramEditorDocks(@Observes PlaceHiddenEvent event) {
        if (this.verifyEventIdentifier((AbstractPlaceEvent)event)) {
            this.onDiagramLostFocusEvent.fire((Object)new OnDiagramLoseFocusEvent());
        }
    }

    public void showDiagramEditorDocks(@Observes PlaceGainFocusEvent event) {
        if (this.verifyEventIdentifier((AbstractPlaceEvent)event)) {
            this.onDiagramFocusEvent.fire((Object)new OnDiagramFocusEvent());
        }
    }

    protected void makeMenuBar() {
        if (!this.menuBarInitialzed) {
            this.menuSessionItems.populateMenu(this.fileMenuBuilder);
            this.makeAdditionalStunnerMenus(this.fileMenuBuilder);
            if (this.canUpdateProject()) {
                this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(() -> ((AbstractProjectDiagramEditor)this).saveAction())).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator).addRename(this.getSaveAndRename()).addDelete((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
            }
            this.addDownloadMenuItem(this.fileMenuBuilder);
            this.fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
            this.menuBarInitialzed = true;
        }
    }

    protected Command getSaveAndRename() {
        return super.getSaveAndRename();
    }

    protected Caller<? extends SupportsSaveAndRename<ProjectDiagramResource, org.guvnor.common.services.shared.metadata.model.Metadata>> getSaveAndRenameServiceCaller() {
        return this.projectDiagramResourceServiceCaller;
    }

    protected Supplier<ProjectDiagramResource> getContentSupplier() {
        return () -> this.getEditorProxy().getContentSupplier().get();
    }

    protected ProjectDiagramEditorProxy getEditorProxy() {
        return this.editorProxy;
    }

    protected Integer getCurrentContentHash() {
        return this.getCurrentDiagramHash();
    }

    protected void doOpen() {
    }

    protected void doFocus() {
        if (null != this.getSessionPresenter()) {
            this.getSessionPresenter().focus();
        }
    }

    protected void doLostFocus() {
        if (null != this.getSessionPresenter()) {
            this.getSessionPresenter().lostFocus();
        }
    }

    protected void doClose() {
        this.menuItems.clear();
        this.menuSessionItems.destroy();
        this.destroySession();
    }

    protected void showLoadingViews() {
        this.getView().showLoading();
    }

    protected void showSavingViews() {
        this.getView().showSaving();
    }

    protected void hideLoadingViews() {
        this.getView().hideBusyIndicator();
    }

    void onSessionErrorEvent(@Observes OnSessionErrorEvent errorEvent) {
        if (this.isSameSession(errorEvent.getSession())) {
            this.executeWithConfirm(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.OnErrorConfirmUndoLastAction", new Object[]{errorEvent.getError()}), () -> this.menuSessionItems.getCommands().getUndoSessionCommand().execute());
        }
    }

    protected boolean isSameSession(ClientSession other) {
        return null != other && null != this.getSession() && other.equals(this.getSession());
    }

    protected abstract String getEditorIdentifier();

    public String getTitleText() {
        return this.title;
    }

    protected Menus getMenus() {
        if (this.menus == null) {
            this.makeMenuBar();
        }
        return this.menus;
    }

    protected void onSave() {
        if (this.hasUnsavedChanges()) {
            super.onSave();
        } else if (!this.versionRecordManager.isCurrentLatest()) {
            super.onSave();
        } else {
            String message = CommonConstants.INSTANCE.NoChangesSinceLastSave();
            this.log(Level.INFO, message);
            this.doShowNoChangesSinceLastSaveMessage(message);
        }
    }

    protected void doShowNoChangesSinceLastSaveMessage(String message) {
        this.editorProxy.showNoChangesSinceLastSaveMessage(message);
    }

    protected void destroySession() {
        this.editorSessionPresenter.ifPresent(session -> {
            session.destroy();
            this.editorSessionPresenter = Optional.empty();
        });
        this.viewerSessionPresenter.ifPresent(session -> {
            session.destroy();
            this.viewerSessionPresenter = Optional.empty();
        });
        this.editorSessionPresenterInstances.destroyAll();
        this.viewerSessionPresenterInstances.destroyAll();
    }

    protected void updateTitle(String title) {
        this.title = this.formatTitle(title);
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, this.title));
    }

    protected String formatTitle(String title) {
        if (Objects.isNull(this.resourceType)) {
            return title;
        }
        return TITLE_FORMAT_TEMPLATE.replace("#title", title).replace("#suffix", this.resourceType.getSuffix()).replace("#type", this.resourceType.getShortName());
    }

    private ClientSession getSession() {
        return null != this.getSessionPresenter() ? (ClientSession)this.getSessionPresenter().getInstance() : null;
    }

    protected int getCurrentDiagramHash() {
        return this.editorProxy.getEditorHashCode();
    }

    protected CanvasHandler getCanvasHandler() {
        return null != this.getSession() ? this.getSession().getCanvasHandler() : null;
    }

    protected ProjectDiagram getDiagram() {
        return null != this.getCanvasHandler() ? (ProjectDiagram)this.getCanvasHandler().getDiagram() : null;
    }

    private void executeWithConfirm(String message, Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)message, null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    protected View getView() {
        return (View)this.baseView;
    }

    protected void onSaveSuccess() {
        String message = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramSaveSuccessful");
        this.log(Level.INFO, message);
        ((SessionPresenter.View)this.getSessionPresenter().getView()).showMessage(message);
        this.setOriginalHash(this.getCurrentDiagramHash());
    }

    protected void onSaveError(ClientRuntimeError error) {
        this.showError(error);
    }

    private void onValidationSuccess() {
        this.log(Level.INFO, "Validation SUCCESS.");
    }

    protected void onValidationFailed(Collection<DiagramElementViolation<RuleViolation>> violations) {
        this.log(Level.WARNING, "Validation FAILED [violations=" + violations.toString() + "]");
        this.hideLoadingViews();
    }

    protected void onLoadError(ClientRuntimeError error) {
        Throwable e = error.getThrowable();
        if (e instanceof DiagramParsingException) {
            DiagramParsingException dpe = (DiagramParsingException)e;
            Metadata metadata = dpe.getMetadata();
            String xml = dpe.getXml();
            this.setOriginalHash(xml.hashCode());
            this.updateTitle(metadata.getTitle());
            this.resetEditorPages(((ProjectMetadata)metadata).getOverview());
            this.menuSessionItems.setEnabled(false);
            this.xmlEditorView.setReadOnly(this.isReadOnly);
            this.xmlEditorView.setContent(xml, AceEditorMode.XML);
            this.getView().setWidget((IsWidget)this.xmlEditorView.asWidget());
            this.editorProxy = this.makeXmlEditorProxy();
            this.hideLoadingViews();
            this.notification.fire((Object)new NotificationEvent(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramParsingError", new Object[]{Objects.toString(e.getMessage(), "")}), NotificationEvent.NotificationType.ERROR));
            Scheduler.get().scheduleDeferred(() -> ((TextEditorView)this.xmlEditorView).onResize());
        } else {
            this.editorProxy = ProjectDiagramEditorProxy.NULL_EDITOR;
            this.showError(error);
            this.placeManager.forceClosePlace((PlaceRequest)new PathPlaceRequest((Path)this.versionRecordManager.getCurrentPath(), this.getEditorIdentifier()));
        }
    }

    protected void showError(ClientRuntimeError error) {
        this.diagramClientErrorHandler.handleError(error, this::showError);
        this.log(Level.SEVERE, error.toString());
    }

    protected void showError(String message) {
        this.errorPopupPresenter.showMessage(message);
        this.hideLoadingViews();
    }

    protected void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    protected boolean hasUnsavedChanges() {
        return this.getCurrentDiagramHash() != this.originalHash.intValue();
    }

    private boolean verifyEventIdentifier(AbstractPlaceEvent event) {
        return Objects.equals(this.getEditorIdentifier(), event.getPlace().getIdentifier()) && Objects.equals(this.place, event.getPlace());
    }

    protected ClientTranslationService getTranslationService() {
        return this.translationService;
    }

    protected void makeAdditionalStunnerMenus(FileMenuBuilder fileMenuBuilder) {
    }

    public SessionPresenter<? extends ClientSession, ?, Diagram> getSessionPresenter() {
        if (this.editorSessionPresenter.isPresent()) {
            return (SessionPresenter)this.editorSessionPresenter.get();
        }
        if (this.viewerSessionPresenter.isPresent()) {
            return (SessionPresenter)this.viewerSessionPresenter.get();
        }
        return null;
    }

    public AbstractProjectEditorMenuSessionItems getMenuSessionItems() {
        return this.menuSessionItems;
    }

    protected void setEditorSessionPresenter(SessionEditorPresenter<EditorSession> presenter) {
        this.editorSessionPresenter = Optional.ofNullable(presenter);
    }

    protected void setReadOnlySessionPresenter(SessionViewerPresenter<ViewerSession> presenter) {
        this.viewerSessionPresenter = Optional.ofNullable(presenter);
    }

    public static interface View
    extends UberView<AbstractProjectDiagramEditor>,
    KieEditorView,
    RequiresResize,
    ProvidesResize,
    IsWidget {
        public void setWidget(IsWidget var1);
    }
}

