/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.client.widgets.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.client.widgets.explorer.tree.TreeExplorer;
import org.kie.workbench.common.stunner.client.widgets.presenters.Viewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionDiagramPreview;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.client.session.event.SessionOpenedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProjectDiagramExplorerScreen")
public class ProjectDiagramExplorerScreen {
    public static final String SCREEN_ID = "ProjectDiagramExplorerScreen";
    public static final String TITLE = "Explore";
    public static final int PREVIEW_WIDTH = 350;
    public static final int PREVIEW_HEIGHT = 175;
    private static Logger LOGGER = Logger.getLogger(ProjectDiagramExplorerScreen.class.getName());
    private final SessionManager clientSessionManager;
    private final ManagedInstance<TreeExplorer> treeExplorers;
    private final ManagedInstance<SessionDiagramPreview<AbstractSession>> sessionPreviews;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private final ErrorPopupPresenter errorPopupPresenter;
    private final View view;
    private PlaceRequest placeRequest;
    private String title = "Explore";
    private TreeExplorer explorerWidget;
    private SessionDiagramPreview<AbstractSession> previewWidget;

    protected ProjectDiagramExplorerScreen() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public ProjectDiagramExplorerScreen(SessionManager clientSessionManager, @Any ManagedInstance<TreeExplorer> treeExplorers, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, @Any @Default ManagedInstance<SessionDiagramPreview<AbstractSession>> sessionPreviews, ErrorPopupPresenter errorPopupPresenter, View view) {
        this.clientSessionManager = clientSessionManager;
        this.treeExplorers = treeExplorers;
        this.changeTitleNotificationEvent = changeTitleNotificationEvent;
        this.sessionPreviews = sessionPreviews;
        this.errorPopupPresenter = errorPopupPresenter;
        this.view = view;
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
    }

    @OnOpen
    public void onOpen() {
        ClientSession current = this.clientSessionManager.getCurrentSession();
        if (null != current) {
            this.show(current);
        }
    }

    @OnClose
    public void onClose() {
        this.close();
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return null;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return this.view;
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "projectDiagramExplorerScreenContext";
    }

    public void show(ClientSession session) {
        if (null != session.getCanvasHandler().getDiagram()) {
            this.showPreview(session);
            this.showExplorer(session);
            this.updateTitle(session);
        }
    }

    public void close() {
        this.closeTreeExplorer();
        this.closePreview();
    }

    private void closeTreeExplorer() {
        this.view.clearExplorerWidget();
        if (null != this.explorerWidget) {
            this.treeExplorers.destroy((Object)this.explorerWidget);
            this.explorerWidget = null;
        }
    }

    private void closePreview() {
        this.view.clearPreviewWidget();
        if (null != this.previewWidget) {
            this.previewWidget.destroy();
            this.sessionPreviews.destroy(this.previewWidget);
            this.previewWidget = null;
        }
    }

    void onCanvasSessionOpened(@Observes SessionOpenedEvent sessionOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionOpenedEvent", (Object)sessionOpenedEvent);
        this.show(sessionOpenedEvent.getSession());
    }

    void onCanvasSessionDestroyed(@Observes SessionDestroyedEvent sessionDestroyedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDestroyedEvent", (Object)sessionDestroyedEvent);
        this.close();
    }

    void onSessionDiagramOpenedEvent(@Observes SessionDiagramOpenedEvent sessionDiagramOpenedEvent) {
        PortablePreconditions.checkNotNull((String)"sessionDiagramOpenedEvent", (Object)sessionDiagramOpenedEvent);
        this.show(sessionDiagramOpenedEvent.getSession());
    }

    private void showExplorer(ClientSession session) {
        if (null != this.explorerWidget) {
            this.closeTreeExplorer();
        }
        this.explorerWidget = (TreeExplorer)this.treeExplorers.get();
        this.explorerWidget.show(session.getCanvasHandler());
        this.view.setExplorerWidget((IsWidget)this.explorerWidget);
    }

    private void showPreview(ClientSession session) {
        if (null != session && session instanceof AbstractSession) {
            if (null != this.previewWidget) {
                this.closePreview();
            }
            this.previewWidget = (SessionDiagramPreview)this.sessionPreviews.get();
            this.previewWidget.open((Object)((AbstractSession)session), 350, 175, (Viewer.Callback)new SessionViewer.SessionViewerCallback<Diagram>(){

                public void afterCanvasInitialized() {
                }

                public void onSuccess() {
                    ProjectDiagramExplorerScreen.this.view.setPreviewWidget(ProjectDiagramExplorerScreen.this.previewWidget.getView());
                    ProjectDiagramExplorerScreen.this.updateTitle();
                }

                public void onError(ClientRuntimeError error) {
                    ProjectDiagramExplorerScreen.this.showError(error);
                }
            });
        }
    }

    private void updateTitle() {
        ClientSession session = this.clientSessionManager.getCurrentSession();
        this.updateTitle(session);
    }

    private void updateTitle(ClientSession session) {
        String title = TITLE;
        if (null != session.getCanvasHandler() && null != session.getCanvasHandler().getDiagram()) {
            Diagram diagram = session.getCanvasHandler().getDiagram();
            title = diagram.getMetadata().getTitle();
        }
        this.doUpdateTitle(title);
    }

    private void doUpdateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, this.title));
    }

    private void showError(ClientRuntimeError error) {
        String s = error.toString();
        this.errorPopupPresenter.showMessage(s);
        LOGGER.log(Level.SEVERE, s);
    }

    public static interface View
    extends IsWidget {
        public View setPreviewWidget(IsWidget var1);

        public View clearPreviewWidget();

        public View setExplorerWidget(IsWidget var1);

        public View clearExplorerWidget();

        public View clear();
    }
}

