/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.stunner.client.widgets.event.SessionDiagramOpenedEvent;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.forms.client.event.FormPropertiesOpened;
import org.kie.workbench.common.stunner.forms.client.widgets.FormPropertiesWidget;
import org.kie.workbench.common.stunner.project.client.view.ProjectScreenView;
import org.uberfire.client.annotations.WorkbenchContextId;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="ProjectDiagramPropertiesScreen")
public class ProjectDiagramPropertiesScreen {
    private static Logger LOGGER = Logger.getLogger(ProjectDiagramPropertiesScreen.class.getName());
    public static final String SCREEN_ID = "ProjectDiagramPropertiesScreen";
    private final FormPropertiesWidget formPropertiesWidget;
    private final SessionManager clientSessionManager;
    private final Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent;
    private final ProjectScreenView view;
    private PlaceRequest placeRequest;
    private ClientSession session;
    private String title = "Properties";
    private boolean open = false;

    protected ProjectDiagramPropertiesScreen() {
        this(null, null, null, null);
    }

    @Inject
    public ProjectDiagramPropertiesScreen(FormPropertiesWidget formPropertiesWidget, SessionManager clientSessionManager, Event<ChangeTitleWidgetEvent> changeTitleNotification, ProjectScreenView view) {
        this.formPropertiesWidget = formPropertiesWidget;
        this.clientSessionManager = clientSessionManager;
        this.changeTitleNotificationEvent = changeTitleNotification;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.setWidget((IsWidget)ElementWrapperWidget.getWidget((HTMLElement)this.formPropertiesWidget.getElement()));
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
    }

    @OnOpen
    public void onOpen() {
        this.log(Level.FINE, "Opening ProjectDiagramPropertiesScreen.");
        this.open = true;
        ClientSession current = this.clientSessionManager.getCurrentSession();
        this.handleSession(current);
    }

    @OnClose
    public void onClose() {
        this.log(Level.FINE, "Closing ProjectDiagramPropertiesScreen.");
        this.open = false;
        this.destroy();
    }

    private void handleSession(ClientSession session) {
        boolean done = false;
        this.view.showLoading();
        if (null != session) {
            this.session = session;
            this.view.showLoading();
            this.formPropertiesWidget.bind(session).show(this.view::hideLoading);
            done = true;
        }
        if (!done) {
            this.formPropertiesWidget.unbind();
            this.view.hideLoading();
            this.session = null;
        }
    }

    private void destroy() {
        this.formPropertiesWidget.destroy();
        this.session = null;
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return null;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.title;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return ElementWrapperWidget.getWidget((HTMLElement)this.formPropertiesWidget.getElement());
    }

    @WorkbenchContextId
    public String getMyContextRef() {
        return "projectDiagramPropertiesScreenContext";
    }

    void onFormPropertiesOpened(@Observes FormPropertiesOpened propertiesOpened) {
        if (null != this.session && this.session.equals(propertiesOpened.getSession())) {
            this.updateTitle(propertiesOpened.getName());
        }
    }

    void onSessionOpened(@Observes SessionDiagramOpenedEvent event) {
        if (this.open && !event.getSession().equals(this.session)) {
            this.log(Level.FINE, "ProjectDiagramPropertiesScreen -> Current Session Changed.");
            this.handleSession(this.clientSessionManager.getCurrentSession());
        }
    }

    private void updateTitle(String title) {
        this.title = title;
        this.changeTitleNotificationEvent.fire((Object)new ChangeTitleWidgetEvent(this.placeRequest, this.title));
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

