/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.service;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Specializes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramServiceImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.command.event.SaveDiagramSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.service.DiagramLookupService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramService;
import org.uberfire.backend.vfs.Path;

@Dependent
@Specializes
public class ClientProjectDiagramService
extends ClientDiagramServiceImpl<ProjectMetadata, ProjectDiagram, ProjectDiagramService> {
    protected ClientProjectDiagramService() {
        this(null, null, null, null);
    }

    @Inject
    public ClientProjectDiagramService(ShapeManager shapeManager, Caller<ProjectDiagramService> diagramServiceCaller, Caller<DiagramLookupService> diagramLookupServiceCaller, Event<SaveDiagramSessionCommandExecutedEvent> saveEvent) {
        super(shapeManager, diagramServiceCaller, diagramLookupServiceCaller, saveEvent);
    }

    public void create(Path path, String name, String defSetId, String projName, Package projPkg, ServiceCallback<Path> callback) {
        ((ProjectDiagramService)this.diagramServiceCaller.call(arg_0 -> callback.onSuccess(arg_0), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).create(path, name, defSetId, projName, projPkg);
    }

    public void saveOrUpdate(Path path, ProjectDiagram diagram, Metadata metadata, String comment, ServiceCallback<ProjectDiagram> callback) {
        ((ProjectDiagramService)this.diagramServiceCaller.call(v -> {
            this.updateClientMetadata((Diagram)diagram);
            callback.onSuccess((Object)diagram);
            this.fireSavedEvent((Diagram)diagram);
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).save(path, (Object)diagram, metadata, comment);
    }

    public void saveAsXml(Path path, String xml, Metadata metadata, String comment, ServiceCallback<String> callback) {
        ((ProjectDiagramService)this.diagramServiceCaller.call(v -> callback.onSuccess((Object)xml), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).saveAsXml(path, xml, metadata, comment);
    }
}

