/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.kie.workbench.common.stunner.client.widgets.menu.MenuUtils;
import org.kie.workbench.common.stunner.client.widgets.popups.PopupUtil;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class AbstractProjectDiagramEditorMenuItemsBuilder {
    protected final ClientTranslationService translationService;
    protected final PopupUtil popupUtil;

    protected AbstractProjectDiagramEditorMenuItemsBuilder() {
        this(null, null);
    }

    public AbstractProjectDiagramEditorMenuItemsBuilder(ClientTranslationService translationService, PopupUtil popupUtil) {
        this.translationService = translationService;
        this.popupUtil = popupUtil;
    }

    public MenuItem newVisitGraphItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildVisitGraphItem(command));
    }

    private IsWidget buildVisitGraphItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.PLAY);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.VisitGraph"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newSwitchGridItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildSwitchGridItem(command));
    }

    private IsWidget buildSwitchGridItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.TH);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.SwitchGrid"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newClearItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildClearItem(command));
    }

    private IsWidget buildClearItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.ERASER);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram"));
                this.addClickHandler(clickEvent -> AbstractProjectDiagramEditorMenuItemsBuilder.this.executeWithConfirm(command, AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram"), AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ClearDiagram"), AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ConfirmClearDiagram")));
            }
        });
    }

    public MenuItem newCopyItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildCopyItem(command));
    }

    private IsWidget buildCopyItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.COPY);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.CopySelection"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newPasteItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildPasteItem(command));
    }

    private IsWidget buildPasteItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.PASTE);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.PasteSelection"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newCutItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildCutItem(command));
    }

    private IsWidget buildCutItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.CUT);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.CutSelection"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newDeleteSelectionItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildDeleteSelectionItem(command));
    }

    private IsWidget buildDeleteSelectionItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.TRASH_O);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.DeleteSelection"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newUndoItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildUndoItem(command));
    }

    private IsWidget buildUndoItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.UNDO);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.Undo"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newRedoItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildRedoItem(command));
    }

    private IsWidget buildRedoItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.UNDO);
                this.addStyleName("fa-flip-horizontal");
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.Redo"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    public MenuItem newExportsItem(Command exportPNGCommand, Command exportJPGCommand, Command exportSVGCommand, Command exportPDFCommand, Command exportAsRawCommand) {
        DropDownMenu menu = (DropDownMenu)GWT.create(DropDownMenu.class);
        menu.setPull(Pull.RIGHT);
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportPNG"), exportPNGCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportJPG"), exportJPGCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportSVG"), exportSVGCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.ExportPDF"), exportPDFCommand));
        menu.add((Widget)this.makeExportMenuItemWidget(this.getExportAsRawLabel(), exportAsRawCommand));
        Button button = (Button)GWT.create(Button.class);
        ButtonGroup buttonGroup = (ButtonGroup)GWT.create(ButtonGroup.class);
        buttonGroup.add((Widget)button);
        buttonGroup.add((Widget)menu);
        button.setToggleCaret(true);
        button.setDataToggle(Toggle.DROPDOWN);
        button.setIcon(IconType.DOWNLOAD);
        button.setSize(ButtonSize.SMALL);
        button.setTitle(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DownloadDiagram"));
        MenuUtils.HasEnabledIsWidget group = MenuUtils.buildHasEnabledWidget((ButtonGroup)buttonGroup, (Button)button);
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem((IsWidget)group);
    }

    private AnchorListItem makeExportMenuItemWidget(String caption, Command onClickCommand) {
        AnchorListItem exportMenuItemWidget = (AnchorListItem)GWT.create(AnchorListItem.class);
        exportMenuItemWidget.setIcon(IconType.FILE_IMAGE_O);
        exportMenuItemWidget.setIconPosition(IconPosition.LEFT);
        exportMenuItemWidget.setText(caption);
        exportMenuItemWidget.setTitle(caption);
        exportMenuItemWidget.addClickHandler(event -> onClickCommand.execute());
        return exportMenuItemWidget;
    }

    protected abstract String getExportAsRawLabel();

    public MenuItem newValidateItem(Command command) {
        return AbstractProjectDiagramEditorMenuItemsBuilder.buildItem(this.buildValidateItem(command));
    }

    private IsWidget buildValidateItem(final Command command) {
        return MenuUtils.buildHasEnabledWidget((Button)new Button(){
            {
                this.setSize(ButtonSize.SMALL);
                this.setIcon(IconType.CHECK);
                this.setTitle(AbstractProjectDiagramEditorMenuItemsBuilder.this.translationService.getValue("org.kie.workbench.common.stunner.core.client.toolbox.Validate"));
                this.addClickHandler(clickEvent -> command.execute());
            }
        });
    }

    private void executeWithConfirm(Command command, String title, String okButtonText, String confirmMessage) {
        this.popupUtil.showConfirmPopup(title, okButtonText, confirmMessage, command);
    }

    public static MenuItem buildItem(IsWidget widget) {
        return MenuUtils.buildItem((IsWidget)widget);
    }

    public ClientTranslationService getTranslationService() {
        return this.translationService;
    }

    public PopupUtil getPopupUtil() {
        return this.popupUtil;
    }
}

