/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.project.editor.ProjectDiagramResource;
import org.uberfire.mvp.Command;

public class ProjectDiagramEditorProxy {
    static final ProjectDiagramEditorProxy NULL_EDITOR = new ProjectDiagramEditorProxy();
    private Optional<Consumer<Command>> saveAfterValidationConsumer;
    private Optional<Consumer<String>> saveAfterUserConfirmationConsumer;
    private Optional<Consumer<String>> showNoChangesSinceLastSaveMessageConsumer;
    private Optional<Supplier<Integer>> hashCodeSupplier;
    private Supplier<ProjectDiagramResource> contentSupplier = () -> null;

    public ProjectDiagramEditorProxy() {
        this.saveAfterValidationConsumer = Optional.empty();
        this.saveAfterUserConfirmationConsumer = Optional.empty();
        this.showNoChangesSinceLastSaveMessageConsumer = Optional.empty();
        this.hashCodeSupplier = Optional.empty();
    }

    void setSaveAfterValidationConsumer(Consumer<Command> saveAfterValidationConsumer) {
        this.saveAfterValidationConsumer = Optional.ofNullable(saveAfterValidationConsumer);
    }

    void setSaveAfterUserConfirmationConsumer(Consumer<String> saveAfterUserConfirmationConsumer) {
        this.saveAfterUserConfirmationConsumer = Optional.ofNullable(saveAfterUserConfirmationConsumer);
    }

    void setShowNoChangesSinceLastSaveMessageConsumer(Consumer<String> showNoChangesSinceLastSaveMessageConsumer) {
        this.showNoChangesSinceLastSaveMessageConsumer = Optional.ofNullable(showNoChangesSinceLastSaveMessageConsumer);
    }

    void setHashCodeSupplier(Supplier<Integer> hashCodeSupplier) {
        this.hashCodeSupplier = Optional.ofNullable(hashCodeSupplier);
    }

    void saveAfterValidation(Command command) {
        this.saveAfterValidationConsumer.orElse(c -> {}).accept(command);
    }

    void saveAfterUserConfirmation(String commitMessage) {
        this.saveAfterUserConfirmationConsumer.orElse(s -> {}).accept(commitMessage);
    }

    void showNoChangesSinceLastSaveMessage(String message) {
        this.showNoChangesSinceLastSaveMessageConsumer.orElse(s -> {}).accept(message);
    }

    int getEditorHashCode() {
        return this.hashCodeSupplier.orElse(() -> 0).get();
    }

    public Supplier<ProjectDiagramResource> getContentSupplier() {
        return this.contentSupplier;
    }

    public void setContentSupplier(Supplier<ProjectDiagramResource> contentSupplier) {
        this.contentSupplier = contentSupplier;
    }
}

