/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.ui.IsWidget;
import elemental2.promise.Promise;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.OnSessionErrorEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.documentation.DocumentationPage;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.kogito.client.editor.DiagramEditorCore;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.kogito.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditorCore;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorProxy;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.editor.ProjectDiagramResource;
import org.kie.workbench.common.stunner.project.diagram.editor.impl.ProjectDiagramResourceImpl;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.client.workbench.widgets.multipage.Page;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractProjectDiagramEditor<R extends ClientResourceType>
extends KieEditor<ProjectDiagramResource>
implements DiagramEditorCore<ProjectMetadata, ProjectDiagram> {
    private static final Logger LOGGER = Logger.getLogger(AbstractProjectDiagramEditor.class.getName());
    private static final String TITLE_FORMAT_TEMPLATE = "#title.#suffix - #type";
    private final AbstractDiagramEditorMenuSessionItems<?> menuSessionItems;
    private final Event<OnDiagramFocusEvent> onDiagramFocusEvent;
    private final Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent;
    private final ClientTranslationService translationService;
    private final DocumentationView documentationView;
    private final R resourceType;
    private final ProjectMessagesListener projectMessagesListener;
    private final ClientProjectDiagramService projectDiagramServices;
    private final Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller;
    private String title = "Project Diagram Editor";
    private boolean menuBarInitialzed = false;
    private final AbstractProjectDiagramEditorCore<ProjectMetadata, ProjectDiagram, ProjectDiagramResource, ProjectDiagramEditorProxy<ProjectDiagramResource>> editor;

    protected String getDiagramParsingErrorMessage(DiagramParsingException e) {
        return this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramParsingError", new Object[]{Objects.toString(e.getMessage(), "")});
    }

    public AbstractProjectDiagramEditor(View view, TextEditorView xmlEditorView, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, Event<NotificationEvent> notificationEvent, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, DocumentationView documentationView, R resourceType, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ProjectMessagesListener projectMessagesListener, ClientTranslationService translationService, ClientProjectDiagramService projectDiagramServices, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller) {
        super((KieEditorView)view);
        this.menuSessionItems = menuSessionItems;
        this.onDiagramFocusEvent = onDiagramFocusEvent;
        this.onDiagramLostFocusEvent = onDiagramLostFocusEvent;
        this.translationService = translationService;
        this.documentationView = documentationView;
        this.resourceType = resourceType;
        this.projectMessagesListener = projectMessagesListener;
        this.projectDiagramServices = projectDiagramServices;
        this.projectDiagramResourceServiceCaller = projectDiagramResourceServiceCaller;
        this.editor = this.makeCore(view, xmlEditorView, notificationEvent, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService);
    }

    protected AbstractProjectDiagramEditorCore<ProjectMetadata, ProjectDiagram, ProjectDiagramResource, ProjectDiagramEditorProxy<ProjectDiagramResource>> makeCore(View view, TextEditorView xmlEditorView, Event<NotificationEvent> notificationEvent, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService) {
        return new ProjectDiagramEditorCore(view, xmlEditorView, notificationEvent, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService);
    }

    @PostConstruct
    public void init() {
        this.title = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramEditorDefaultTitle");
        this.projectMessagesListener.enable();
        this.menuSessionItems.setLoadingStarts(this::showLoadingViews).setLoadingCompleted(this::hideLoadingViews).setErrorConsumer(arg_0 -> this.editor.showError(arg_0));
    }

    protected void doStartUp(ObservablePath path, PlaceRequest place) {
        this.init(path, place, (ClientResourceType)this.resourceType);
    }

    protected void loadContent() {
        this.destroySession();
        this.projectDiagramServices.getByPath((Path)this.versionRecordManager.getCurrentPath(), (ServiceCallback)new ServiceCallback<ProjectDiagram>(){

            public void onSuccess(ProjectDiagram item) {
                AbstractProjectDiagramEditor.this.editor.open((Diagram)item);
            }

            public void onError(ClientRuntimeError error) {
                AbstractProjectDiagramEditor.this.editor.onLoadError(error);
            }
        });
    }

    protected boolean isReadOnly() {
        return this.isReadOnly;
    }

    protected void onValidate(Command finished) {
        this.log(Level.INFO, "Validation SUCCESS.");
        this.hideLoadingViews();
        finished.execute();
    }

    protected void save() {
        Command continueSaveOnceValid = () -> {
            if (this.saveWithComments) {
                super.save();
            } else {
                this.save("");
            }
        };
        this.doSave(continueSaveOnceValid);
    }

    protected void doSave(Command continueSaveOnceValid) {
        ((ProjectDiagramEditorProxy)this.editor.getEditorProxy()).saveAfterValidation(continueSaveOnceValid);
    }

    protected void save(String commitMessage) {
        super.save(commitMessage);
        this.doSave(commitMessage);
    }

    protected void doSave(String commitMessage) {
        ((ProjectDiagramEditorProxy)this.editor.getEditorProxy()).saveAfterUserConfirmation(commitMessage);
    }

    public RemoteCallback<Path> getSaveSuccessCallback(int newHash) {
        return path -> {
            this.versionRecordManager.reloadVersions(path);
            this.setOriginalHash(newHash);
        };
    }

    public void hideDocks() {
        super.hideDocks();
        this.onDiagramLostFocusEvent.fire((Object)new OnDiagramLoseFocusEvent());
    }

    public void showDocks() {
        this.onDiagramFocusEvent.fire((Object)new OnDiagramFocusEvent(this.getDockQualifiers()));
        super.showDocks();
    }

    public abstract String getEditorIdentifier();

    protected Promise<Void> makeMenuBar() {
        if (!this.menuBarInitialzed) {
            this.menuSessionItems.populateMenu(this.fileMenuBuilder);
            this.makeAdditionalStunnerMenus(this.fileMenuBuilder);
            if (this.workbenchContext.getActiveWorkspaceProject().isPresent()) {
                WorkspaceProject activeProject = (WorkspaceProject)this.workbenchContext.getActiveWorkspaceProject().get();
                return this.projectController.canUpdateProject(activeProject).then(canUpdateProject -> {
                    if (canUpdateProject.booleanValue()) {
                        ParameterizedCommand onSave = withComments -> {
                            this.saveWithComments = withComments;
                            this.saveAction();
                        };
                        this.fileMenuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(onSave)).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.assetUpdateValidator).addRename(this.getSaveAndRename()).addDelete((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.assetUpdateValidator);
                    }
                    this.addDownloadMenuItem(this.fileMenuBuilder);
                    this.fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
                    this.menuBarInitialzed = true;
                    return this.promises.resolve();
                });
            }
        }
        return this.promises.resolve();
    }

    protected Command getSaveAndRename() {
        return super.getSaveAndRename();
    }

    protected Caller<? extends SupportsSaveAndRename<ProjectDiagramResource, org.guvnor.common.services.shared.metadata.model.Metadata>> getSaveAndRenameServiceCaller() {
        return this.projectDiagramResourceServiceCaller;
    }

    protected Supplier<ProjectDiagramResource> getContentSupplier() {
        return ((ProjectDiagramEditorProxy)this.editor.getEditorProxy()).getContentSupplier();
    }

    protected Integer getCurrentContentHash() {
        return this.editor.getCurrentDiagramHash();
    }

    protected void doOpen() {
    }

    protected void doClose() {
        this.menuItems.clear();
        this.menuSessionItems.destroy();
        this.destroySession();
    }

    protected void showLoadingViews() {
        this.getView().showLoading();
    }

    protected void showSavingViews() {
        this.getView().showSaving();
    }

    protected void hideLoadingViews() {
        this.getView().hideBusyIndicator();
    }

    void onSessionErrorEvent(@Observes OnSessionErrorEvent errorEvent) {
        if (this.isSameSession(errorEvent.getSession())) {
            this.executeWithConfirm(this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.OnErrorConfirmUndoLastAction", new Object[]{errorEvent.getError()}), () -> this.menuSessionItems.getCommands().getUndoSessionCommand().execute());
        }
    }

    protected boolean isSameSession(ClientSession other) {
        return null != other && null != this.getSession() && other.equals(this.getSession());
    }

    public String getTitleText() {
        return this.title;
    }

    protected void onSave() {
        if (this.hasUnsavedChanges()) {
            super.onSave();
        } else if (!this.versionRecordManager.isCurrentLatest()) {
            super.onSave();
        } else {
            String message = CommonConstants.INSTANCE.NoChangesSinceLastSave();
            this.log(Level.INFO, message);
            this.editor.doShowNoChangesSinceLastSaveMessage(message);
        }
    }

    protected void updateTitle(String title) {
        this.title = this.formatTitle(title);
        this.changeTitleNotification.fire((Object)new ChangeTitleWidgetEvent(this.place, this.title));
    }

    protected String formatTitle(String title) {
        if (Objects.isNull(this.resourceType)) {
            return title;
        }
        return TITLE_FORMAT_TEMPLATE.replace("#title", title).replace("#suffix", this.resourceType.getSuffix()).replace("#type", this.resourceType.getShortName());
    }

    private ClientSession getSession() {
        return null != this.editor.getSessionPresenter() ? (ClientSession)this.editor.getSessionPresenter().getInstance() : null;
    }

    private void executeWithConfirm(String message, Command command) {
        Command yesCommand = () -> ((Command)command).execute();
        Command noCommand = () -> {};
        YesNoCancelPopup popup = YesNoCancelPopup.newYesNoCancelPopup((String)message, null, (Command)yesCommand, (Command)noCommand, (Command)noCommand);
        popup.show();
    }

    protected View getView() {
        return (View)this.baseView;
    }

    protected void onSaveSuccess() {
        String message = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.DiagramSaveSuccessful");
        this.log(Level.INFO, message);
        ((SessionPresenter.View)this.editor.getSessionPresenter().getView()).showMessage(message);
        this.setOriginalHash(this.editor.getCurrentDiagramHash());
    }

    public void open(ProjectDiagram diagram) {
        this.editor.open((Diagram)diagram);
    }

    public Annotation[] getDockQualifiers() {
        return new Annotation[]{DefinitionManager.DEFAULT_QUALIFIER};
    }

    public void initialiseKieEditorForSession(ProjectDiagram diagram) {
        this.resetEditorPages(((ProjectMetadata)diagram.getMetadata()).getOverview());
        this.updateTitle(((ProjectMetadata)diagram.getMetadata()).getTitle());
        this.addDocumentationPage(diagram);
        this.setOriginalHash(this.getCurrentDiagramHash());
        this.hideLoadingViews();
        this.onDiagramLoad();
    }

    protected void destroySession() {
        this.editor.destroySession();
    }

    public void addDocumentationPage(ProjectDiagram diagram) {
        Optional.ofNullable(this.documentationView.isEnabled()).filter(Boolean.TRUE::equals).ifPresent(enabled -> {
            String label = this.translationService.getValue("org.kie.workbench.common.stunner.project.client.editor.Documentation");
            this.addPage((Page)new DocumentationPage(this.documentationView.initialize((Diagram)diagram), label, () -> this.onDiagramFocusEvent.fire((Object)new OnDiagramFocusEvent(this.getDockQualifiers())), () -> Objects.equals(2, this.kieView.getSelectedTabIndex())));
        });
    }

    protected void onDiagramLoad() {
    }

    public SessionEditorPresenter<EditorSession> newSessionEditorPresenter() {
        return this.editor.newSessionEditorPresenter();
    }

    public SessionViewerPresenter<ViewerSession> newSessionViewerPresenter() {
        return this.editor.newSessionViewerPresenter();
    }

    public int getCurrentDiagramHash() {
        return this.editor.getCurrentDiagramHash();
    }

    public CanvasHandler getCanvasHandler() {
        return this.editor.getCanvasHandler();
    }

    public void onSaveError(ClientRuntimeError error) {
        this.editor.onSaveError(error);
    }

    public SessionPresenter<? extends ClientSession, ?, Diagram> getSessionPresenter() {
        return this.editor.getSessionPresenter();
    }

    public void doFocus() {
        this.editor.doFocus();
    }

    public void doLostFocus() {
        this.editor.doLostFocus();
    }

    protected void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }

    protected boolean hasUnsavedChanges() {
        return this.editor.getCurrentDiagramHash() != this.originalHash.intValue();
    }

    protected ClientTranslationService getTranslationService() {
        return this.translationService;
    }

    protected void makeAdditionalStunnerMenus(FileMenuBuilder fileMenuBuilder) {
    }

    public AbstractDiagramEditorMenuSessionItems getMenuSessionItems() {
        return this.menuSessionItems;
    }

    public class ProjectDiagramEditorCore
    extends AbstractProjectDiagramEditorCore<ProjectMetadata, ProjectDiagram, ProjectDiagramResource, ProjectDiagramEditorProxy<ProjectDiagramResource>> {
        public ProjectDiagramEditorCore(View baseEditorView, TextEditorView xmlEditorView, Event<NotificationEvent> notificationEvent, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService) {
            super(baseEditorView, xmlEditorView, notificationEvent, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService);
        }

        protected boolean isReadOnly() {
            return AbstractProjectDiagramEditor.this.isReadOnly();
        }

        protected ProjectDiagramResourceImpl makeDiagramResourceImpl(ProjectDiagram diagram) {
            return new ProjectDiagramResourceImpl(diagram);
        }

        protected ProjectDiagramResourceImpl makeDiagramResourceImpl(String xml) {
            return new ProjectDiagramResourceImpl(xml);
        }

        protected ProjectDiagramEditorProxy<ProjectDiagramResource> makeEditorProxy() {
            return new ProjectDiagramEditorProxy<ProjectDiagramResource>();
        }

        public Annotation[] getDockQualifiers() {
            return AbstractProjectDiagramEditor.this.getDockQualifiers();
        }

        public void initialiseKieEditorForSession(ProjectDiagram diagram) {
            AbstractProjectDiagramEditor.this.initialiseKieEditorForSession(diagram);
        }

        @Override
        protected void saveOrUpdate(String commitMessage) {
            final ObservablePath diagramPath = AbstractProjectDiagramEditor.this.versionRecordManager.getCurrentPath();
            AbstractProjectDiagramEditor.this.projectDiagramServices.saveOrUpdate((Path)diagramPath, (ProjectDiagram)this.getDiagram(), AbstractProjectDiagramEditor.this.metadata, commitMessage, new ServiceCallback<ProjectDiagram>(){

                public void onSuccess(ProjectDiagram item) {
                    AbstractProjectDiagramEditor.this.getSaveSuccessCallback(item.hashCode()).callback((Object)diagramPath);
                    AbstractProjectDiagramEditor.this.onSaveSuccess();
                    AbstractProjectDiagramEditor.this.hideLoadingViews();
                }

                public void onError(ClientRuntimeError error) {
                    ProjectDiagramEditorCore.this.onSaveError(error);
                }
            });
        }

        @Override
        protected void saveAsXML(String commitMessage) {
            final ObservablePath diagramPath = AbstractProjectDiagramEditor.this.versionRecordManager.getCurrentPath();
            AbstractProjectDiagramEditor.this.projectDiagramServices.saveAsXml((Path)diagramPath, this.getXMLEditorView().getContent(), AbstractProjectDiagramEditor.this.metadata, commitMessage, new ServiceCallback<String>(){

                public void onSuccess(String xml) {
                    AbstractProjectDiagramEditor.this.getSaveSuccessCallback(xml.hashCode()).callback((Object)diagramPath);
                    AbstractProjectDiagramEditor.this.notification.fire((Object)new NotificationEvent(org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants.INSTANCE.ItemSavedSuccessfully()));
                    AbstractProjectDiagramEditor.this.hideLoadingViews();
                }

                public void onError(ClientRuntimeError error) {
                    ProjectDiagramEditorCore.this.onSaveError(error);
                }
            });
        }

        public String getEditorIdentifier() {
            return AbstractProjectDiagramEditor.this.getEditorIdentifier();
        }

        public void onLoadError(ClientRuntimeError error) {
            Throwable e = error.getThrowable();
            if (e instanceof DiagramParsingException) {
                DiagramParsingException dpe = (DiagramParsingException)e;
                Metadata metadata = dpe.getMetadata();
                String xml = dpe.getXml();
                AbstractProjectDiagramEditor.this.setOriginalHash(xml.hashCode());
                AbstractProjectDiagramEditor.this.updateTitle(metadata.getTitle());
                AbstractProjectDiagramEditor.this.resetEditorPages(((ProjectMetadata)metadata).getOverview());
                AbstractProjectDiagramEditor.this.menuSessionItems.setEnabled(false);
                this.getXMLEditorView().setReadOnly(AbstractProjectDiagramEditor.this.isReadOnly);
                this.getXMLEditorView().setContent(xml, AceEditorMode.XML);
                AbstractProjectDiagramEditor.this.getView().setWidget((IsWidget)this.getXMLEditorView().asWidget());
                this.setEditorProxy(this.makeXmlEditorProxy());
                AbstractProjectDiagramEditor.this.hideLoadingViews();
                AbstractProjectDiagramEditor.this.notification.fire((Object)new NotificationEvent(AbstractProjectDiagramEditor.this.getDiagramParsingErrorMessage(dpe), NotificationEvent.NotificationType.ERROR));
                Scheduler.get().scheduleDeferred(() -> ((TextEditorView)this.getXMLEditorView()).onResize());
            } else {
                this.setEditorProxy(this.makeEditorProxy());
                this.showError(error);
                AbstractProjectDiagramEditor.this.placeManager.forceClosePlace((PlaceRequest)new PathPlaceRequest((Path)AbstractProjectDiagramEditor.this.versionRecordManager.getCurrentPath(), this.getEditorIdentifier()));
            }
        }
    }

    public static interface View
    extends DiagramEditorCore.View,
    KieEditorView {
    }
}

