/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.editor;

import java.util.Collection;
import java.util.logging.Level;
import javax.enterprise.event.Event;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionEditorPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.SessionViewerPresenter;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ViewerSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.validation.DiagramElementViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.kie.workbench.common.stunner.core.validation.impl.ValidationUtils;
import org.kie.workbench.common.stunner.kogito.api.editor.KogitoDiagramResource;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditorCore;
import org.kie.workbench.common.stunner.kogito.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.kogito.client.editor.DiagramEditorCore;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorProxy;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.widgets.core.client.editors.texteditor.TextEditorView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class AbstractProjectDiagramEditorCore<M extends Metadata, D extends Diagram<Graph, M>, C extends KogitoDiagramResource<D>, P extends ProjectDiagramEditorProxy<C>>
extends AbstractDiagramEditorCore<M, D, C, P> {
    public AbstractProjectDiagramEditorCore(DiagramEditorCore.View baseEditorView, TextEditorView xmlEditorView, Event<NotificationEvent> notificationEvent, ManagedInstance<SessionEditorPresenter<EditorSession>> editorSessionPresenterInstances, ManagedInstance<SessionViewerPresenter<ViewerSession>> viewerSessionPresenterInstances, AbstractDiagramEditorMenuSessionItems<?> menuSessionItems, ErrorPopupPresenter errorPopupPresenter, DiagramClientErrorHandler diagramClientErrorHandler, ClientTranslationService translationService) {
        super(baseEditorView, xmlEditorView, notificationEvent, editorSessionPresenterInstances, viewerSessionPresenterInstances, menuSessionItems, errorPopupPresenter, diagramClientErrorHandler, translationService);
    }

    protected abstract void saveOrUpdate(String var1);

    protected abstract void saveAsXML(String var1);

    public P makeStunnerEditorProxy() {
        ProjectDiagramEditorProxy proxy = (ProjectDiagramEditorProxy)super.makeStunnerEditorProxy();
        proxy.setSaveAfterValidationConsumer(continueSaveOnceValid -> this.getMenuSessionItems().getCommands().getValidateSessionCommand().execute(this.getSaveAfterValidationCallback((Command)continueSaveOnceValid)));
        proxy.setSaveAfterUserConfirmationConsumer(this::saveOrUpdate);
        proxy.setShowNoChangesSinceLastSaveMessageConsumer(message -> ((SessionPresenter.View)this.getSessionPresenter().getView()).showMessage(message));
        return (P)((Object)proxy);
    }

    protected ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>> getSaveAfterValidationCallback(final Command continueSaveOnceValid) {
        return new ClientSessionCommand.Callback<Collection<DiagramElementViolation<RuleViolation>>>(){

            public void onSuccess() {
                continueSaveOnceValid.execute();
            }

            public void onError(Collection<DiagramElementViolation<RuleViolation>> violations) {
                Violation.Type maxSeverity = ValidationUtils.getMaxSeverity(violations);
                if (maxSeverity.equals((Object)Violation.Type.ERROR)) {
                    AbstractProjectDiagramEditorCore.this.onValidationFailed(violations);
                } else {
                    continueSaveOnceValid.execute();
                }
            }
        };
    }

    public P makeXmlEditorProxy() {
        ProjectDiagramEditorProxy proxy = (ProjectDiagramEditorProxy)super.makeXmlEditorProxy();
        proxy.setSaveAfterValidationConsumer(Command::execute);
        proxy.setSaveAfterUserConfirmationConsumer(this::saveAsXML);
        proxy.setShowNoChangesSinceLastSaveMessageConsumer(message -> this.getNotificationEvent().fire((Object)new NotificationEvent(message)));
        return (P)((Object)proxy);
    }

    public void doShowNoChangesSinceLastSaveMessage(String message) {
        ((ProjectDiagramEditorProxy)this.getEditorProxy()).showNoChangesSinceLastSaveMessage(message);
    }

    void onValidationFailed(Collection<DiagramElementViolation<RuleViolation>> violations) {
        this.log(Level.WARNING, "Validation FAILED [violations=" + violations.toString() + "]");
        this.getBaseEditorView().hideBusyIndicator();
    }
}

